/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coursera.courier.api.CourierMapTemplateSpec;
import org.coursera.courier.api.CourierTemplateSpecGenerator;

public class ClassTemplateSpecs {
    public static Set<ClassTemplateSpec> directReferencedTypes(ClassTemplateSpec classTemplateSpec) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        if (classTemplateSpec instanceof RecordTemplateSpec) {
            RecordTemplateSpec recordTemplateSpec = (RecordTemplateSpec)classTemplateSpec;
            for (RecordTemplateSpec.Field field : recordTemplateSpec.getFields()) {
                hashSet.add(field.getType());
            }
        } else if (classTemplateSpec instanceof UnionTemplateSpec) {
            UnionTemplateSpec unionTemplateSpec = (UnionTemplateSpec)classTemplateSpec;
            for (UnionTemplateSpec.Member member : unionTemplateSpec.getMembers()) {
                hashSet.add(member.getClassTemplateSpec());
            }
        } else if (classTemplateSpec instanceof CourierMapTemplateSpec) {
            CourierMapTemplateSpec courierMapTemplateSpec = (CourierMapTemplateSpec)classTemplateSpec;
            if (courierMapTemplateSpec.getKeyClass() != null) {
                hashSet.add(courierMapTemplateSpec.getKeyClass());
            }
            hashSet.add(courierMapTemplateSpec.getValueClass());
        } else if (classTemplateSpec instanceof ArrayTemplateSpec) {
            ArrayTemplateSpec arrayTemplateSpec = (ArrayTemplateSpec)classTemplateSpec;
            hashSet.add(arrayTemplateSpec.getItemClass());
        }
        return hashSet;
    }

    public static CustomInfoSpec getImmediateCustomInfo(DataSchema dataSchema, String string) {
        CustomInfoSpec customInfoSpec = null;
        DataSchema dataSchema2 = dataSchema;
        while (dataSchema2 != null) {
            CourierTemplateSpecGenerator.CustomClasses customClasses = CourierTemplateSpecGenerator.getCustomClasses(dataSchema2, string);
            if (customClasses != null) {
                customInfoSpec = new CustomInfoSpec((NamedDataSchema)dataSchema, (NamedDataSchema)dataSchema2, customClasses.customClass, customClasses.customCoercerClass);
                break;
            }
            dataSchema2 = ClassTemplateSpecs.dereferenceIfTyperef(dataSchema2);
        }
        return customInfoSpec;
    }

    private static DataSchema dereferenceIfTyperef(DataSchema dataSchema) {
        DataSchema.Type type = dataSchema.getType();
        return type == DataSchema.Type.TYPEREF ? ((TyperefDataSchema)dataSchema).getRef() : null;
    }

    public static Set<ClassTemplateSpec> directContainedTypes(ClassTemplateSpec classTemplateSpec) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        for (ClassTemplateSpec classTemplateSpec2 : ClassTemplateSpecs.directReferencedTypes(classTemplateSpec)) {
            if (classTemplateSpec2.getEnclosingClass() != classTemplateSpec) continue;
            hashSet.add(classTemplateSpec2);
        }
        return hashSet;
    }

    public static Set<ClassTemplateSpec> allContainedTypes(ClassTemplateSpec classTemplateSpec) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        for (ClassTemplateSpec classTemplateSpec2 : ClassTemplateSpecs.allReferencedTypes(classTemplateSpec)) {
            if (classTemplateSpec2.getEnclosingClass() != classTemplateSpec) continue;
            hashSet.add(classTemplateSpec2);
        }
        return hashSet;
    }

    public static Set<ClassTemplateSpec> allReferencedTypes(ClassTemplateSpec classTemplateSpec) {
        return ClassTemplateSpecs.findAllReferencedTypes(ClassTemplateSpecs.directReferencedTypes(classTemplateSpec), Collections.emptySet(), Collections.emptySet());
    }

    private static Set<ClassTemplateSpec> findAllReferencedTypes(Set<ClassTemplateSpec> set, Set<ClassTemplateSpec> set2, Set<ClassTemplateSpec> set3) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        for (ClassTemplateSpec object : set) {
            for (ClassTemplateSpec classTemplateSpec : ClassTemplateSpecs.directReferencedTypes(object)) {
                if (set2.contains(classTemplateSpec)) continue;
                hashSet.add(classTemplateSpec);
            }
        }
        HashSet<ClassTemplateSpec> hashSet2 = new HashSet<ClassTemplateSpec>(set3);
        hashSet2.addAll(set);
        if (hashSet.size() > 0) {
            HashSet<ClassTemplateSpec> hashSet3 = new HashSet<ClassTemplateSpec>(set);
            hashSet3.addAll(set2);
            return ClassTemplateSpecs.findAllReferencedTypes(hashSet, hashSet3, (Set<ClassTemplateSpec>)hashSet2);
        }
        return hashSet2;
    }
}

