/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.coursera.courier.api.FileFormatDataSchemaParser;
import org.coursera.courier.api.MultiFormatDataSchemaResolver;
import org.coursera.courier.api.ParserForFileFormat;
import org.coursera.courier.api.ResolverOverrideSchemaParserFactory;

public class MultiFormatSchemaParser {
    private final Map<String, FileFormatDataSchemaParser> parserByFileExtension;
    private final MultiFormatDataSchemaResolver resolver;

    public MultiFormatSchemaParser(String string, List<ParserForFileFormat> list) {
        MultiFormatDataSchemaResolver multiFormatDataSchemaResolver = new MultiFormatDataSchemaResolver(string, list);
        this.parserByFileExtension = new HashMap<String, FileFormatDataSchemaParser>();
        for (ParserForFileFormat parserForFileFormat : list) {
            ResolverOverrideSchemaParserFactory resolverOverrideSchemaParserFactory = new ResolverOverrideSchemaParserFactory(parserForFileFormat.parserFactory, multiFormatDataSchemaResolver);
            FileFormatDataSchemaParser fileFormatDataSchemaParser = new FileFormatDataSchemaParser(multiFormatDataSchemaResolver, resolverOverrideSchemaParserFactory, parserForFileFormat.fileExtension);
            this.parserByFileExtension.put(parserForFileFormat.fileExtension, fileFormatDataSchemaParser);
        }
        this.resolver = multiFormatDataSchemaResolver;
    }

    public DataSchemaResolver getSchemaResolver() {
        return this.resolver;
    }

    public DataSchemaParser.ParseResult parseSources(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        Set<String> set = this.parserByFileExtension.keySet();
        HashMap hashMap = new HashMap(set.size());
        for (String string : set) {
            hashMap.put(string, new ArrayList());
        }
        for (String string : stringArray) {
            List list;
            object2 = new File(string);
            if (!((File)object2).exists()) continue;
            if (((File)object2).isDirectory()) {
                object = new FileExtensionFilter(set);
                list = FileUtil.listFiles((File)object2, (FileFilter)object);
                for (File file : list) {
                    String string2 = FilenameUtils.getExtension((String)file.getName());
                    List list2 = (List)hashMap.get(string2);
                    if (list2 == null) continue;
                    list2.add(file.getAbsolutePath());
                }
                continue;
            }
            object = FilenameUtils.getExtension((String)((File)object2).getName());
            list = (List)hashMap.get(object);
            if (list == null) continue;
            list.add(((File)object2).getAbsolutePath());
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string;
            string = (String)entry.getKey();
            object2 = (List)entry.getValue();
            object = this.parserByFileExtension.get(string).parseSources(object2.toArray(new String[object2.size()]));
            arrayList.add(object);
        }
        return MultiFormatSchemaParser.combine(arrayList);
    }

    private static DataSchemaParser.ParseResult combine(Collection<DataSchemaParser.ParseResult> collection) {
        FileFormatDataSchemaParser.CourierParseResult courierParseResult = new FileFormatDataSchemaParser.CourierParseResult();
        for (DataSchemaParser.ParseResult parseResult : collection) {
            courierParseResult.getSchemaAndLocations().putAll(parseResult.getSchemaAndLocations());
            courierParseResult.getSourceFiles().addAll(parseResult.getSourceFiles());
            courierParseResult.addMessage(parseResult.getMessage().toString());
        }
        return courierParseResult;
    }

    private static class FileExtensionFilter
    implements FileFilter {
        private final Set<String> extensions;

        public FileExtensionFilter(Set<String> set) {
            this.extensions = set;
        }

        @Override
        public boolean accept(File file) {
            return this.extensions.contains(FilenameUtils.getExtension((String)file.getName()));
        }
    }
}

