/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.lang;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.coursera.courier.lang.DocCommentStyle;

public class DocEscaping {
    private static final int WRAP_HIGH_WATERMARK = 180;
    private static final int WRAP_TARGET_LINE_LENGTH = 100;

    public static String stringToDocComment(String string, DocCommentStyle docCommentStyle) {
        if (string == null || string.trim().isEmpty()) {
            return "";
        }
        String string2 = docCommentStyle == DocCommentStyle.ASTRISK_MARGIN ? "\n * " : "\n";
        String string3 = DocEscaping.wrap(DocEscaping.escape(string)).replaceAll("\\n", string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/**\n");
        if (docCommentStyle == DocCommentStyle.ASTRISK_MARGIN) {
            stringBuilder.append(" * ");
        }
        stringBuilder.append(string3).append("\n");
        if (docCommentStyle == DocCommentStyle.ASTRISK_MARGIN) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("*/");
        return stringBuilder.toString();
    }

    private static String wrap(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\n")) {
            if (string2.length() > 180) {
                stringBuilder.append(WordUtils.wrap((String)string2, (int)100));
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().trim();
    }

    private static String escape(String string) {
        String string2 = StringEscapeUtils.escapeHtml4((String)string);
        return string2.replace("/*", "&#47;&#42;").replace("*/", "&#42;&#47;");
    }
}

