/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FileFormatDataSchemaParser {
    private final DataSchemaResolver _schemaResolver;
    private final SchemaParserFactory _schemaParserFactory;
    private final String _fileExtension;
    private final FileExtensionFilter _fileExtensionFilter;

    public FileFormatDataSchemaParser(DataSchemaResolver dataSchemaResolver, SchemaParserFactory schemaParserFactory, String string) {
        this._schemaResolver = dataSchemaResolver;
        this._schemaParserFactory = schemaParserFactory;
        this._fileExtension = string;
        this._fileExtensionFilter = new FileExtensionFilter(string);
    }

    public DataSchemaResolver getSchemaResolver() {
        return this._schemaResolver;
    }

    public DataSchemaParser.ParseResult parseSources(String[] stringArray) throws IOException {
        CourierParseResult courierParseResult = new CourierParseResult();
        try {
            for (String string : stringArray) {
                Object object;
                Object object2;
                File file = new File(string);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        object2 = FileUtil.listFiles((File)file, (FileFilter)this._fileExtensionFilter);
                        object = object2.iterator();
                        while (object.hasNext()) {
                            File file2 = (File)object.next();
                            this.parseFile(file2, courierParseResult);
                        }
                        continue;
                    }
                    this.parseFile(file, courierParseResult);
                    continue;
                }
                object2 = new StringBuilder();
                object = this._schemaResolver.findDataSchema(string, (StringBuilder)object2);
                if (object == null) {
                    courierParseResult.addMessage("File cannot be opened or schema name cannot be resolved: ").addMessage(string).addMessage("\n");
                }
                if (((StringBuilder)object2).length() <= 0) continue;
                courierParseResult.addMessage(((StringBuilder)object2).toString());
            }
            for (Map.Entry entry : this._schemaResolver.nameToDataSchemaLocations().entrySet()) {
                DataSchema dataSchema = (DataSchema)this._schemaResolver.bindings().get(entry.getKey());
                courierParseResult.getSchemaAndLocations().put(dataSchema, entry.getValue());
            }
            if (courierParseResult.getMessage().length() > 0) {
                throw new IOException(courierParseResult.getMessage());
            }
            this.appendSourceFilesFromSchemaResolver(courierParseResult);
            return courierParseResult;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2;
            if (courierParseResult.getMessage().length() > 0) {
                runtimeException2 = new RuntimeException("Unexpected " + runtimeException.getClass().getSimpleName() + " encountered.\nThis may be caused by the following parsing or processing errors:\n" + courierParseResult.getMessage(), runtimeException);
            }
            throw runtimeException2;
        }
    }

    private void parseFile(File file, CourierParseResult courierParseResult) throws IOException {
        if (this.wasResolved(file)) {
            return;
        }
        List<DataSchema> list = this.parseSchema(file, courierParseResult);
        for (DataSchema dataSchema : list) {
            this.validateSchemaWithFilePath(file, dataSchema);
            courierParseResult.getSchemaAndLocations().put(dataSchema, new FileDataSchemaLocation(file));
            courierParseResult.getSourceFiles().add(file);
        }
    }

    private void validateSchemaWithFilePath(File file, DataSchema dataSchema) {
        if (file != null && file.isFile() && dataSchema instanceof NamedDataSchema) {
            NamedDataSchema namedDataSchema = (NamedDataSchema)dataSchema;
            String string = namedDataSchema.getNamespace();
            if (!FileUtil.removeFileExtension((String)file.getName()).equalsIgnoreCase(namedDataSchema.getName())) {
                throw new IllegalArgumentException(namedDataSchema.getFullName() + " has name that does not match filename '" + file.getAbsolutePath() + "'");
            }
            String string2 = file.getParentFile().getAbsolutePath();
            if (!string2.endsWith(string.replace('.', File.separatorChar))) {
                throw new IllegalArgumentException(namedDataSchema.getFullName() + " has namespace that does not match file path '" + file.getAbsolutePath() + "'");
            }
        }
    }

    private boolean wasResolved(File file) {
        FileDataSchemaLocation fileDataSchemaLocation = new FileDataSchemaLocation(file);
        return this._schemaResolver.locationResolved((DataSchemaLocation)fileDataSchemaLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSchema> parseSchema(File file, CourierParseResult courierParseResult) throws IOException {
        SchemaParser schemaParser = this._schemaParserFactory.create(this._schemaResolver);
        SchemaFileInputStream schemaFileInputStream = new SchemaFileInputStream(file);
        try {
            schemaParser.setLocation((DataSchemaLocation)new FileDataSchemaLocation(file));
            schemaParser.parse((InputStream)schemaFileInputStream);
            if (schemaParser.hasError()) {
                List<DataSchema> list = Collections.emptyList();
                return list;
            }
            List list = schemaParser.topLevelDataSchemas();
            return list;
        }
        finally {
            schemaFileInputStream.close();
            if (schemaParser.hasError()) {
                courierParseResult.addMessage(file.getPath() + ",");
                courierParseResult.addMessage(schemaParser.errorMessage());
            }
        }
    }

    private void appendSourceFilesFromSchemaResolver(DataSchemaParser.ParseResult parseResult) {
        for (Map.Entry entry : this._schemaResolver.nameToDataSchemaLocations().entrySet()) {
            File file = ((DataSchemaLocation)entry.getValue()).getSourceFile();
            if (file == null) continue;
            parseResult.getSourceFiles().add(file);
        }
    }

    public static class CourierParseResult
    extends DataSchemaParser.ParseResult {
        private final StringBuilder messageBuilder;

        public CourierParseResult() {
            try {
                Field field = DataSchemaParser.ParseResult.class.getDeclaredField("_messageBuilder");
                field.setAccessible(true);
                this.messageBuilder = (StringBuilder)field.get((Object)this);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public CourierParseResult addMessage(String string) {
            this.messageBuilder.append(string);
            return this;
        }
    }

    private static class SchemaFileInputStream
    extends FileInputStream {
        private File _schemaSourceFile;

        private SchemaFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this._schemaSourceFile = file;
        }

        public String toString() {
            return this._schemaSourceFile.toString();
        }
    }

    private static class FileExtensionFilter
    implements FileFilter {
        private final String fileExtension;

        public FileExtensionFilter(String string) {
            this.fileExtension = string;
        }

        @Override
        public boolean accept(File file) {
            return FilenameUtils.getExtension((String)file.getName()).equals(this.fileExtension);
        }
    }
}

