/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.lang;

import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.coursera.courier.lang.DocCommentStyle;

public class PoorMansCStyleSourceFormatter {
    private final String indent;
    private final DocCommentStyle docCommentStyle;

    public PoorMansCStyleSourceFormatter(int n, DocCommentStyle docCommentStyle) {
        this.indent = StringUtils.repeat((String)" ", (int)n);
        this.docCommentStyle = docCommentStyle;
    }

    public String format(String string) {
        String[] stringArray = string.split("\\r?\\n");
        StringBuilder stringBuilder = new StringBuilder();
        Stack<Scope> stack = new Stack<Scope>();
        stack.push(Scope.ROOT);
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3;
            boolean bl4 = bl3 = (string2 = string2.trim()).length() == 0;
            if (bl3 && (bl || bl2 || stack.size() > 2)) continue;
            if (stack.peek() == Scope.COMMENT && string2.startsWith("*") && this.docCommentStyle == DocCommentStyle.ASTRISK_MARGIN) {
                stringBuilder.append(" ");
            }
            if ((stack.peek() == Scope.BLOCK || stack.peek() == Scope.SWITCH) && string2.startsWith("}")) {
                stack.pop();
                --n;
            } else if (stack.peek() == Scope.PARAMS && string2.startsWith(")")) {
                stack.pop();
                --n;
            } else if (stack.peek() == Scope.COMMENT && string2.startsWith("*/")) {
                stack.pop();
                if (this.docCommentStyle == DocCommentStyle.NO_MARGIN) {
                    --n;
                }
            }
            boolean bl5 = stack.peek() == Scope.SWITCH && (string2.startsWith("case ") || string2.startsWith("default"));
            boolean bl6 = string2.startsWith("extends") || string2.startsWith("with") || string2.startsWith("implements");
            stringBuilder.append(StringUtils.repeat((String)this.indent, (int)(n - (bl5 ? 1 : 0) + (bl6 ? 1 : 0))));
            stringBuilder.append(string2);
            stringBuilder.append('\n');
            if (string2.endsWith("{")) {
                ++n;
                if (string2.startsWith("switch ")) {
                    stack.push(Scope.SWITCH);
                } else {
                    stack.push(Scope.BLOCK);
                }
            } else if (string2.endsWith("(")) {
                ++n;
                stack.push(Scope.PARAMS);
            } else if (string2.startsWith("/**")) {
                stack.push(Scope.COMMENT);
                if (this.docCommentStyle == DocCommentStyle.NO_MARGIN) {
                    ++n;
                }
            }
            bl2 = string2.startsWith("@") || string2.startsWith("*");
            bl = bl3;
        }
        return stringBuilder.toString();
    }

    private static enum Scope {
        ROOT,
        UNCATEGORIZED,
        SWITCH,
        COMMENT,
        PARAMS,
        BLOCK;

    }
}

