/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.PrimitiveDataSchema;
import org.coursera.courier.generator.ScalaEscaping$;
import org.coursera.courier.generator.TypeConversions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class TypeConversions$ {
    public static final TypeConversions$ MODULE$;
    private final Seq<TypeConversions.PrimitiveMapping> primitiveMappings;
    private final Map<DataSchema, TypeConversions.PrimitiveMapping> primitivesBySchema;
    private final Map<DataSchema, String> scalaTypeForPrimitiveType;
    private final Map<DataSchema, Class<?>> javaClassForPrimitiveType;
    private final Map<DataSchema, String> pegasusTypeForPrimitiveType;
    private final Map<DataSchema, Object> isValueTypeForPrimitiveType;
    private final Set<DataSchema> primitiveSchemas;
    private final JacksonDataCodec dataCodec;

    static {
        new TypeConversions$();
    }

    private Seq<TypeConversions.PrimitiveMapping> primitiveMappings() {
        return this.primitiveMappings;
    }

    private Map<DataSchema, TypeConversions.PrimitiveMapping> primitivesBySchema() {
        return this.primitivesBySchema;
    }

    private Map<DataSchema, String> scalaTypeForPrimitiveType() {
        return this.scalaTypeForPrimitiveType;
    }

    private Map<DataSchema, Class<?>> javaClassForPrimitiveType() {
        return this.javaClassForPrimitiveType;
    }

    private Map<DataSchema, String> pegasusTypeForPrimitiveType() {
        return this.pegasusTypeForPrimitiveType;
    }

    private Map<DataSchema, Object> isValueTypeForPrimitiveType() {
        return this.isValueTypeForPrimitiveType;
    }

    public Set<DataSchema> primitiveSchemas() {
        return this.primitiveSchemas;
    }

    public String lookupScalaType(PrimitiveDataSchema schema) {
        return (String)this.scalaTypeForPrimitiveType().apply((Object)schema);
    }

    public Class<?> lookupJavaClass(PrimitiveDataSchema schema) {
        return (Class)this.javaClassForPrimitiveType().apply((Object)schema);
    }

    public String lookupPegasusType(PrimitiveDataSchema schema) {
        return (String)this.pegasusTypeForPrimitiveType().apply((Object)schema);
    }

    public boolean isScalaValueType(DataSchema schema) {
        return BoxesRunTime.unboxToBoolean((Object)this.isValueTypeForPrimitiveType().getOrElse((Object)schema, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private JacksonDataCodec dataCodec() {
        return this.dataCodec;
    }

    public String anyToLiteral(Object any) {
        Object object;
        block13: {
            String string;
            block5: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                object = any;
                                                if (!(object instanceof Integer)) break block4;
                                                Integer n = (Integer)object;
                                                string = this.toLiteral(n);
                                                break block5;
                                            }
                                            if (!(object instanceof Long)) break block6;
                                            Long l = (Long)object;
                                            string = this.toLiteral(l);
                                            break block5;
                                        }
                                        if (!(object instanceof Float)) break block7;
                                        Float f2 = (Float)object;
                                        string = this.toLiteral(f2);
                                        break block5;
                                    }
                                    if (!(object instanceof Double)) break block8;
                                    Double d = (Double)object;
                                    string = this.toLiteral(d);
                                    break block5;
                                }
                                if (!(object instanceof Boolean)) break block9;
                                Boolean bl = (Boolean)object;
                                string = this.toLiteral(bl);
                                break block5;
                            }
                            if (!(object instanceof String)) break block10;
                            String string2 = (String)object;
                            string = this.toLiteral(string2);
                            break block5;
                        }
                        if (!(object instanceof ByteString)) break block11;
                        ByteString byteString = (ByteString)object;
                        string = this.toLiteral(byteString);
                        break block5;
                    }
                    if (!(object instanceof DataMap)) break block12;
                    DataMap dataMap = (DataMap)object;
                    string = this.toLiteral(dataMap);
                    break block5;
                }
                if (!(object instanceof DataList)) break block13;
                DataList dataList = (DataList)object;
                string = this.toLiteral(dataList);
            }
            return string;
        }
        if (object != null) {
            Object object2 = object;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object2.getClass()})));
        }
        throw new MatchError(object);
    }

    public String toLiteral(Integer n) {
        return n.toString();
    }

    public String toLiteral(Long l) {
        return new StringBuilder().append((Object)l.toString()).append((Object)"L").toString();
    }

    public String toLiteral(Float f2) {
        return new StringBuilder().append((Object)f2.toString()).append((Object)"f").toString();
    }

    public String toLiteral(Double d) {
        return new StringBuilder().append((Object)d.toString()).append((Object)"d").toString();
    }

    public String toLiteral(Boolean bl) {
        return bl.toString();
    }

    public String toLiteral(ByteString bytes) {
        String byteLiterals = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(bytes.copyBytes()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte by) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0x", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToByte((byte)by)).toString()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ByteString.copy(Array[Byte](", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{byteLiterals}));
    }

    public String toLiteral(String string) {
        return ScalaEscaping$.MODULE$.escapeStringLiteral(string);
    }

    public String toLiteral(DataMap data) {
        String json = this.dataCodec().mapToString(data);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataTemplates.readDataMap(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toLiteral(json)}));
    }

    public String toLiteral(DataList data) {
        String json = this.dataCodec().listToString(data);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataTemplates.readDataList(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toLiteral(json)}));
    }

    private TypeConversions$() {
        MODULE$ = this;
        this.primitiveMappings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeConversions.PrimitiveMapping[]{new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.INTEGER_DATA_SCHEMA, "Int", true, "int", Integer.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.LONG_DATA_SCHEMA, "Long", true, "long", Long.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.FLOAT_DATA_SCHEMA, "Float", true, "float", Float.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.DOUBLE_DATA_SCHEMA, "Double", true, "double", Double.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.BOOLEAN_DATA_SCHEMA, "Boolean", true, "boolean", Boolean.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.BYTES_DATA_SCHEMA, "ByteString", false, "bytes", ByteString.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.STRING_DATA_SCHEMA, "String", false, "string", String.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.NULL_DATA_SCHEMA, "Null", false, "null", Null$.class)}));
        this.primitivesBySchema = ((TraversableOnce)this.primitiveMappings().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<DataSchema, TypeConversions.PrimitiveMapping> apply(TypeConversions.PrimitiveMapping mapping) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapping.schema()), (Object)mapping);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.scalaTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TypeConversions.PrimitiveMapping x$1) {
                return x$1.scalaType();
            }
        });
        this.javaClassForPrimitiveType = this.primitivesBySchema().mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(TypeConversions.PrimitiveMapping x$2) {
                return x$2.javaClass();
            }
        });
        this.pegasusTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TypeConversions.PrimitiveMapping x$3) {
                return x$3.pegasusType();
            }
        });
        this.isValueTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TypeConversions.PrimitiveMapping x$4) {
                return x$4.isValueType();
            }
        });
        this.primitiveSchemas = ((TraversableOnce)this.primitiveMappings().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataSchema apply(TypeConversions.PrimitiveMapping x$5) {
                return x$5.schema();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        this.dataCodec = new JacksonDataCodec();
    }
}

