/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.generator;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.template.BooleanArray;
import com.linkedin.data.template.BooleanMap;
import com.linkedin.data.template.BytesArray;
import com.linkedin.data.template.BytesMap;
import com.linkedin.data.template.DoubleArray;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.FloatArray;
import com.linkedin.data.template.FloatMap;
import com.linkedin.data.template.IntegerArray;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.LongArray;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import java.io.Serializable;
import org.coursera.courier.generator.TypeConversions$;
import org.coursera.courier.generator.specs.ArrayDefinition;
import org.coursera.courier.generator.specs.ArrayDefinition$;
import org.coursera.courier.generator.specs.Definition;
import org.coursera.courier.generator.specs.MapDefinition;
import org.coursera.courier.generator.specs.MapDefinition$;
import org.coursera.courier.generator.specs.PrimitiveDefinition;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.MapLike;

public final class CourierPredef$ {
    public static CourierPredef$ MODULE$;
    private final String dataNamespace;
    private final Seq<PrimitiveDataSchema> predefMapKeyTypes;
    private final Seq<PrimitiveDataSchema> predefMapValueTypes;
    private final Seq<Tuple2<MapDataSchema, MapDefinition>> mapKeyTypeSchemas;
    private final scala.collection.immutable.Map<DataSchema, Definition> bySchema;
    private final Seq<Definition> definitions;

    static {
        new CourierPredef$();
    }

    public String dataNamespace() {
        return this.dataNamespace;
    }

    public scala.collection.immutable.Map<DataSchema, Definition> bySchema() {
        return this.bySchema;
    }

    public Seq<Definition> definitions() {
        return this.definitions;
    }

    public Tuple2<ArrayDataSchema, ArrayDefinition> arrayPredef(String className, DataSchema.Type dataType2) {
        PrimitiveDefinition definition = new PrimitiveDefinition(PrimitiveTemplateSpec.getInstance((DataSchema.Type)dataType2));
        ArrayDataSchema arraySchema = this.getArraySchema(dataType2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arraySchema), (Object)ArrayDefinition$.MODULE$.forPredef(className, this.dataNamespace(), definition, arraySchema));
    }

    public Tuple2<MapDataSchema, MapDefinition> mapPredef(String className, DataSchema.Type dataType2) {
        PrimitiveDefinition definition = new PrimitiveDefinition(PrimitiveTemplateSpec.getInstance((DataSchema.Type)dataType2));
        MapDataSchema mapSchema = this.getMapSchema(dataType2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapSchema), (Object)MapDefinition$.MODULE$.forPredef(className, this.dataNamespace(), definition, mapSchema, MapDefinition$.MODULE$.forPredef$default$5()));
    }

    public Tuple2<MapDataSchema, MapDefinition> typedKeyMapPredef(String className, PrimitiveDataSchema keyType, PrimitiveDataSchema valueType) {
        MapDataSchema mapSchema = new MapDataSchema((DataSchema)valueType);
        mapSchema.setProperties((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keys"), (Object)TypeConversions$.MODULE$.lookupPegasusType(keyType))}))).asJava());
        PrimitiveDefinition keyDefinition = new PrimitiveDefinition(PrimitiveTemplateSpec.getInstance((DataSchema.Type)keyType.getType()));
        PrimitiveDefinition valueDefinition = new PrimitiveDefinition(PrimitiveTemplateSpec.getInstance((DataSchema.Type)valueType.getType()));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapSchema), (Object)MapDefinition$.MODULE$.forPredef(className, this.dataNamespace(), valueDefinition, mapSchema, (Option<PrimitiveDefinition>)new Some((Object)keyDefinition)));
    }

    public ArrayDataSchema getArraySchema(DataSchema.Type dataType2) {
        ArrayDataSchema arrayDataSchema;
        DataSchema.Type type = dataType2;
        if (DataSchema.Type.INT.equals(type)) {
            arrayDataSchema = new IntegerArray().schema();
        } else if (DataSchema.Type.LONG.equals(type)) {
            arrayDataSchema = new LongArray().schema();
        } else if (DataSchema.Type.FLOAT.equals(type)) {
            arrayDataSchema = new FloatArray().schema();
        } else if (DataSchema.Type.DOUBLE.equals(type)) {
            arrayDataSchema = new DoubleArray().schema();
        } else if (DataSchema.Type.BOOLEAN.equals(type)) {
            arrayDataSchema = new BooleanArray().schema();
        } else if (DataSchema.Type.STRING.equals(type)) {
            arrayDataSchema = new StringArray().schema();
        } else if (DataSchema.Type.BYTES.equals(type)) {
            arrayDataSchema = new BytesArray().schema();
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported DataSchema.Type: ").append(dataType2).toString());
        }
        return arrayDataSchema;
    }

    public MapDataSchema getMapSchema(DataSchema.Type dataType2) {
        MapDataSchema mapDataSchema;
        DataSchema.Type type = dataType2;
        if (DataSchema.Type.INT.equals(type)) {
            mapDataSchema = new IntegerMap().schema();
        } else if (DataSchema.Type.LONG.equals(type)) {
            mapDataSchema = new LongMap().schema();
        } else if (DataSchema.Type.FLOAT.equals(type)) {
            mapDataSchema = new FloatMap().schema();
        } else if (DataSchema.Type.DOUBLE.equals(type)) {
            mapDataSchema = new DoubleMap().schema();
        } else if (DataSchema.Type.BOOLEAN.equals(type)) {
            mapDataSchema = new BooleanMap().schema();
        } else if (DataSchema.Type.STRING.equals(type)) {
            mapDataSchema = new StringMap().schema();
        } else if (DataSchema.Type.BYTES.equals(type)) {
            mapDataSchema = new BytesMap().schema();
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported DataSchema.Type: ").append(dataType2).toString());
        }
        return mapDataSchema;
    }

    private CourierPredef$() {
        MODULE$ = this;
        this.dataNamespace = "org.coursera.courier.data";
        this.predefMapKeyTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrimitiveDataSchema[]{DataSchemaConstants.INTEGER_DATA_SCHEMA, DataSchemaConstants.LONG_DATA_SCHEMA, DataSchemaConstants.BOOLEAN_DATA_SCHEMA}));
        this.predefMapValueTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrimitiveDataSchema[]{DataSchemaConstants.INTEGER_DATA_SCHEMA, DataSchemaConstants.LONG_DATA_SCHEMA, DataSchemaConstants.FLOAT_DATA_SCHEMA, DataSchemaConstants.DOUBLE_DATA_SCHEMA, DataSchemaConstants.BOOLEAN_DATA_SCHEMA, DataSchemaConstants.STRING_DATA_SCHEMA, DataSchemaConstants.BYTES_DATA_SCHEMA}));
        this.mapKeyTypeSchemas = (Seq)this.predefMapKeyTypes.flatMap((Function1 & Serializable & scala.Serializable)keyType -> (Seq)((TraversableLike)CourierPredef$.MODULE$.predefMapValueTypes.map((Function1 & Serializable & scala.Serializable)valueType -> {
            String scalaKeyName = TypeConversions$.MODULE$.lookupScalaType((PrimitiveDataSchema)keyType);
            String scalaValueName = TypeConversions$.MODULE$.lookupScalaType((PrimitiveDataSchema)valueType);
            return new Tuple3(valueType, (Object)scalaKeyName, (Object)scalaValueName);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            PrimitiveDataSchema valueType = (PrimitiveDataSchema)tuple3._1();
            String scalaKeyName = (String)tuple3._2();
            String scalaValueName = (String)tuple3._3();
            Tuple2<MapDataSchema, MapDefinition> tuple2 = MODULE$.typedKeyMapPredef(new StringBuilder(5).append(scalaKeyName).append("To").append(scalaValueName).append("Map").toString(), (PrimitiveDataSchema)keyType, valueType);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.bySchema = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.arrayPredef("IntArray", DataSchema.Type.INT), this.arrayPredef("LongArray", DataSchema.Type.LONG), this.arrayPredef("FloatArray", DataSchema.Type.FLOAT), this.arrayPredef("DoubleArray", DataSchema.Type.DOUBLE), this.arrayPredef("BooleanArray", DataSchema.Type.BOOLEAN), this.arrayPredef("StringArray", DataSchema.Type.STRING), this.arrayPredef("BytesArray", DataSchema.Type.BYTES), this.mapPredef("IntMap", DataSchema.Type.INT), this.mapPredef("LongMap", DataSchema.Type.LONG), this.mapPredef("FloatMap", DataSchema.Type.FLOAT), this.mapPredef("DoubleMap", DataSchema.Type.DOUBLE), this.mapPredef("BooleanMap", DataSchema.Type.BOOLEAN), this.mapPredef("StringMap", DataSchema.Type.STRING), this.mapPredef("BytesMap", DataSchema.Type.BYTES)}))).$plus$plus(this.mapKeyTypeSchemas);
        this.definitions = this.bySchema().values().toSeq();
    }
}

