/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.PrimitiveDataSchema;
import java.io.Serializable;
import org.coursera.courier.generator.ScalaEscaping$;
import org.coursera.courier.generator.TypeConversions;
import scala.Array$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

public final class TypeConversions$ {
    public static TypeConversions$ MODULE$;
    private final Seq<TypeConversions.PrimitiveMapping> primitiveMappings;
    private final Map<DataSchema, TypeConversions.PrimitiveMapping> primitivesBySchema;
    private final Map<DataSchema, String> scalaTypeForPrimitiveType;
    private final Map<DataSchema, Class<?>> javaClassForPrimitiveType;
    private final Map<DataSchema, String> pegasusTypeForPrimitiveType;
    private final Map<DataSchema, Object> isValueTypeForPrimitiveType;
    private final Set<DataSchema> primitiveSchemas;
    private final JacksonDataCodec dataCodec;

    static {
        new TypeConversions$();
    }

    private Seq<TypeConversions.PrimitiveMapping> primitiveMappings() {
        return this.primitiveMappings;
    }

    private Map<DataSchema, TypeConversions.PrimitiveMapping> primitivesBySchema() {
        return this.primitivesBySchema;
    }

    private Map<DataSchema, String> scalaTypeForPrimitiveType() {
        return this.scalaTypeForPrimitiveType;
    }

    private Map<DataSchema, Class<?>> javaClassForPrimitiveType() {
        return this.javaClassForPrimitiveType;
    }

    private Map<DataSchema, String> pegasusTypeForPrimitiveType() {
        return this.pegasusTypeForPrimitiveType;
    }

    private Map<DataSchema, Object> isValueTypeForPrimitiveType() {
        return this.isValueTypeForPrimitiveType;
    }

    public Set<DataSchema> primitiveSchemas() {
        return this.primitiveSchemas;
    }

    public String lookupScalaType(PrimitiveDataSchema schema) {
        return (String)this.scalaTypeForPrimitiveType().apply((Object)schema);
    }

    public Class<?> lookupJavaClass(PrimitiveDataSchema schema) {
        return (Class)this.javaClassForPrimitiveType().apply((Object)schema);
    }

    public String lookupPegasusType(PrimitiveDataSchema schema) {
        return (String)this.pegasusTypeForPrimitiveType().apply((Object)schema);
    }

    public boolean isScalaValueType(DataSchema schema) {
        return BoxesRunTime.unboxToBoolean((Object)this.isValueTypeForPrimitiveType().getOrElse((Object)schema, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private JacksonDataCodec dataCodec() {
        return this.dataCodec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String anyToLiteral(Object any) {
        boolean bl = false;
        Long l = null;
        boolean bl2 = false;
        Double d = null;
        Object object = any;
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return this.toLiteral(n);
        }
        if (object instanceof Long) {
            bl = true;
            l = (Long)object;
            if (Integer.MIN_VALUE <= Predef$.MODULE$.Long2long(l) && Predef$.MODULE$.Long2long(l) <= Integer.MAX_VALUE) {
                return this.toLiteral(l.intValue());
            }
        }
        if (bl) {
            return this.toLiteral(l);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return this.toLiteral(f);
        }
        if (object instanceof Double) {
            bl2 = true;
            d = (Double)object;
            if ((double)Float$.MODULE$.MinValue() <= Predef$.MODULE$.Double2double(d) && Predef$.MODULE$.Double2double(d) <= 3.4028234663852886E38) {
                return this.toLiteral(Float.valueOf(d.floatValue()));
            }
        }
        if (bl2) {
            return this.toLiteral(d);
        }
        if (object instanceof Boolean) {
            Boolean bl3 = (Boolean)object;
            return this.toLiteral(bl3);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.toLiteral(string);
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            return this.toLiteral(byteString);
        }
        if (object instanceof DataMap) {
            DataMap dataMap = (DataMap)object;
            return this.toLiteral(dataMap);
        }
        if (object instanceof DataList) {
            DataList dataList = (DataList)object;
            return this.toLiteral(dataList);
        }
        if (object == null) throw new MatchError(object);
        Object object2 = object;
        throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(object2.getClass()).toString());
    }

    public String toLiteral(Integer n) {
        return n.toString();
    }

    public String toLiteral(Long l) {
        return new StringBuilder(1).append(l.toString()).append("L").toString();
    }

    public String toLiteral(Float f) {
        return new StringBuilder(1).append(f.toString()).append("f").toString();
    }

    public String toLiteral(Double d) {
        return new StringBuilder(1).append(d.toString()).append("d").toString();
    }

    public String toLiteral(Boolean bl) {
        return bl.toString();
    }

    public String toLiteral(ByteString bytes) {
        String byteLiterals = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes.copyBytes())).map((Function1 & Serializable & scala.Serializable)object -> TypeConversions$.$anonfun$toLiteral$1(BoxesRunTime.unboxToByte((Object)object)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        return new StringBuilder(30).append("ByteString.copy(Array[Byte](").append(byteLiterals).append("))").toString();
    }

    public String toLiteral(String string) {
        return ScalaEscaping$.MODULE$.escapeStringLiteral(string);
    }

    public String toLiteral(DataMap data) {
        String json = this.dataCodec().mapToString(data);
        return new StringBuilder(27).append("DataTemplates.readDataMap(").append(this.toLiteral(json)).append(")").toString();
    }

    public String toLiteral(DataList data) {
        String json = this.dataCodec().listToString(data);
        return new StringBuilder(28).append("DataTemplates.readDataList(").append(this.toLiteral(json)).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$toLiteral$1(byte by) {
        return new StringBuilder(2).append("0x").append(((Object)BoxesRunTime.boxToByte((byte)by)).toString()).toString();
    }

    private TypeConversions$() {
        MODULE$ = this;
        this.primitiveMappings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeConversions.PrimitiveMapping[]{new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.INTEGER_DATA_SCHEMA, "Int", true, "int", Integer.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.LONG_DATA_SCHEMA, "Long", true, "long", Long.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.FLOAT_DATA_SCHEMA, "Float", true, "float", Float.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.DOUBLE_DATA_SCHEMA, "Double", true, "double", Double.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.BOOLEAN_DATA_SCHEMA, "Boolean", true, "boolean", Boolean.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.BYTES_DATA_SCHEMA, "ByteString", false, "bytes", ByteString.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.STRING_DATA_SCHEMA, "String", false, "string", String.class), new TypeConversions.PrimitiveMapping((DataSchema)DataSchemaConstants.NULL_DATA_SCHEMA, "Null", false, "null", Null$.class)}));
        this.primitivesBySchema = ((TraversableOnce)this.primitiveMappings().map((Function1 & Serializable & scala.Serializable)mapping -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapping.schema()), mapping), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.scalaTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.scalaType());
        this.javaClassForPrimitiveType = this.primitivesBySchema().mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.javaClass());
        this.pegasusTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pegasusType());
        this.isValueTypeForPrimitiveType = this.primitivesBySchema().mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isValueType()));
        this.primitiveSchemas = ((TraversableOnce)this.primitiveMappings().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.schema(), Seq$.MODULE$.canBuildFrom())).toSet();
        this.dataCodec = new JacksonDataCodec();
    }
}

