/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.pegasus.generator.JavaCodeGeneratorBase;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.io.output.NullOutputStream;
import org.coursera.courier.api.DefaultGeneratorRunner;
import org.coursera.courier.api.GeneratedCode;
import org.coursera.courier.api.GeneratedCodeTargetFile;
import org.coursera.courier.api.GeneratorRunnerOptions;
import org.coursera.courier.api.PegasusCodeGenerator;

public class JavaGenerator
implements PegasusCodeGenerator {
    private static final Collection<DataSchema> predef = new HashSet<DataSchema>();

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Usage: " + JavaGenerator.class.getName() + " targetPath resolverPath sourcePath1[:sourcePath2]+");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String[] stringArray2 = string3.split(File.pathSeparator);
        GeneratorRunnerOptions generatorRunnerOptions = new GeneratorRunnerOptions(string, stringArray2, string2);
        new DefaultGeneratorRunner().run((PegasusCodeGenerator)new JavaGenerator(), generatorRunnerOptions);
    }

    public GeneratedCode generate(ClassTemplateSpec classTemplateSpec) {
        String string;
        if (predef.contains(classTemplateSpec.getSchema())) {
            return null;
        }
        JavaDataTemplateGenerator.Config config = new JavaDataTemplateGenerator.Config();
        JavaDataTemplateGenerator javaDataTemplateGenerator = new JavaDataTemplateGenerator(config);
        JClass jClass = javaDataTemplateGenerator.generate(classTemplateSpec);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            javaDataTemplateGenerator.getCodeModel().build((CodeWriter)new CapturingCodeWriter(classTemplateSpec.getNamespace(), classTemplateSpec.getClassName(), byteArrayOutputStream));
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error generating code for " + classTemplateSpec.getFullName(), iOException);
        }
        if (string.trim().equals("")) {
            throw new RuntimeException("Failed to generate code for " + classTemplateSpec.getFullName());
        }
        return new GeneratedCode((GeneratedCodeTargetFile)new JavaCompilationUnit(jClass.name(), jClass._package().name()), string);
    }

    public Collection<GeneratedCode> generatePredef() {
        return Collections.emptySet();
    }

    public Collection<DataSchema> definedSchemas() {
        return predef;
    }

    public String buildLanguage() {
        return "java";
    }

    public String customTypeLanguage() {
        return "java";
    }

    static {
        predef.add((DataSchema)DataSchemaConstants.INTEGER_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.LONG_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.FLOAT_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.DOUBLE_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.BOOLEAN_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.STRING_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.BYTES_DATA_SCHEMA);
        predef.add((DataSchema)DataSchemaConstants.NULL_DATA_SCHEMA);
        predef.addAll(JavaDataTemplateGenerator.PredefinedJavaClasses.keySet());
    }

    private static class CapturingCodeWriter
    extends CodeWriter {
        private final PrintStream out;
        private final String namespace;
        private final String className;
        private static final int SUFFIX_LENGTH = ".java".length();

        public CapturingCodeWriter(String string, String string2, OutputStream outputStream) {
            this.out = new PrintStream(outputStream);
            this.namespace = string;
            this.className = string2;
        }

        public OutputStream openBinary(JPackage jPackage, String string) throws IOException {
            boolean bl = jPackage.isUnnamed() && (this.namespace == null || this.namespace.isEmpty()) || jPackage.name().equals(this.namespace);
            String string2 = string.substring(0, string.length() - SUFFIX_LENGTH);
            boolean bl2 = string2.equals(Escaper.escape(this.className));
            if (bl && bl2) {
                return this.out;
            }
            return new NullOutputStream();
        }

        public void close() throws IOException {
            this.out.close();
        }

        private static final class Escaper
        extends JavaCodeGeneratorBase {
            public Escaper() {
                super("");
            }

            public static String escape(String string) {
                return Escaper.escapeReserved((String)string);
            }
        }
    }

    public static class JavaCompilationUnit
    extends GeneratedCodeTargetFile {
        public JavaCompilationUnit(String string, String string2) {
            super(string, string2, "java");
        }
    }
}

