/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.codecs;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.BooleanDataSchema;
import com.linkedin.data.schema.BytesDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DoubleDataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.FloatDataSchema;
import com.linkedin.data.schema.IntegerDataSchema;
import com.linkedin.data.schema.LongDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.StringDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import java.io.IOException;
import java.nio.charset.Charset;
import org.coursera.courier.codecs.InlineStringCodec;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class InlineStringCodec$ {
    public static final InlineStringCodec$ MODULE$;
    private final Charset charset;
    private final ValidationOptions defaultValidationOptions;
    private final InlineStringCodec instance;
    public final char org$coursera$courier$codecs$InlineStringCodec$$escapeChar;
    public final char org$coursera$courier$codecs$InlineStringCodec$$startCollection;
    public final char org$coursera$courier$codecs$InlineStringCodec$$endCollection;
    public final char org$coursera$courier$codecs$InlineStringCodec$$itemSeparator;
    public final char org$coursera$courier$codecs$InlineStringCodec$$keyValueSeparator;
    public final String org$coursera$courier$codecs$InlineStringCodec$$listPrefix;
    private final SortedSet<Object> reservedCharSet;
    public final String org$coursera$courier$codecs$InlineStringCodec$$reservedChars;
    private final Regex escapeRegex;
    private final Regex unEscapeRegex;

    static {
        new InlineStringCodec$();
    }

    public Charset charset() {
        return this.charset;
    }

    public ValidationOptions defaultValidationOptions() {
        return this.defaultValidationOptions;
    }

    public InlineStringCodec instance() {
        return this.instance;
    }

    public Object stringToData(String key, DataSchema schema) {
        DataSchema dataSchema;
        block15: {
            Object object;
            block5: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block4: {
                                                        dataSchema = schema.getDereferencedDataSchema();
                                                        if (!(dataSchema instanceof IntegerDataSchema)) break block4;
                                                        object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(key)).toInt());
                                                        break block5;
                                                    }
                                                    if (!(dataSchema instanceof LongDataSchema)) break block6;
                                                    object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(key)).toInt());
                                                    break block5;
                                                }
                                                if (!(dataSchema instanceof FloatDataSchema)) break block7;
                                                object = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(key)).toFloat());
                                                break block5;
                                            }
                                            if (!(dataSchema instanceof DoubleDataSchema)) break block8;
                                            object = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(key)).toDouble());
                                            break block5;
                                        }
                                        if (!(dataSchema instanceof BooleanDataSchema)) break block9;
                                        object = BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(key)).toBoolean());
                                        break block5;
                                    }
                                    if (!(dataSchema instanceof StringDataSchema)) break block10;
                                    object = key;
                                    break block5;
                                }
                                if (!(dataSchema instanceof BytesDataSchema)) break block11;
                                object = ByteString.copyString((String)key, (Charset)this.charset());
                                break block5;
                            }
                            boolean bl = dataSchema instanceof RecordDataSchema ? true : (dataSchema instanceof UnionDataSchema ? true : dataSchema instanceof MapDataSchema);
                            if (!bl) break block12;
                            object = this.stringToDataMap(key, schema);
                            break block5;
                        }
                        if (!(dataSchema instanceof ArrayDataSchema)) break block13;
                        object = this.stringToDataList(key, schema);
                        break block5;
                    }
                    if (!(dataSchema instanceof EnumDataSchema)) break block14;
                    object = key;
                    break block5;
                }
                if (!(dataSchema instanceof FixedDataSchema)) break block15;
                object = ByteString.copyString((String)key, (Charset)this.charset());
            }
            return object;
        }
        if (dataSchema != null) {
            DataSchema dataSchema2 = dataSchema;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported schema type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSchema2.getClass()})));
        }
        throw new MatchError((Object)dataSchema);
    }

    /*
     * WARNING - void declaration
     */
    private DataMap stringToDataMap(String key, DataSchema schema) {
        void var4_4;
        DataMap map2 = this.instance().bytesToMap(key.getBytes(this.charset()));
        ValidationResult validationResult = ValidateDataAgainstSchema.validate((Object)map2, (DataSchema)schema, (ValidationOptions)this.defaultValidationOptions());
        if (validationResult.isValid()) {
            void var3_3;
            return var3_3;
        }
        throw new IOException(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(var4_4.getMessages()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Message x$1) {
                return x$1.toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", "));
    }

    /*
     * WARNING - void declaration
     */
    private DataList stringToDataList(String key, DataSchema schema) {
        void var4_4;
        DataList list2 = this.instance().bytesToList(key.getBytes(this.charset()));
        ValidationResult validationResult = ValidateDataAgainstSchema.validate((Object)list2, (DataSchema)schema, (ValidationOptions)this.defaultValidationOptions());
        if (validationResult.isValid()) {
            void var3_3;
            return var3_3;
        }
        throw new IOException(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(var4_4.getMessages()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Message x$2) {
                return x$2.toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", "));
    }

    public String dataToString(Object any) {
        Object object;
        block13: {
            String string;
            block5: {
                block12: {
                    String string2;
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                object = any;
                                                if (!(object instanceof DataMap)) break block4;
                                                DataMap dataMap = (DataMap)object;
                                                string = new String(this.instance().mapToBytes(dataMap), this.charset());
                                                break block5;
                                            }
                                            if (!(object instanceof DataList)) break block6;
                                            DataList dataList = (DataList)object;
                                            string = new String(this.instance().listToBytes(dataList), this.charset());
                                            break block5;
                                        }
                                        if (!(object instanceof Integer)) break block7;
                                        Integer n = (Integer)object;
                                        string = n.toString();
                                        break block5;
                                    }
                                    if (!(object instanceof Long)) break block8;
                                    Long l = (Long)object;
                                    string = l.toString();
                                    break block5;
                                }
                                if (!(object instanceof Float)) break block9;
                                Float f = (Float)object;
                                string = f.toString();
                                break block5;
                            }
                            if (!(object instanceof Double)) break block10;
                            Double d = (Double)object;
                            string = d.toString();
                            break block5;
                        }
                        if (!(object instanceof Boolean)) break block11;
                        Boolean bl = (Boolean)object;
                        string = bl.toString();
                        break block5;
                    }
                    if (!(object instanceof String)) break block12;
                    string = string2 = (String)object;
                    break block5;
                }
                if (!(object instanceof ByteString)) break block13;
                ByteString byteString = (ByteString)object;
                string = byteString.asAvroString();
            }
            return string;
        }
        if (object != null) {
            Object object2 = object;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object2.getClass()})));
        }
        throw new MatchError(object);
    }

    public String escape(String unescaped) {
        return this.escapeRegex.replaceAllIn((CharSequence)unescaped, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.org$coursera$courier$codecs$InlineStringCodec$$escapeChar)})));
    }

    public String unescape(String escaped) {
        return this.unEscapeRegex.replaceAllIn((CharSequence)escaped, "$1");
    }

    private InlineStringCodec$() {
        MODULE$ = this;
        this.charset = Charset.forName("UTF-8");
        this.defaultValidationOptions = new ValidationOptions(RequiredMode.FIXUP_ABSENT_WITH_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE);
        this.instance = new InlineStringCodec();
        this.org$coursera$courier$codecs$InlineStringCodec$$escapeChar = (char)33;
        this.org$coursera$courier$codecs$InlineStringCodec$$startCollection = (char)40;
        this.org$coursera$courier$codecs$InlineStringCodec$$endCollection = (char)41;
        this.org$coursera$courier$codecs$InlineStringCodec$$itemSeparator = (char)44;
        this.org$coursera$courier$codecs$InlineStringCodec$$keyValueSeparator = (char)126;
        this.org$coursera$courier$codecs$InlineStringCodec$$listPrefix = "List";
        this.reservedCharSet = (SortedSet)SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{this.org$coursera$courier$codecs$InlineStringCodec$$startCollection, this.org$coursera$courier$codecs$InlineStringCodec$$endCollection, this.org$coursera$courier$codecs$InlineStringCodec$$itemSeparator, this.org$coursera$courier$codecs$InlineStringCodec$$keyValueSeparator, this.org$coursera$courier$codecs$InlineStringCodec$$escapeChar}), (Ordering)Ordering.Char$.MODULE$);
        this.org$coursera$courier$codecs$InlineStringCodec$$reservedChars = this.reservedCharSet.mkString("");
        this.escapeRegex = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"([", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$coursera$courier$codecs$InlineStringCodec$$reservedChars})))).r();
        this.unEscapeRegex = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "([", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.org$coursera$courier$codecs$InlineStringCodec$$escapeChar), this.org$coursera$courier$codecs$InlineStringCodec$$reservedChars})))).r();
    }
}

