/*
 Copyright 2015 Coursera Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

package org.coursera.courier.companions

import com.linkedin.data.schema.TyperefDataSchema
import org.coursera.courier.templates.ScalaUnionTemplate

/**
 * Identifies companion objects of the Scala union "template" classes generated by Courier that
 * were defined within a typeref and provides access to the typeref's schema.
 *
 * Because the union is not a named type in Pegasus, it cannot have schema properties directly
 * defied on it. As a result, the defining typeref is often used as an anchor for adding names
 * and properties to unions.
 *
 * For example, in:
 *
 * ```
 * @@propertyX = "value"
 * typeref T = union[A, B]
 * ```
 *
 * The union of `A` and `B` is defined withing the typeref T, which has a name (`T`) and a property
 * `propertyX` that are associated with the union and can be accessed using this trait's
 * `TYPEREF_SCHEMA`,
 */
trait UnionWithTyperefCompanion[K <: ScalaUnionTemplate] extends UnionCompanion[K] {

  /**
   * @return the schema of the typeref that was used to define this union.
   */
  def TYPEREF_SCHEMA: TyperefDataSchema
}
