/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.coursera.courier.api.DefaultGeneratorRunner;
import org.coursera.courier.api.GeneratedCode;
import org.coursera.courier.api.GeneratedCodeTargetFile;
import org.coursera.courier.api.GeneratorRunnerOptions;
import org.coursera.courier.api.PegasusCodeGenerator;
import org.coursera.courier.lang.DocCommentStyle;
import org.coursera.courier.lang.PoorMansCStyleSourceFormatter;
import org.coursera.courier.swift.GlobalConfig;
import org.coursera.courier.swift.SwiftProperties;
import org.coursera.courier.swift.SwiftSyntax;
import org.coursera.courier.swift.SwiftyJSON;
import org.rythmengine.RythmEngine;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.resource.ClasspathResourceLoader;

public class SwiftGenerator
implements PegasusCodeGenerator {
    private static final SwiftProperties.Optionality defaultOptionality = SwiftProperties.Optionality.REQUIRED_FIELDS_MAY_BE_ABSENT;
    private final GlobalConfig globalConfig;
    private final RythmEngine engine;
    private static final PoorMansCStyleSourceFormatter formatter = new PoorMansCStyleSourceFormatter(4, DocCommentStyle.NO_MARGIN);

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length < 3 || stringArray.length > 5) {
            throw new IllegalArgumentException("Usage: targetPath resolverPath1[:resolverPath2]+ sourcePath1[:sourcePath2]+ [REQUIRED_FIELDS_MAY_BE_ABSENT|STRICT] [EQUATABLE]");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String[] stringArray2 = string3.split(":");
        SwiftProperties.Optionality optionality = defaultOptionality;
        if (stringArray.length > 3) {
            optionality = SwiftProperties.Optionality.valueOf(stringArray[3]);
        }
        boolean bl = false;
        if (stringArray.length > 4) {
            if (!stringArray[4].equals("EQUATABLE")) {
                throw new IllegalArgumentException("If present 4th argument must be 'EQUATABLE'");
            }
            bl = true;
        }
        GeneratorRunnerOptions generatorRunnerOptions = new GeneratorRunnerOptions(string, stringArray2, string2);
        GlobalConfig globalConfig = new GlobalConfig(optionality, bl, false);
        GeneratorResult generatorResult = new DefaultGeneratorRunner().run((PegasusCodeGenerator)new SwiftGenerator(globalConfig), generatorRunnerOptions);
        for (File file : generatorResult.getTargetFiles()) {
            System.out.println(file.getAbsolutePath());
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("runtime/CourierRuntime.swift");
        IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(new File(string, "CourierRuntime.swift")));
    }

    public SwiftGenerator() {
        this(new GlobalConfig(defaultOptionality, false, false));
    }

    public SwiftGenerator(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        this.engine = new RythmEngine();
        this.engine.registerResourceLoader(new ITemplateResourceLoader[]{new ClasspathResourceLoader(this.engine, "/")});
    }

    public GeneratedCode generate(ClassTemplateSpec classTemplateSpec) {
        String string;
        block6: {
            SwiftProperties swiftProperties = this.globalConfig.lookupSwiftProperties(classTemplateSpec);
            if (swiftProperties.omit) {
                return null;
            }
            SwiftSyntax swiftSyntax = new SwiftSyntax(classTemplateSpec, swiftProperties, this.globalConfig);
            SwiftyJSON swiftyJSON = new SwiftyJSON(swiftSyntax);
            try {
                if (classTemplateSpec instanceof RecordTemplateSpec) {
                    string = this.engine.render("rythm-swift/record.txt", new Object[]{classTemplateSpec, swiftSyntax, swiftyJSON});
                    break block6;
                }
                if (classTemplateSpec instanceof EnumTemplateSpec) {
                    string = this.engine.render("rythm-swift/enum.txt", new Object[]{classTemplateSpec});
                    break block6;
                }
                if (classTemplateSpec instanceof UnionTemplateSpec) {
                    string = this.engine.render("rythm-swift/union.txt", new Object[]{classTemplateSpec, swiftSyntax, swiftyJSON});
                    break block6;
                }
                return null;
            }
            catch (RythmException rythmException) {
                throw new RuntimeException("Internal error in generator while processing " + classTemplateSpec.getFullName(), rythmException);
            }
        }
        SwiftCompilationUnit swiftCompilationUnit = new SwiftCompilationUnit(classTemplateSpec.getClassName(), "");
        string = formatter.format(string);
        return new GeneratedCode((GeneratedCodeTargetFile)swiftCompilationUnit, string);
    }

    public Collection<GeneratedCode> generatePredef() {
        return Collections.emptySet();
    }

    public Collection<DataSchema> definedSchemas() {
        return Collections.emptySet();
    }

    public String buildLanguage() {
        return "swift";
    }

    public String customTypeLanguage() {
        return "swift";
    }

    public static class SwiftCompilationUnit
    extends GeneratedCodeTargetFile {
        public SwiftCompilationUnit(String string, String string2) {
            super(string, string2, "swift");
        }
    }
}

