/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.swift;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.BooleanDataSchema;
import com.linkedin.data.schema.BytesDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NullDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.StringDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.coursera.courier.api.CourierMapTemplateSpec;
import org.coursera.courier.swift.GlobalConfig;
import org.coursera.courier.swift.SwiftProperties;
import org.coursera.courier.swift.SwiftStringEscaper;
import org.coursera.courier.swift.SwiftyJSON;

public class SwiftSyntax {
    private final ClassTemplateSpec classSpec;
    private final SwiftProperties swiftProperties;
    private final GlobalConfig globalConfig;
    private static final Set<String> swiftKeywords = new HashSet<String>(Arrays.asList("class", "deinit", "enum", "extension", "func", "import", "init", "inout", "internal", "let", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "catch", "dynamicType", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "__COLUMN__", "__FILE__", "__FUNCTION__", "__LINE__", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet"));
    private static final Set<String> reservedSymbols = new HashSet<String>(Arrays.asList("readJSON", "writeJSON", "validate", "toData"));

    public SwiftSyntax(ClassTemplateSpec classTemplateSpec, SwiftProperties swiftProperties, GlobalConfig globalConfig) {
        this.classSpec = classTemplateSpec;
        this.swiftProperties = swiftProperties;
        this.globalConfig = globalConfig;
    }

    public static String escapeKeyword(String string) {
        if (swiftKeywords.contains(string)) {
            return "`" + string + "`";
        }
        if (reservedSymbols.contains(string)) {
            return string + "$";
        }
        return string;
    }

    public static String escapeString(String string) {
        return SwiftStringEscaper.escape(string);
    }

    public static String escapedFullname(ClassTemplateSpec classTemplateSpec) {
        return SwiftSyntax.toFullname(null, SwiftSyntax.escapeKeyword(classTemplateSpec.getClassName()));
    }

    private static String toFullname(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + "." + string2;
    }

    public String toType(ClassTemplateSpec classTemplateSpec, boolean bl) {
        String string = this.toTypeString(classTemplateSpec);
        return string + (bl ? "?" : "");
    }

    public boolean isOptional(RecordTemplateSpec.Field field) {
        boolean bl = field.getSchemaField().getOptional();
        return bl || this.swiftProperties.optionality == SwiftProperties.Optionality.REQUIRED_FIELDS_MAY_BE_ABSENT;
    }

    public boolean isEquatable() {
        if (this.classSpec instanceof UnionTemplateSpec) {
            UnionTemplateSpec unionTemplateSpec = (UnionTemplateSpec)this.classSpec;
            TyperefTemplateSpec typerefTemplateSpec = unionTemplateSpec.getTyperefClass();
            if (typerefTemplateSpec == null) {
                return this.globalConfig.defaults.equatable;
            }
            return this.globalConfig.lookupSwiftProperties((ClassTemplateSpec)typerefTemplateSpec).equatable;
        }
        return this.swiftProperties.equatable;
    }

    private String toTypeString(ClassTemplateSpec classTemplateSpec) {
        if (classTemplateSpec.getSchema() == null) {
            return SwiftSyntax.escapedFullname(classTemplateSpec);
        }
        DataSchema.Type type = classTemplateSpec.getSchema().getType();
        if (type == DataSchema.Type.INT) {
            return "Int";
        }
        if (type == DataSchema.Type.LONG) {
            return "Int";
        }
        if (type == DataSchema.Type.FLOAT) {
            return "Float";
        }
        if (type == DataSchema.Type.DOUBLE) {
            return "Double";
        }
        if (type == DataSchema.Type.STRING) {
            return "String";
        }
        if (type == DataSchema.Type.BOOLEAN) {
            return "Bool";
        }
        if (type == DataSchema.Type.BYTES) {
            return "String";
        }
        if (type == DataSchema.Type.FIXED) {
            return "String";
        }
        if (type == DataSchema.Type.ENUM) {
            return SwiftSyntax.escapedFullname(classTemplateSpec);
        }
        if (type == DataSchema.Type.RECORD) {
            return SwiftSyntax.escapedFullname(classTemplateSpec);
        }
        if (type == DataSchema.Type.UNION) {
            return SwiftSyntax.escapedFullname(classTemplateSpec);
        }
        if (type == DataSchema.Type.MAP) {
            return "[String: " + this.toTypeString(((CourierMapTemplateSpec)classTemplateSpec).getValueClass()) + "]";
        }
        if (type == DataSchema.Type.ARRAY) {
            return "[" + this.toTypeString(((ArrayTemplateSpec)classTemplateSpec).getItemClass()) + "]";
        }
        throw new IllegalArgumentException("unrecognized type: " + type);
    }

    public static String toUnionMemberName(ClassTemplateSpec classTemplateSpec) {
        if (classTemplateSpec.getSchema() == null) {
            return classTemplateSpec.getClassName() + "Member";
        }
        DataSchema.Type type = classTemplateSpec.getSchema().getType();
        if (type == DataSchema.Type.INT) {
            return "IntMember";
        }
        if (type == DataSchema.Type.LONG) {
            return "LongMember";
        }
        if (type == DataSchema.Type.FLOAT) {
            return "FloatMember";
        }
        if (type == DataSchema.Type.DOUBLE) {
            return "DoubleMember";
        }
        if (type == DataSchema.Type.STRING) {
            return "StringMember";
        }
        if (type == DataSchema.Type.BOOLEAN) {
            return "BooleanMember";
        }
        if (type == DataSchema.Type.BYTES) {
            return "BytesMember";
        }
        if (type == DataSchema.Type.FIXED) {
            return "FixedMember";
        }
        if (type == DataSchema.Type.ENUM) {
            return classTemplateSpec.getClassName() + "Member";
        }
        if (type == DataSchema.Type.RECORD) {
            return classTemplateSpec.getClassName() + "Member";
        }
        if (type == DataSchema.Type.MAP) {
            return "MapMember";
        }
        if (type == DataSchema.Type.ARRAY) {
            return "ArrayMember";
        }
        throw new IllegalArgumentException("unrecognized type: " + type);
    }

    public String defaultToLiteral(RecordTemplateSpec.Field field) {
        boolean bl = Boolean.TRUE.equals(field.getSchemaField().getProperties().get("explicit"));
        if (!bl && field.getSchemaField().getOptional()) {
            return "nil";
        }
        CustomInfoSpec customInfoSpec = field.getCustomInfo();
        if (customInfoSpec != null) {
            DataSchema dataSchema = customInfoSpec.getCustomSchema().getDereferencedDataSchema();
            ClassTemplateSpec classTemplateSpec = ClassTemplateSpec.createFromDataSchema((DataSchema)dataSchema);
            String string = customInfoSpec.getCoercerClass().getClassName();
            String string2 = SwiftSyntax.toLiteral(classTemplateSpec.getSchema(), field.getSchemaField().getDefault());
            if (string2 == null) {
                return null;
            }
            return SwiftyJSON.expr(string).coercerInput(SwiftyJSON.expr(string2)).toSwiftCode().replaceFirst("try", "try!");
        }
        ClassTemplateSpec classTemplateSpec = field.getType();
        return SwiftSyntax.toLiteral(classTemplateSpec.getSchema(), field.getSchemaField().getDefault());
    }

    public static String toLiteral(DataSchema dataSchema, Object object) {
        if (object == null) {
            return null;
        }
        if (dataSchema instanceof EnumDataSchema) {
            if (object instanceof String) {
                return "." + SwiftSyntax.escapeKeyword(object.toString());
            }
        } else if (dataSchema instanceof PrimitiveDataSchema) {
            if (dataSchema instanceof StringDataSchema && object instanceof String) {
                return "\"" + SwiftSyntax.escapeString((String)object) + "\"";
            }
            if (dataSchema instanceof BooleanDataSchema && object instanceof Boolean) {
                return object.toString();
            }
            if (dataSchema instanceof BytesDataSchema && object instanceof ByteString) {
                ByteString byteString = (ByteString)object;
                return "\"" + SwiftSyntax.escapeString(byteString.asAvroString()) + "\"";
            }
            if (dataSchema instanceof NullDataSchema && object == Null.getInstance()) {
                return "nil";
            }
            if (object instanceof Number) {
                return object.toString();
            }
        } else {
            if (dataSchema instanceof RecordDataSchema && object instanceof DataMap) {
                StringBuilder stringBuilder = new StringBuilder();
                DataMap dataMap = (DataMap)object;
                RecordDataSchema recordDataSchema = (RecordDataSchema)dataSchema;
                return SwiftSyntax.toRecordLiteral(stringBuilder, dataMap, recordDataSchema);
            }
            if (dataSchema instanceof UnionDataSchema && object instanceof DataMap) {
                DataMap dataMap = (DataMap)object;
                UnionDataSchema unionDataSchema = (UnionDataSchema)dataSchema;
                return SwiftSyntax.toUnionLiteral(dataMap, unionDataSchema);
            }
            if (dataSchema instanceof ArrayDataSchema && object instanceof DataList) {
                DataList dataList = (DataList)object;
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)dataSchema;
                return SwiftSyntax.toArrayLiteral(dataList, arrayDataSchema);
            }
            if (dataSchema instanceof MapDataSchema && object instanceof DataMap) {
                DataMap dataMap = (DataMap)object;
                MapDataSchema mapDataSchema = (MapDataSchema)dataSchema;
                return SwiftSyntax.toMapLiteral(dataMap, mapDataSchema);
            }
        }
        throw new IllegalArgumentException("Unsupported default value: " + object + " for type: " + dataSchema.getType());
    }

    private static String toRecordLiteral(StringBuilder stringBuilder, DataMap dataMap, RecordDataSchema recordDataSchema) {
        Iterator iterator = recordDataSchema.getFields().iterator();
        stringBuilder.append(SwiftSyntax.escapeKeyword(recordDataSchema.getName()));
        stringBuilder.append("(");
        while (iterator.hasNext()) {
            RecordDataSchema.Field field = (RecordDataSchema.Field)iterator.next();
            stringBuilder.append(SwiftSyntax.escapeKeyword(field.getName()));
            stringBuilder.append(": ");
            stringBuilder.append(SwiftSyntax.toLiteral(field.getType(), dataMap.get((Object)field.getName())));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String toArrayLiteral(DataList dataList, ArrayDataSchema arrayDataSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        DataSchema dataSchema = arrayDataSchema.getItems().getDereferencedDataSchema();
        Iterator iterator = dataList.iterator();
        stringBuilder.append("[");
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(SwiftSyntax.toLiteral(dataSchema, e));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String toUnionLiteral(DataMap dataMap, UnionDataSchema unionDataSchema) {
        Iterator iterator = dataMap.entrySet().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        Map.Entry entry = (Map.Entry)iterator.next();
        DataSchema dataSchema = unionDataSchema.getTypeByName((String)entry.getKey());
        if (dataSchema == null) {
            throw new IllegalArgumentException("Unrecognized union member in literal: " + (String)entry.getKey());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".");
        stringBuilder.append(SwiftSyntax.toUnionMemberName(ClassTemplateSpec.createFromDataSchema((DataSchema)dataSchema)));
        stringBuilder.append("(");
        stringBuilder.append(SwiftSyntax.toLiteral(dataSchema, entry.getValue()));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String toMapLiteral(DataMap dataMap, MapDataSchema mapDataSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        DataSchema dataSchema = mapDataSchema.getValues().getDereferencedDataSchema();
        Iterator iterator = dataMap.entrySet().iterator();
        stringBuilder.append("[");
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            stringBuilder.append("\"");
            stringBuilder.append(SwiftSyntax.escapeString((String)entry.getKey()));
            stringBuilder.append("\"");
            stringBuilder.append(": ");
            stringBuilder.append(SwiftSyntax.toLiteral(dataSchema, entry.getValue()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

