/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.swift;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.HashMap;
import java.util.Map;
import org.coursera.courier.api.CourierMapTemplateSpec;
import org.coursera.courier.swift.SwiftSyntax;

public class SwiftyJSON {
    private static final Map<DataSchema.Type, String> swiftyTypeAccessors;
    private static final Map<DataSchema.Type, String> swiftyTypeEnumSymbols;
    private SwiftSyntax syntax;
    static Expr $0;

    public SwiftyJSON(SwiftSyntax swiftSyntax) {
        this.syntax = swiftSyntax;
    }

    public String toGetAccessor(String string, UnionTemplateSpec.Member member) {
        ClassTemplateSpec classTemplateSpec = member.getClassTemplateSpec();
        return this.readTypeExpr(SwiftyJSON.expr(string), classTemplateSpec, null, false).toSwiftCode();
    }

    public String toGetAccessor(String string, RecordTemplateSpec.Field field) {
        CustomInfoSpec customInfoSpec = field.getCustomInfo();
        return this.readTypeExpr(SwiftyJSON.expr(string), this.selectFieldType(field), customInfoSpec, this.syntax.isOptional(field)).toSwiftCode();
    }

    private Expr readTypeExpr(Expr expr, ClassTemplateSpec classTemplateSpec, CustomInfoSpec customInfoSpec, boolean bl) {
        boolean bl2;
        DataSchema dataSchema = classTemplateSpec.getSchema();
        Expr expr2 = this.checkedTypeAccessorExpr(expr, dataSchema, bl);
        boolean bl3 = bl2 = dataSchema.isPrimitive() || dataSchema.getType() == DataSchema.Type.FIXED;
        if (bl2) {
            if (customInfoSpec != null) {
                Expr expr3 = SwiftyJSON.expr(customInfoSpec.getCoercerClass().getClassName());
                if (bl) {
                    return expr2.map(expr3.coercerInput($0));
                }
                return expr3.coercerInput(expr2);
            }
            return expr2;
        }
        if (customInfoSpec != null) {
            Expr expr4 = SwiftyJSON.expr(customInfoSpec.getCoercerClass().getClassName());
            if (bl) {
                return expr2.map(expr4.coercerInput(this.readTypeExpr($0, classTemplateSpec)));
            }
            return expr4.coercerInput(this.readTypeExpr(expr2, classTemplateSpec));
        }
        if (bl) {
            return expr2.map(this.readTypeExpr($0, classTemplateSpec));
        }
        return this.readTypeExpr(expr2, classTemplateSpec);
    }

    private Expr readTypeExpr(Expr expr, ClassTemplateSpec classTemplateSpec) {
        DataSchema.Type type = classTemplateSpec.getSchema().getType();
        Expr expr2 = SwiftyJSON.expr(classTemplateSpec.getClassName());
        switch (type) {
            case ENUM: {
                return expr2.enumRead(expr);
            }
            case RECORD: 
            case UNION: {
                return expr2.readJSON(expr);
            }
            case MAP: {
                CourierMapTemplateSpec courierMapTemplateSpec = (CourierMapTemplateSpec)classTemplateSpec;
                ClassTemplateSpec classTemplateSpec2 = this.selectMapValueType(courierMapTemplateSpec);
                return expr.mapValues(this.readTypeExpr($0, classTemplateSpec2, courierMapTemplateSpec.getCustomInfo(), false));
            }
            case ARRAY: {
                ArrayTemplateSpec arrayTemplateSpec = (ArrayTemplateSpec)classTemplateSpec;
                ClassTemplateSpec classTemplateSpec3 = this.selectArrayItemsType(arrayTemplateSpec);
                return expr.map(this.readTypeExpr($0, classTemplateSpec3, arrayTemplateSpec.getCustomInfo(), false));
            }
        }
        throw new IllegalArgumentException("unrecognized type: " + type);
    }

    private Expr checkedTypeAccessorExpr(Expr expr, DataSchema dataSchema, boolean bl) {
        Expr expr2 = SwiftyJSON.expr(this.typeEnumSymbol(dataSchema));
        String string = this.typeAccessor(dataSchema, bl);
        if (bl) {
            return expr.optional(expr2).dot(string);
        }
        return expr.required(expr2).dot(string);
    }

    private String typeAccessor(DataSchema dataSchema, boolean bl) {
        String string = this.typeAccessor(dataSchema);
        if (!bl) {
            return string + "Value";
        }
        return string;
    }

    private String typeAccessor(DataSchema dataSchema) {
        DataSchema.Type type = dataSchema.getType();
        String string = swiftyTypeAccessors.get(type);
        if (string == null) {
            throw new IllegalArgumentException("unrecognized type: " + type);
        }
        return string;
    }

    private String typeEnumSymbol(DataSchema dataSchema) {
        DataSchema.Type type = dataSchema.getType();
        String string = swiftyTypeEnumSymbols.get(type);
        if (string == null) {
            throw new IllegalArgumentException("unrecognized type: " + type);
        }
        return string;
    }

    public String toSetAccessor(String string, UnionTemplateSpec.Member member) {
        return this.writeTypeExpr(SwiftyJSON.expr(string), member.getClassTemplateSpec()).toSwiftCode();
    }

    public String toSetAccessor(String string, RecordTemplateSpec.Field field) {
        return this.writeTypeExpr(SwiftyJSON.expr(string), this.selectFieldType(field), field.getCustomInfo()).toSwiftCode();
    }

    private Expr writeTypeExpr(Expr expr, ClassTemplateSpec classTemplateSpec, CustomInfoSpec customInfoSpec) {
        if (customInfoSpec != null) {
            Expr expr2 = SwiftyJSON.expr(customInfoSpec.getCoercerClass().getClassName());
            return expr2.coercerOutput(this.writeTypeExpr(expr, classTemplateSpec));
        }
        return this.writeTypeExpr(expr, classTemplateSpec);
    }

    private Expr writeTypeExpr(Expr expr, ClassTemplateSpec classTemplateSpec) {
        DataSchema.Type type = classTemplateSpec.getSchema().getType();
        switch (type) {
            case ENUM: {
                return expr.enumWrite();
            }
            case RECORD: 
            case UNION: {
                return expr.writeData();
            }
            case MAP: {
                CourierMapTemplateSpec courierMapTemplateSpec = (CourierMapTemplateSpec)classTemplateSpec;
                ClassTemplateSpec classTemplateSpec2 = this.selectMapValueType(courierMapTemplateSpec);
                CustomInfoSpec customInfoSpec = courierMapTemplateSpec.getCustomInfo();
                if (customInfoSpec != null) {
                    Expr expr2 = SwiftyJSON.expr(customInfoSpec.getCoercerClass().getClassName());
                    return expr.mapValues(this.writeTypeExpr(expr2.coercerOutput($0), classTemplateSpec2));
                }
                if (classTemplateSpec2.getSchema().isPrimitive()) {
                    return expr;
                }
                return expr.mapValues(this.writeTypeExpr($0, classTemplateSpec2));
            }
            case ARRAY: {
                ArrayTemplateSpec arrayTemplateSpec = (ArrayTemplateSpec)classTemplateSpec;
                ClassTemplateSpec classTemplateSpec3 = this.selectArrayItemsType(arrayTemplateSpec);
                CustomInfoSpec customInfoSpec = arrayTemplateSpec.getCustomInfo();
                if (customInfoSpec != null) {
                    Expr expr3 = SwiftyJSON.expr(customInfoSpec.getCoercerClass().getClassName());
                    return expr.map(this.writeTypeExpr(expr3.coercerOutput($0), classTemplateSpec3));
                }
                if (classTemplateSpec3.getSchema().isPrimitive()) {
                    return expr;
                }
                return expr.map(this.writeTypeExpr($0, classTemplateSpec3));
            }
        }
        return expr;
    }

    private ClassTemplateSpec selectFieldType(RecordTemplateSpec.Field field) {
        return this.getDereferencedType(field.getCustomInfo(), field.getType());
    }

    private ClassTemplateSpec selectMapValueType(CourierMapTemplateSpec courierMapTemplateSpec) {
        return this.getDereferencedType(courierMapTemplateSpec.getCustomInfo(), courierMapTemplateSpec.getValueClass());
    }

    private ClassTemplateSpec selectArrayItemsType(ArrayTemplateSpec arrayTemplateSpec) {
        return this.getDereferencedType(arrayTemplateSpec.getCustomInfo(), arrayTemplateSpec.getItemClass());
    }

    private ClassTemplateSpec getDereferencedType(CustomInfoSpec customInfoSpec, ClassTemplateSpec classTemplateSpec) {
        if (customInfoSpec != null) {
            DataSchema dataSchema = customInfoSpec.getCustomSchema().getDereferencedDataSchema();
            return ClassTemplateSpec.createFromDataSchema((DataSchema)dataSchema);
        }
        return classTemplateSpec;
    }

    static Expr expr(String string) {
        return new Expr(string);
    }

    static {
        HashMap<Object, String> hashMap = new HashMap<DataSchema.Type, String>();
        hashMap.put(DataSchema.Type.INT, "int");
        hashMap.put(DataSchema.Type.LONG, "int");
        hashMap.put(DataSchema.Type.FLOAT, "float");
        hashMap.put(DataSchema.Type.DOUBLE, "double");
        hashMap.put(DataSchema.Type.STRING, "string");
        hashMap.put(DataSchema.Type.BOOLEAN, "bool");
        hashMap.put(DataSchema.Type.BYTES, "string");
        hashMap.put(DataSchema.Type.FIXED, "string");
        hashMap.put(DataSchema.Type.ENUM, "string");
        hashMap.put(DataSchema.Type.RECORD, "json");
        hashMap.put(DataSchema.Type.UNION, "json");
        hashMap.put(DataSchema.Type.MAP, "dictionary");
        hashMap.put(DataSchema.Type.ARRAY, "array");
        swiftyTypeAccessors = hashMap;
        hashMap = new HashMap();
        hashMap.put(DataSchema.Type.INT, ".Number");
        hashMap.put(DataSchema.Type.LONG, ".Number");
        hashMap.put(DataSchema.Type.FLOAT, ".Number");
        hashMap.put(DataSchema.Type.DOUBLE, ".Number");
        hashMap.put(DataSchema.Type.STRING, ".String");
        hashMap.put(DataSchema.Type.BOOLEAN, ".Bool");
        hashMap.put(DataSchema.Type.BYTES, ".String");
        hashMap.put(DataSchema.Type.FIXED, ".String");
        hashMap.put(DataSchema.Type.ENUM, ".String");
        hashMap.put(DataSchema.Type.RECORD, ".Dictionary");
        hashMap.put(DataSchema.Type.UNION, ".Dictionary");
        hashMap.put(DataSchema.Type.MAP, ".Dictionary");
        hashMap.put(DataSchema.Type.ARRAY, ".Array");
        swiftyTypeEnumSymbols = hashMap;
        $0 = SwiftyJSON.expr("$0");
    }

    static class Expr {
        private final String expr;
        private final boolean directThrows;
        private final boolean containsThrow;
        private final boolean rethrows;

        public Expr(String string) {
            this(string, false, false, false);
        }

        public Expr(String string, boolean bl, boolean bl2, boolean bl3) {
            this.expr = string;
            this.directThrows = bl;
            this.containsThrow = bl2;
            this.rethrows = bl3;
        }

        public Expr map(Expr expr) {
            return this.apply("map", expr).rethrows();
        }

        public Expr mapValues(Expr expr) {
            return this.apply("mapValues", expr).rethrows();
        }

        public Expr readJSON(Expr expr) {
            return this.call("readJSON", expr).directlyThrows();
        }

        public Expr writeData() {
            return this.call("writeData");
        }

        public Expr enumRead(Expr expr) {
            return this.call("read", expr);
        }

        public Expr enumWrite() {
            return this.call("write");
        }

        public Expr coercerInput(Expr expr) {
            return this.call("coerceInput", expr).directlyThrows();
        }

        public Expr coercerOutput(Expr expr) {
            return this.call("coerceOutput", expr);
        }

        public Expr optional(Expr expr) {
            return this.call("optional", expr).directlyThrows();
        }

        public Expr required(Expr expr) {
            return this.call("required", expr).directlyThrows();
        }

        public Expr directlyThrows() {
            return new Expr(this.expr, true, true, this.rethrows);
        }

        public Expr rethrows() {
            return new Expr(this.expr, this.directThrows, this.containsThrow, true);
        }

        public Expr dot(String string) {
            return new Expr(this.expr + "." + string, false, this.containsThrow, true);
        }

        public Expr call(String string) {
            return new Expr(this.expr + "." + string + "()", false, this.containsThrow, false);
        }

        public Expr call(String string, Expr expr) {
            return new Expr(this.expr + "." + string + "(" + expr.toSwiftCode() + ")", false, this.containsThrow || expr.containsThrow, false);
        }

        public Expr apply(String string, Expr expr) {
            return new Expr(this.expr + "." + string + " { " + expr.toSwiftCode() + " }", false, this.containsThrow || expr.containsThrow, false);
        }

        public String toSwiftCode() {
            if (this.directThrows || this.containsThrow && this.rethrows) {
                return "try " + this.expr;
            }
            return this.expr;
        }
    }
}

