/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.swift;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeEscaper;

public class SwiftStringEscaper {
    private static final String[][] SWIFT_CTRL_CHARS_ESCAPE = new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}, {"\b", "\\u{8}"}, {"\n", "\\n"}, {"\t", "\\t"}, {"\f", "\\u{C}"}, {"\r", "\\r"}};
    private static final CharSequenceTranslator ESCAPE_SWIFT = new LookupTranslator((CharSequence[][])SWIFT_CTRL_CHARS_ESCAPE).with(new CharSequenceTranslator[]{SwiftUnicodeEscaper.outsideOf(32, 127)});

    public static String escape(String string) {
        return ESCAPE_SWIFT.translate((CharSequence)string);
    }

    private static final class SwiftUnicodeEscaper
    extends UnicodeEscaper {
        private final int below;
        private final int above;
        private final boolean between;

        public static SwiftUnicodeEscaper outsideOf(int n, int n2) {
            return new SwiftUnicodeEscaper(n, n2, false);
        }

        protected SwiftUnicodeEscaper(int n, int n2, boolean bl) {
            super(n, n2, bl);
            this.below = n;
            this.above = n2;
            this.between = bl;
        }

        public boolean translate(int n, Writer writer) throws IOException {
            if (this.between ? n < this.below || n > this.above : n >= this.below && n <= this.above) {
                return false;
            }
            if (n > 65535) {
                writer.write(this.toUtf16Escape(n));
            } else if (n > 4095) {
                writer.write("\\u{" + SwiftUnicodeEscaper.hex((int)n) + "}");
            } else if (n > 255) {
                writer.write("\\u{0" + SwiftUnicodeEscaper.hex((int)n) + "}");
            } else if (n > 15) {
                writer.write("\\u{00" + SwiftUnicodeEscaper.hex((int)n) + "}");
            } else {
                writer.write("\\u{000" + SwiftUnicodeEscaper.hex((int)n) + "}");
            }
            return true;
        }
    }
}

