/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.naptime.ari.graphql.schema;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.coursera.naptime.ResourceName;
import org.coursera.naptime.ari.engine.Utilities$;
import org.coursera.naptime.ari.graphql.schema.DataMapWithParent;
import org.coursera.naptime.ari.graphql.schema.NaptimePaginationField$;
import org.coursera.naptime.schema.GraphQLRelationAnnotation;
import org.coursera.naptime.schema.Handler;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import sangria.marshalling.FromInput;
import sangria.marshalling.FromInput$;
import sangria.schema.Argument;
import sangria.schema.Argument$;
import sangria.schema.InputType;
import sangria.schema.ListInputType;
import sangria.schema.OptionInputType;
import sangria.schema.ScalarType;
import sangria.schema.WithoutInputTypeTags;
import sangria.schema.WithoutInputTypeTags$;
import sangria.schema.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class NaptimeResourceUtils$
implements StrictLogging {
    public static NaptimeResourceUtils$ MODULE$;
    private final List<String> PAGINATION_ARGUMENT_NAMES;
    private final String INTERPOLATION_PATH_SPLIT_REGEX;
    private final Regex InterpolationRegex;
    private final Logger logger;

    static {
        new NaptimeResourceUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public List<Argument<Object>> generateHandlerArguments(Handler handler, boolean includePagination) {
        List baseParameters = ((TraversableOnce)((TraversableLike)handler.parameters().filterNot((Function1 & Serializable & scala.Serializable)parameter -> BoxesRunTime.boxToBoolean((boolean)NaptimeResourceUtils$.MODULE$.PAGINATION_ARGUMENT_NAMES.contains((Object)parameter.name())))).map((Function1 & Serializable & scala.Serializable)parameter -> {
            FromInput optionalFromInputType;
            InputType optionalInputType;
            block10: {
                Tuple2 tuple2;
                block9: {
                    boolean bl;
                    boolean bl2;
                    Tuple2 tuple22;
                    String tpe = parameter.type();
                    InputType<Object> inputType = MODULE$.scalaTypeToSangria(tpe);
                    FromInput<Object> fromInputType = MODULE$.scalaTypeToFromInput(tpe);
                    Tuple2 tuple23 = new Tuple2(inputType, (Object)BoxesRunTime.boxToBoolean((boolean)parameter.required()));
                    if (tuple23 != null && tuple23._1() instanceof OptionInputType) {
                        tuple22 = new Tuple2(inputType, fromInputType);
                    } else if (tuple23 != null && !(bl2 = tuple23._2$mcZ$sp())) {
                        tuple22 = new Tuple2((Object)new OptionInputType(inputType), (Object)FromInput$.MODULE$.optionInput(fromInputType));
                    } else if (tuple23 != null && (bl = tuple23._2$mcZ$sp())) {
                        tuple22 = new Tuple2(inputType, fromInputType);
                    } else {
                        throw new MatchError((Object)tuple23);
                    }
                    tuple2 = tuple22;
                    if (tuple2 == null) break block9;
                    optionalInputType = (InputType)tuple2._1();
                    optionalFromInputType = (FromInput)tuple2._2();
                    if (optionalFromInputType instanceof FromInput) break block10;
                }
                throw new MatchError((Object)tuple2);
            }
            FromInput fromInput = optionalFromInputType;
            Tuple2 tuple2 = new Tuple2((Object)optionalInputType, (Object)fromInput);
            Tuple2 tuple24 = tuple2;
            InputType optionalInputType2 = (InputType)tuple24._1();
            FromInput optionalFromInputType2 = (FromInput)tuple24._2();
            return Argument$.MODULE$.apply(parameter.name(), optionalInputType2, optionalFromInputType2, (WithoutInputTypeTags)Predef$.MODULE$.implicitly((Object)WithoutInputTypeTags$.MODULE$.defaultArgTpe()));
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        List paginationParameters = includePagination ? NaptimePaginationField$.MODULE$.paginationArguments() : List$.MODULE$.empty();
        return ((TraversableOnce)((TraversableLike)baseParameters.$plus$plus((GenTraversableOnce)paginationParameters, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Argument)((IterableLike)x$4._2()).head(), Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public boolean generateHandlerArguments$default$2() {
        return false;
    }

    private InputType<Object> scalaTypeToSangria(String typeName) {
        ScalarType scalarType;
        Regex listPattern = new StringOps(Predef$.MODULE$.augmentString("(Set|List|Seq|immutable.Seq)\\[(.*)\\]")).r();
        Regex optionPattern = new StringOps(Predef$.MODULE$.augmentString("(Option)\\[(.*)\\]")).r();
        String string = typeName;
        Option option = listPattern.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String innerType = (String)((LinearSeqOptimized)option.get()).apply(1);
            scalarType = new ListInputType(this.scalaTypeToSangria(innerType));
        } else {
            Option option2 = optionPattern.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String innerType = (String)((LinearSeqOptimized)option2.get()).apply(1);
                scalarType = new OptionInputType(this.scalaTypeToSangria(innerType));
            } else {
                boolean bl = "string".equals(string) ? true : "String".equals(string);
                if (bl) {
                    scalarType = package$.MODULE$.StringType();
                } else {
                    boolean bl2 = "int".equals(string) ? true : "Int".equals(string);
                    if (bl2) {
                        scalarType = package$.MODULE$.IntType();
                    } else {
                        boolean bl3 = "long".equals(string) ? true : "Long".equals(string);
                        if (bl3) {
                            scalarType = package$.MODULE$.LongType();
                        } else {
                            boolean bl4 = "float".equals(string) ? true : "Float".equals(string);
                            if (bl4) {
                                scalarType = package$.MODULE$.FloatType();
                            } else {
                                boolean bl5 = "decimal".equals(string) ? true : "Decimal".equals(string);
                                if (bl5) {
                                    scalarType = package$.MODULE$.BigDecimalType();
                                } else {
                                    boolean bl6 = "boolean".equals(string) ? true : "Boolean".equals(string);
                                    if (bl6) {
                                        scalarType = package$.MODULE$.BooleanType();
                                    } else {
                                        BoxedUnit boxedUnit;
                                        if (this.logger().underlying().isInfoEnabled()) {
                                            this.logger().underlying().info("could not parse type from {}", new Object[]{typeName});
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        scalarType = package$.MODULE$.StringType();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return scalarType;
    }

    private FromInput<Object> scalaTypeToFromInput(String typeName) {
        FromInput fromInput;
        String string;
        Regex listPattern = new StringOps(Predef$.MODULE$.augmentString("(set|list|seq|immutable.Seq)\\[(.*)\\]")).r();
        Option option = listPattern.unapplySeq((CharSequence)(string = typeName.toLowerCase()));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String innerType = (String)((LinearSeqOptimized)option.get()).apply(1);
            FromInput<Object> listType = this.scalaTypeToFromInput(innerType);
            fromInput = FromInput$.MODULE$.seqInput(listType);
        } else {
            boolean bl = "string".equals(string) ? true : ("int".equals(string) ? true : ("long".equals(string) ? true : ("float".equals(string) ? true : ("decimal".equals(string) ? true : "boolean".equals(string)))));
            fromInput = bl ? FromInput$.MODULE$.coercedScalaInput() : FromInput$.MODULE$.coercedScalaInput();
        }
        return fromInput;
    }

    public String formatResourceName(ResourceName resourceName) {
        return new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(resourceName.topLevelName())).capitalize()).append("V").append(resourceName.version()).toString();
    }

    public JsValue parseToJson(Object value2) {
        JsNull$ jsNull$;
        block14: {
            Object object;
            while (true) {
                Object someValue;
                if (None$.MODULE$.equals(object = value2)) {
                    jsNull$ = JsNull$.MODULE$;
                    break block14;
                }
                if (!(object instanceof Some)) break;
                Some some = (Some)object;
                value2 = someValue = some.value();
            }
            if (object instanceof String) {
                String string = (String)object;
                jsNull$ = (JsValue)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(new StringOps(Predef$.MODULE$.augmentString(string)).toInt()))).toOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> new JsString(string));
            } else if (object instanceof Traversable) {
                Traversable traversable = (Traversable)object;
                jsNull$ = JsArray$.MODULE$.apply(((TraversableOnce)traversable.map((Function1 & Serializable & scala.Serializable)value -> MODULE$.parseToJson(value), Traversable$.MODULE$.canBuildFrom())).toSeq());
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                jsNull$ = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(n));
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                jsNull$ = new JsNumber(BigDecimal$.MODULE$.long2bigDecimal(l));
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                jsNull$ = new JsNumber(BigDecimal$.MODULE$.long2bigDecimal((long)f));
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                jsNull$ = new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(d));
            } else {
                jsNull$ = new JsString(value2.toString());
            }
        }
        return jsNull$;
    }

    public Set<Tuple2<String, JsValue>> interpolateArguments(DataMapWithParent data, GraphQLRelationAnnotation relation) {
        return relation.arguments().mapValues((Function1 & Serializable & scala.Serializable)value -> {
            Object object;
            List matches = NaptimeResourceUtils$.MODULE$.InterpolationRegex.findAllMatchIn((CharSequence)value).toList();
            Map variableNameToInterpolatedIds = ((TraversableOnce)matches.map((Function1 & Serializable & scala.Serializable)regexMatch -> {
                Option withoutBraces = Option$.MODULE$.apply((Object)regexMatch.group("withoutBraces"));
                Option withBraces = Option$.MODULE$.apply((Object)regexMatch.group("withBraces"));
                String variableName = (String)withoutBraces.orElse((Function0 & Serializable & scala.Serializable)() -> withBraces).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                List interpolatedIds = Utilities$.MODULE$.getValuesAtPath(data.parentModel().value(), data.parentModel().schema(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])variableName.split(NaptimeResourceUtils$.MODULE$.INTERPOLATION_PATH_SPLIT_REGEX)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)variableName), (Object)interpolatedIds);
            }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (((IterableLike)variableNameToInterpolatedIds.values().flatten((Function1)Predef$.MODULE$.$conforms())).isEmpty()) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("Arguments: {} did not result in id interpolation", new Object[]{value});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = matches.nonEmpty() ? List$.MODULE$.empty() : new .colon.colon(value, (List)Nil$.MODULE$);
            } else {
                object = MODULE$.interpolate((String)value, (Map<String, List<String>>)variableNameToInterpolatedIds);
            }
            return object;
        }).mapValues((Function1 & Serializable & scala.Serializable)value2 -> {
            List values = (List)value2.map((Function1 & Serializable & scala.Serializable)value -> MODULE$.parseToJson(value), List$.MODULE$.canBuildFrom());
            return values.length() > 1 ? JsArray$.MODULE$.apply((Seq)values) : (JsValue)values.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> JsNull$.MODULE$);
        }).toSet();
    }

    public List<String> interpolate(String argumentValue, Map<String, List<String>> variableNameToInterpolatedIds) {
        BoxedUnit boxedUnit;
        int numInterpolatedIds = BoxesRunTime.unboxToInt((Object)((TraversableOnce)variableNameToInterpolatedIds.values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.length()), scala.collection.Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        IndexedSeq fullyInterpolatedIds = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInterpolatedIds).map((Function1 & Serializable & scala.Serializable)i -> NaptimeResourceUtils$.MODULE$.InterpolationRegex.replaceAllIn((CharSequence)argumentValue, (Function1 & Serializable & scala.Serializable)regexMatch -> {
            String v;
            Option withBraces;
            Option withoutBraces = Option$.MODULE$.apply((Object)regexMatch.group("withoutBraces"));
            String variableName = (String)withoutBraces.orElse(() -> NaptimeResourceUtils$.$anonfun$interpolate$4(withBraces = Option$.MODULE$.apply((Object)regexMatch.group("withBraces")))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                List interpolatedIds = (List)variableNameToInterpolatedIds$1.apply((Object)variableName);
                return (String)interpolatedIds.apply(i % interpolatedIds.size());
            });
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable f = failure.exception();
                    if (NaptimeResourceUtils$.MODULE$.logger().underlying().isWarnEnabled()) {
                        NaptimeResourceUtils$.MODULE$.logger().underlying().warn(new StringBuilder(143).append("Could not interpolate, given argument value: ").append(argumentValue$1).append(", ").append("regexMatch: ").append(regexMatch).append(", current index: ").append(i).append(", ").append("numInterpolatedIds: ").append(numInterpolatedIds$1).append(", and ").append("variable name to interpolated ids map: ").append(variableNameToInterpolatedIds$1).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw f;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            String string = v = (String)success.value();
            return string;
        }), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(79).append("Arguments value: ").append(argumentValue).append("\t ").append("Variable names with interpolated ids: ").append(fullyInterpolatedIds).append("\t").append("After interpolation: ").append(fullyInterpolatedIds).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fullyInterpolatedIds.toList();
    }

    public static final /* synthetic */ Option $anonfun$interpolate$4(Option withBraces$2) {
        return withBraces$2;
    }

    private NaptimeResourceUtils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.PAGINATION_ARGUMENT_NAMES = (List)NaptimePaginationField$.MODULE$.paginationArguments().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom());
        this.INTERPOLATION_PATH_SPLIT_REGEX = "/";
        this.InterpolationRegex = new Regex("\\$(?:([a-zA-Z0-9_]+)|\\{([^\\}]+)\\})", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"withoutBraces", "withBraces"}));
    }
}

