/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import org.coursera.pegasus.UnionVariantHandler;

class TypedDefinitionHandler
extends UnionVariantHandler {
    private static final boolean FAIL_ON_UNRECOGNIZED_FIELDS = false;
    private final UnionDataSchema unionSchema;

    public TypedDefinitionHandler(TyperefDataSchema typerefSchema, UnionDataSchema unionSchema, DataMap mapping) {
        super(typerefSchema, mapping);
        this.unionSchema = unionSchema;
    }

    @Override
    public String name() {
        return "typedDefinition";
    }

    @Override
    public UnionVariantHandler.PegasusUnionFormat convertToPegasus(DataMap dataMap) throws IOException {
        String typeName = this.lookupTypeName(dataMap);
        Object definition = this.lookupDefinition(dataMap);
        DataSchema memberSchema = this.typeNameToMemberSchema(typeName);
        dataMap.clear();
        dataMap.put((Object)memberSchema.getUnionMemberKey(), definition);
        return new UnionVariantHandler.PegasusUnionFormat(memberSchema, definition);
    }

    @Override
    public UnionVariantHandler.TypedDefinitionUnionFormat convertFromPegasus(DataMap dataMap) throws IOException {
        UnionVariantHandler.PegasusUnionFormat union = UnionVariantHandler.PegasusUnionFormat.fromDataMap(dataMap, this.unionSchema);
        String typeName = this.memberSchemaToTypeName(union.memberSchema);
        Object definition = union.definition();
        dataMap.clear();
        dataMap.put((Object)"typeName", (Object)typeName);
        dataMap.put((Object)"definition", definition);
        return new UnionVariantHandler.TypedDefinitionUnionFormat(dataMap, new UnionVariantHandler.PegasusUnionFormat(union.memberSchema, definition));
    }
}

