/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import org.coursera.pegasus.UnionVariantHandler;

class TypedDefinitionHandler
extends UnionVariantHandler {
    private static final boolean FAIL_ON_UNRECOGNIZED_FIELDS = false;
    private final UnionDataSchema unionSchema;

    public TypedDefinitionHandler(TyperefDataSchema typerefDataSchema, UnionDataSchema unionDataSchema, DataMap dataMap) {
        super(typerefDataSchema, dataMap);
        this.unionSchema = unionDataSchema;
    }

    @Override
    public String name() {
        return "typedDefinition";
    }

    @Override
    public UnionVariantHandler.PegasusUnionFormat convertToPegasus(DataMap dataMap) throws IOException {
        String string = this.lookupTypeName(dataMap);
        Object object = this.lookupDefinition(dataMap);
        DataSchema dataSchema = this.typeNameToMemberSchema(string);
        dataMap.clear();
        dataMap.put((Object)dataSchema.getUnionMemberKey(), object);
        return new UnionVariantHandler.PegasusUnionFormat(dataSchema, object);
    }

    @Override
    public UnionVariantHandler.TypedDefinitionUnionFormat convertFromPegasus(DataMap dataMap) throws IOException {
        UnionVariantHandler.PegasusUnionFormat pegasusUnionFormat = UnionVariantHandler.PegasusUnionFormat.fromDataMap(dataMap, this.unionSchema);
        String string = this.memberSchemaToTypeName(pegasusUnionFormat.memberSchema);
        Object object = pegasusUnionFormat.definition();
        dataMap.clear();
        dataMap.put((Object)"typeName", (Object)string);
        dataMap.put((Object)"definition", object);
        return new UnionVariantHandler.TypedDefinitionUnionFormat(dataMap, new UnionVariantHandler.PegasusUnionFormat(pegasusUnionFormat.memberSchema, object));
    }
}

