/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coursera.pegasus.FlatTypedDefinitionHandler;
import org.coursera.pegasus.TypedDefinitionHandler;
import org.coursera.pegasus.UnionVariantHandler;

public class TypedDefinitionDataCoercer {
    private final DataSchema dataSchema;
    private final Boolean passthroughEnabled;

    public TypedDefinitionDataCoercer(DataSchema dataSchema) {
        this(dataSchema, false);
    }

    public TypedDefinitionDataCoercer(DataSchema dataSchema, Boolean bl) {
        this.dataSchema = dataSchema;
        this.passthroughEnabled = bl;
    }

    public <D extends DataComplex> D convertTypedDefinitionToUnion(D d) throws IOException {
        D d2 = this.copyIfImmutable(d);
        this.visitUnionTyperefs(d2, this.dataSchema, new TypedDefinitionToPegasusVisitor(), new HashSet<DataComplex>());
        return d2;
    }

    public <D extends DataComplex> D convertUnionToTypedDefinition(D d) throws IOException {
        D d2 = this.copyIfImmutable(d);
        this.visitUnionTyperefs(d2, this.dataSchema, new TypedDefinitionFromPegasusVisitor(), new HashSet<DataComplex>());
        return d2;
    }

    public <D extends DataComplex> void convertUnionToTypedDefinitionInPlace(D d) throws IOException, IllegalArgumentException {
        if (d.isReadOnly()) {
            throw new IllegalArgumentException("Data is read only!");
        }
        this.visitUnionTyperefs(d, this.dataSchema, new TypedDefinitionFromPegasusVisitor(), new HashSet<DataComplex>());
    }

    private <D extends DataComplex> D copyIfImmutable(D d) {
        try {
            return (D)d.copy();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    private UnionVariantHandler lookupTypedDefinitionHandler(UnionVariantHandler.UnionTyperefInfo unionTyperefInfo) throws IOException {
        TyperefDataSchema typerefDataSchema = unionTyperefInfo.typerefSchema;
        UnionDataSchema unionDataSchema = unionTyperefInfo.unionSchema;
        Map map = typerefDataSchema.getProperties();
        Object v = map.get("flatTypedDefinition");
        Object v2 = map.get("typedDefinition");
        if (v != null && v2 != null) {
            throw new IOException("'flatTypedDefinition' or 'typedDefinition' may be declared on " + typerefDataSchema.getFullName() + ", not both.");
        }
        if (v != null && v instanceof DataMap) {
            return new FlatTypedDefinitionHandler(typerefDataSchema, unionDataSchema, (DataMap)v);
        }
        if (v2 != null && v2 instanceof DataMap) {
            return new TypedDefinitionHandler(typerefDataSchema, unionDataSchema, (DataMap)v2);
        }
        return null;
    }

    private void visitUnionTyperefs(Object object, DataSchema dataSchema, Visitor visitor, Set<DataComplex> set) throws IOException {
        if (object instanceof DataComplex && set.contains(object)) {
            return;
        }
        DataSchema dataSchema2 = dataSchema.getDereferencedDataSchema();
        switch (dataSchema2.getType()) {
            case RECORD: {
                RecordDataSchema recordDataSchema = (RecordDataSchema)dataSchema2;
                if (!(object instanceof DataMap)) break;
                DataMap dataMap = (DataMap)object;
                ArrayList<String> arrayList = new ArrayList<String>(0);
                for (Map.Entry object2 : dataMap.entrySet()) {
                    String dataSchema4 = (String)object2.getKey();
                    Object v = object2.getValue();
                    if (v == Data.NULL) {
                        arrayList.add(dataSchema4);
                        continue;
                    }
                    RecordDataSchema.Field field = recordDataSchema.getField(dataSchema4);
                    if (field != null && !this.isScalaOmitted(field)) {
                        this.visitUnionTyperefs(v, field.getType(), visitor, set);
                        continue;
                    }
                    if (this.passthroughEnabled.booleanValue() || this.passthroughExempt(recordDataSchema)) continue;
                    arrayList.add(dataSchema4);
                }
                for (String dataMap2 : arrayList) {
                    dataMap.remove((Object)dataMap2);
                }
                break;
            }
            case UNION: {
                UnionDataSchema unionDataSchema = (UnionDataSchema)dataSchema2;
                if (!(object instanceof DataMap)) break;
                DataMap dataMap = (DataMap)object;
                UnionVariantHandler.PegasusUnionFormat pegasusUnionFormat = null;
                switch (dataSchema.getType()) {
                    case TYPEREF: {
                        pegasusUnionFormat = visitor.visit(new UnionVariantHandler.UnionTyperefInfo((TyperefDataSchema)dataSchema, unionDataSchema, dataMap));
                        break;
                    }
                    case UNION: {
                        pegasusUnionFormat = UnionVariantHandler.PegasusUnionFormat.fromDataMap(dataMap, unionDataSchema);
                    }
                }
                if (pegasusUnionFormat == null) break;
                this.visitUnionTyperefs(pegasusUnionFormat.definition, pegasusUnionFormat.memberSchema, visitor, set);
                break;
            }
            case ARRAY: {
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)dataSchema2;
                if (!(object instanceof DataList)) break;
                DataList dataList = (DataList)object;
                DataSchema dataSchema3 = arrayDataSchema.getItems();
                for (Object e : dataList.values()) {
                    this.visitUnionTyperefs(e, dataSchema3, visitor, set);
                }
                break;
            }
            case MAP: {
                MapDataSchema mapDataSchema = (MapDataSchema)dataSchema2;
                if (!(object instanceof DataMap)) break;
                DataMap dataMap = (DataMap)object;
                DataSchema dataSchema4 = mapDataSchema.getValues();
                for (Object e : dataMap.values()) {
                    this.visitUnionTyperefs(e, dataSchema4, visitor, set);
                }
                break;
            }
        }
        if (object instanceof DataComplex) {
            set.add((DataComplex)object);
        }
    }

    private boolean isScalaOmitted(RecordDataSchema.Field field) {
        DataMap dataMap = this.scalaProperties(field);
        if (dataMap != null) {
            Boolean bl = (Boolean)dataMap.get((Object)"omit");
            return bl != null && bl != false;
        }
        return false;
    }

    private DataMap scalaProperties(RecordDataSchema.Field field) {
        Map map = field.getProperties();
        if (map != null) {
            return (DataMap)map.get("scala");
        }
        return null;
    }

    private boolean passthroughExempt(RecordDataSchema recordDataSchema) {
        Map map = recordDataSchema.getProperties();
        if (map != null) {
            Object v = map.get("passthroughExempt");
            return Boolean.TRUE.equals(v);
        }
        return false;
    }

    private class TypedDefinitionFromPegasusVisitor
    implements Visitor {
        private TypedDefinitionFromPegasusVisitor() {
        }

        @Override
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo unionTyperefInfo) throws IOException {
            UnionVariantHandler unionVariantHandler = TypedDefinitionDataCoercer.this.lookupTypedDefinitionHandler(unionTyperefInfo);
            UnionVariantHandler.PegasusUnionFormat pegasusUnionFormat = null;
            if (unionVariantHandler != null) {
                pegasusUnionFormat = unionVariantHandler.convertFromPegasus((DataMap)unionTyperefInfo.dataMap).pegasusUnionEquivalent;
            }
            if (pegasusUnionFormat == null) {
                pegasusUnionFormat = UnionVariantHandler.PegasusUnionFormat.fromDataMap(unionTyperefInfo.dataMap, unionTyperefInfo.unionSchema);
            }
            return pegasusUnionFormat;
        }
    }

    private class TypedDefinitionToPegasusVisitor
    implements Visitor {
        private TypedDefinitionToPegasusVisitor() {
        }

        @Override
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo unionTyperefInfo) throws IOException {
            UnionVariantHandler unionVariantHandler = TypedDefinitionDataCoercer.this.lookupTypedDefinitionHandler(unionTyperefInfo);
            UnionVariantHandler.PegasusUnionFormat pegasusUnionFormat = null;
            if (unionVariantHandler != null) {
                pegasusUnionFormat = unionVariantHandler.convertToPegasus(unionTyperefInfo.dataMap);
            }
            if (pegasusUnionFormat == null) {
                pegasusUnionFormat = UnionVariantHandler.PegasusUnionFormat.fromDataMap(unionTyperefInfo.dataMap, unionTyperefInfo.unionSchema);
            }
            return pegasusUnionFormat;
        }
    }

    private static interface Visitor {
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo var1) throws IOException;
    }
}

