/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coursera.pegasus.FlatTypedDefinitionHandler;
import org.coursera.pegasus.TypedDefinitionHandler;
import org.coursera.pegasus.UnionVariantHandler;

public class TypedDefinitionDataCoercer {
    private final DataSchema dataSchema;
    private final Boolean passthroughEnabled;

    public TypedDefinitionDataCoercer(DataSchema dataSchema) {
        this(dataSchema, false);
    }

    public TypedDefinitionDataCoercer(DataSchema dataSchema, Boolean passthroughEnabled) {
        this.dataSchema = dataSchema;
        this.passthroughEnabled = passthroughEnabled;
    }

    public <D extends DataComplex> D convertTypedDefinitionToUnion(D data) throws IOException {
        D copy = this.copyIfImmutable(data);
        this.visitUnionTyperefs(copy, this.dataSchema, new TypedDefinitionToPegasusVisitor(), new HashSet<DataComplex>());
        return copy;
    }

    public <D extends DataComplex> D convertUnionToTypedDefinition(D data) throws IOException {
        D copy = this.copyIfImmutable(data);
        this.visitUnionTyperefs(copy, this.dataSchema, new TypedDefinitionFromPegasusVisitor(), new HashSet<DataComplex>());
        return copy;
    }

    public <D extends DataComplex> void convertUnionToTypedDefinitionInPlace(D data) throws IOException, IllegalArgumentException {
        if (data.isReadOnly()) {
            throw new IllegalArgumentException("Data is read only!");
        }
        this.visitUnionTyperefs(data, this.dataSchema, new TypedDefinitionFromPegasusVisitor(), new HashSet<DataComplex>());
    }

    private <D extends DataComplex> D copyIfImmutable(D data) {
        try {
            return (D)data.copy();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private UnionVariantHandler lookupTypedDefinitionHandler(UnionVariantHandler.UnionTyperefInfo info) throws IOException {
        TyperefDataSchema typerefSchema = info.typerefSchema;
        UnionDataSchema unionSchema = info.unionSchema;
        Map properties = typerefSchema.getProperties();
        Object flatDefinition = properties.get("flatTypedDefinition");
        Object definition = properties.get("typedDefinition");
        if (flatDefinition != null && definition != null) {
            throw new IOException("'flatTypedDefinition' or 'typedDefinition' may be declared on " + typerefSchema.getFullName() + ", not both.");
        }
        if (flatDefinition != null && flatDefinition instanceof DataMap) {
            return new FlatTypedDefinitionHandler(typerefSchema, unionSchema, (DataMap)flatDefinition);
        }
        if (definition != null && definition instanceof DataMap) {
            return new TypedDefinitionHandler(typerefSchema, unionSchema, (DataMap)definition);
        }
        return null;
    }

    private void visitUnionTyperefs(Object data, DataSchema schema, Visitor visitor, Set<DataComplex> visited) throws IOException {
        if (data instanceof DataComplex && visited.contains(data)) {
            return;
        }
        DataSchema deref = schema.getDereferencedDataSchema();
        switch (deref.getType()) {
            case RECORD: {
                RecordDataSchema recordSchema = (RecordDataSchema)deref;
                if (!(data instanceof DataMap)) break;
                DataMap dataMap = (DataMap)data;
                ArrayList<String> removals = new ArrayList<String>(0);
                for (Map.Entry entry : dataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == Data.NULL) {
                        removals.add(key);
                        continue;
                    }
                    RecordDataSchema.Field field = recordSchema.getField(key);
                    if (field != null && !this.isScalaOmitted(field)) {
                        this.visitUnionTyperefs(value, field.getType(), visitor, visited);
                        continue;
                    }
                    if (this.passthroughEnabled.booleanValue() || this.passthroughExempt(recordSchema)) continue;
                    removals.add(key);
                }
                for (String removal : removals) {
                    dataMap.remove((Object)removal);
                }
                break;
            }
            case UNION: {
                UnionDataSchema unionSchema = (UnionDataSchema)deref;
                if (!(data instanceof DataMap)) break;
                DataMap unionDataMap = (DataMap)data;
                UnionVariantHandler.PegasusUnionFormat pegasusUnion = null;
                switch (schema.getType()) {
                    case TYPEREF: {
                        pegasusUnion = visitor.visit(new UnionVariantHandler.UnionTyperefInfo((TyperefDataSchema)schema, unionSchema, unionDataMap));
                        break;
                    }
                    case UNION: {
                        pegasusUnion = UnionVariantHandler.PegasusUnionFormat.fromDataMap(unionDataMap, unionSchema);
                    }
                }
                if (pegasusUnion == null) break;
                this.visitUnionTyperefs(pegasusUnion.definition, pegasusUnion.memberSchema, visitor, visited);
                break;
            }
            case ARRAY: {
                ArrayDataSchema arraySchema = (ArrayDataSchema)deref;
                if (!(data instanceof DataList)) break;
                DataList dataList = (DataList)data;
                DataSchema itemsSchema = arraySchema.getItems();
                for (Object dataItem : dataList.values()) {
                    this.visitUnionTyperefs(dataItem, itemsSchema, visitor, visited);
                }
                break;
            }
            case MAP: {
                MapDataSchema mapSchema = (MapDataSchema)deref;
                if (!(data instanceof DataMap)) break;
                DataMap map = (DataMap)data;
                DataSchema valuesSchema = mapSchema.getValues();
                for (Object value : map.values()) {
                    this.visitUnionTyperefs(value, valuesSchema, visitor, visited);
                }
                break;
            }
        }
        if (data instanceof DataComplex) {
            visited.add((DataComplex)data);
        }
    }

    private boolean isScalaOmitted(RecordDataSchema.Field field) {
        DataMap properties = this.scalaProperties(field);
        if (properties != null) {
            Boolean omit = (Boolean)properties.get((Object)"omit");
            return omit != null && omit != false;
        }
        return false;
    }

    private DataMap scalaProperties(RecordDataSchema.Field field) {
        Map properties = field.getProperties();
        if (properties != null) {
            return (DataMap)properties.get("scala");
        }
        return null;
    }

    private boolean passthroughExempt(RecordDataSchema record) {
        Map properties = record.getProperties();
        if (properties != null) {
            Object passthroughExempt = properties.get("passthroughExempt");
            return Boolean.TRUE.equals(passthroughExempt);
        }
        return false;
    }

    private class TypedDefinitionFromPegasusVisitor
    implements Visitor {
        private TypedDefinitionFromPegasusVisitor() {
        }

        @Override
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo info) throws IOException {
            UnionVariantHandler handler = TypedDefinitionDataCoercer.this.lookupTypedDefinitionHandler(info);
            UnionVariantHandler.PegasusUnionFormat result = null;
            if (handler != null) {
                result = handler.convertFromPegasus((DataMap)info.dataMap).pegasusUnionEquivalent;
            }
            if (result == null) {
                result = UnionVariantHandler.PegasusUnionFormat.fromDataMap(info.dataMap, info.unionSchema);
            }
            return result;
        }
    }

    private class TypedDefinitionToPegasusVisitor
    implements Visitor {
        private TypedDefinitionToPegasusVisitor() {
        }

        @Override
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo info) throws IOException {
            UnionVariantHandler handler = TypedDefinitionDataCoercer.this.lookupTypedDefinitionHandler(info);
            UnionVariantHandler.PegasusUnionFormat result = null;
            if (handler != null) {
                result = handler.convertToPegasus(info.dataMap);
            }
            if (result == null) {
                result = UnionVariantHandler.PegasusUnionFormat.fromDataMap(info.dataMap, info.unionSchema);
            }
            return result;
        }
    }

    private static interface Visitor {
        public UnionVariantHandler.PegasusUnionFormat visit(UnionVariantHandler.UnionTyperefInfo var1) throws IOException;
    }
}

