/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.util.Map;
import org.coursera.pegasus.UnionVariantHandler;

class FlatTypedDefinitionHandler
extends UnionVariantHandler {
    private final UnionDataSchema unionSchema;

    public FlatTypedDefinitionHandler(TyperefDataSchema typerefSchema, UnionDataSchema unionSchema, DataMap mapping) {
        super(typerefSchema, mapping);
        this.unionSchema = unionSchema;
    }

    @Override
    public String name() {
        return "flatTypedDefinition";
    }

    @Override
    public UnionVariantHandler.PegasusUnionFormat convertToPegasus(DataMap dataMap) throws IOException {
        String typeName = this.lookupTypeName(dataMap);
        DataSchema memberSchema = this.typeNameToMemberSchema(typeName);
        dataMap.remove((Object)"typeName");
        try {
            DataMap definition = dataMap.clone();
            dataMap.clear();
            dataMap.put((Object)memberSchema.getUnionMemberKey(), (Object)definition);
            return new UnionVariantHandler.PegasusUnionFormat(memberSchema, definition);
        }
        catch (CloneNotSupportedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public UnionVariantHandler.TypedDefinitionUnionFormat convertFromPegasus(DataMap dataMap) throws IOException {
        UnionVariantHandler.PegasusUnionFormat union = UnionVariantHandler.PegasusUnionFormat.fromDataMap(dataMap, this.unionSchema);
        String typeName = this.memberSchemaToTypeName(union.memberSchema);
        DataMap definition = union.definitionAsDataMap();
        dataMap.clear();
        dataMap.put((Object)"typeName", (Object)typeName);
        dataMap.putAll((Map)definition);
        return new UnionVariantHandler.TypedDefinitionUnionFormat(dataMap, new UnionVariantHandler.PegasusUnionFormat(union.memberSchema, definition));
    }
}

