/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;

abstract class UnionVariantHandler {
    public static final String typedDefinitionField = "typedDefinition";
    public static final String flatTypedDefinitionField = "flatTypedDefinition";
    protected static final String typeNameField = "typeName";
    protected static final String definitionField = "definition";
    TyperefDataSchema typerefSchema;
    DataMap mapping;

    public UnionVariantHandler(TyperefDataSchema typerefSchema, DataMap mapping) {
        this.typerefSchema = typerefSchema;
        this.mapping = mapping;
    }

    public abstract String name();

    public abstract PegasusUnionFormat convertToPegasus(DataMap var1) throws IOException;

    public abstract TypedDefinitionUnionFormat convertFromPegasus(DataMap var1) throws IOException;

    public DataSchema typeNameToMemberSchema(String typeName) throws IOException {
        String memberKey = null;
        for (String key : this.mapping.keySet()) {
            Object value = this.mapping.get((Object)key);
            if (!value.equals(typeName)) continue;
            memberKey = key;
            break;
        }
        if (memberKey == null) {
            throw new IOException("No mapping in '" + this.name() + "' of '" + this.typerefSchema.getFullName() + "' found for typeName '" + typeName + "'.");
        }
        DataSchema memberType = null;
        DataSchema deref = this.typerefSchema.getDereferencedDataSchema();
        if (deref instanceof UnionDataSchema) {
            UnionDataSchema unionSchema = (UnionDataSchema)deref;
            memberType = unionSchema.getType(memberKey);
            if (memberType == null && !memberKey.contains(".")) {
                memberType = unionSchema.getType(this.typerefSchema.getNamespace() + "." + memberKey);
            }
            if (memberType == null) {
                throw new IOException("Union member '" + memberKey + "' not found for schema " + unionSchema);
            }
        }
        return memberType;
    }

    public String memberSchemaToTypeName(DataSchema memberSchema) throws IOException {
        String nsPrefix;
        String memberKey = memberSchema.getUnionMemberKey();
        Object type = this.mapping.get((Object)memberKey);
        if (type == null && memberKey.startsWith(nsPrefix = this.typerefSchema.getNamespace() + ".")) {
            String simpleName = memberKey.substring(nsPrefix.length());
            type = this.mapping.get((Object)simpleName);
        }
        if (type instanceof String) {
            return (String)type;
        }
        throw new IOException("No mapping in '" + this.name() + "' of '" + this.typerefSchema.getFullName() + "' found for memberKey '" + memberSchema.getUnionMemberKey() + "'. Mapping value must be a 'typeName' string.");
    }

    public String lookupTypeName(DataMap dataMap) throws IOException {
        String result = dataMap.getString(typeNameField);
        if (result == null) {
            throw new IOException("'" + this.name() + "' in '" + this.typerefSchema.getFullName() + "' requires data with a '" + typeNameField + "' string, but found " + dataMap);
        }
        return result;
    }

    public Object lookupDefinition(DataMap dataMap) throws IOException {
        Object result = dataMap.get((Object)definitionField);
        if (result == null) {
            throw new IOException("'" + this.name() + "' in '" + this.typerefSchema.getFullName() + "' requires data with a '" + definitionField + "' DataMap, but found " + dataMap);
        }
        return result;
    }

    static class UnionTyperefInfo {
        public final TyperefDataSchema typerefSchema;
        public final UnionDataSchema unionSchema;
        public final DataMap dataMap;

        public UnionTyperefInfo(TyperefDataSchema typerefSchema, UnionDataSchema unionSchema, DataMap dataMap) {
            this.typerefSchema = typerefSchema;
            this.unionSchema = unionSchema;
            this.dataMap = dataMap;
        }
    }

    static class PegasusUnionFormat {
        public final DataSchema memberSchema;
        public final Object definition;

        public PegasusUnionFormat(DataSchema memberSchema, Object definition) {
            this.memberSchema = memberSchema;
            this.definition = definition;
        }

        public Object definition() throws IOException {
            return this.definition;
        }

        public DataMap definitionAsDataMap() throws IOException {
            if (this.definition instanceof DataMap) {
                return (DataMap)this.definition;
            }
            throw new IOException("Type definition format requires a DataMap, but found: " + this.definition);
        }

        public static PegasusUnionFormat fromDataMap(DataMap dataMap, UnionDataSchema unionSchema) throws IOException {
            if (dataMap.size() != 1) {
                throw new IOException("Union DataMap must contain exactly one memberKey field, but found fields: " + dataMap.keySet());
            }
            String memberKey = (String)dataMap.keySet().iterator().next();
            Object definition = dataMap.get((Object)memberKey);
            DataSchema memberSchema = unionSchema.getType(memberKey);
            if (memberSchema != null) {
                return new PegasusUnionFormat(memberSchema, definition);
            }
            throw new IOException("Union member '" + memberKey + "' not found for schema " + unionSchema);
        }
    }

    static class TypedDefinitionUnionFormat {
        public final DataMap typedDefinitionData;
        public final PegasusUnionFormat pegasusUnionEquivalent;

        public TypedDefinitionUnionFormat(DataMap typedDefinitionData, PegasusUnionFormat pegasusUnionEquivalent) {
            this.typedDefinitionData = typedDefinitionData;
            this.pegasusUnionEquivalent = pegasusUnionEquivalent;
        }
    }
}

