/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.pegasus;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;

abstract class UnionVariantHandler {
    public static final String typedDefinitionField = "typedDefinition";
    public static final String flatTypedDefinitionField = "flatTypedDefinition";
    protected static final String typeNameField = "typeName";
    protected static final String definitionField = "definition";
    TyperefDataSchema typerefSchema;
    DataMap mapping;

    public UnionVariantHandler(TyperefDataSchema typerefDataSchema, DataMap dataMap) {
        this.typerefSchema = typerefDataSchema;
        this.mapping = dataMap;
    }

    public abstract String name();

    public abstract PegasusUnionFormat convertToPegasus(DataMap var1) throws IOException;

    public abstract TypedDefinitionUnionFormat convertFromPegasus(DataMap var1) throws IOException;

    public DataSchema typeNameToMemberSchema(String string) throws IOException {
        Object object;
        String string22;
        String string3 = null;
        for (String string22 : this.mapping.keySet()) {
            object = this.mapping.get((Object)string22);
            if (!object.equals(string)) continue;
            string3 = string22;
            break;
        }
        if (string3 == null) {
            throw new IOException("No mapping in '" + this.name() + "' of '" + this.typerefSchema.getFullName() + "' found for typeName " + "'" + string + "'.");
        }
        DataSchema dataSchema = null;
        string22 = this.typerefSchema.getDereferencedDataSchema();
        if (string22 instanceof UnionDataSchema) {
            object = (UnionDataSchema)string22;
            dataSchema = object.getType(string3);
            if (dataSchema == null && !string3.contains(".")) {
                dataSchema = object.getType(this.typerefSchema.getNamespace() + "." + string3);
            }
            if (dataSchema == null) {
                throw new IOException("Union member '" + string3 + "' not found for schema " + object);
            }
        }
        return dataSchema;
    }

    public String memberSchemaToTypeName(DataSchema dataSchema) throws IOException {
        String string;
        String string2 = dataSchema.getUnionMemberKey();
        Object object = this.mapping.get((Object)string2);
        if (object == null && string2.startsWith(string = this.typerefSchema.getNamespace() + ".")) {
            String string3 = string2.substring(string.length());
            object = this.mapping.get((Object)string3);
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IOException("No mapping in '" + this.name() + "' of '" + this.typerefSchema.getFullName() + "' found for memberKey " + "'" + dataSchema.getUnionMemberKey() + "'. Mapping value must be a 'typeName' string.");
    }

    public String lookupTypeName(DataMap dataMap) throws IOException {
        String string = dataMap.getString(typeNameField);
        if (string == null) {
            throw new IOException("'" + this.name() + "' in '" + this.typerefSchema.getFullName() + "' requires data with a '" + typeNameField + "' " + "string, but found " + dataMap);
        }
        return string;
    }

    public Object lookupDefinition(DataMap dataMap) throws IOException {
        Object object = dataMap.get((Object)definitionField);
        if (object == null) {
            throw new IOException("'" + this.name() + "' in '" + this.typerefSchema.getFullName() + "' requires data with a '" + definitionField + "' " + "DataMap, but found " + dataMap);
        }
        return object;
    }

    static class UnionTyperefInfo {
        public final TyperefDataSchema typerefSchema;
        public final UnionDataSchema unionSchema;
        public final DataMap dataMap;

        public UnionTyperefInfo(TyperefDataSchema typerefDataSchema, UnionDataSchema unionDataSchema, DataMap dataMap) {
            this.typerefSchema = typerefDataSchema;
            this.unionSchema = unionDataSchema;
            this.dataMap = dataMap;
        }
    }

    static class PegasusUnionFormat {
        public final DataSchema memberSchema;
        public final Object definition;

        public PegasusUnionFormat(DataSchema dataSchema, Object object) {
            this.memberSchema = dataSchema;
            this.definition = object;
        }

        public Object definition() throws IOException {
            return this.definition;
        }

        public DataMap definitionAsDataMap() throws IOException {
            if (this.definition instanceof DataMap) {
                return (DataMap)this.definition;
            }
            throw new IOException("Type definition format requires a DataMap, but found: " + this.definition);
        }

        public static PegasusUnionFormat fromDataMap(DataMap dataMap, UnionDataSchema unionDataSchema) throws IOException {
            if (dataMap.size() != 1) {
                throw new IOException("Union DataMap must contain exactly one memberKey field, but found fields: " + dataMap.keySet());
            }
            String string = (String)dataMap.keySet().iterator().next();
            Object object = dataMap.get((Object)string);
            DataSchema dataSchema = unionDataSchema.getType(string);
            if (dataSchema != null) {
                return new PegasusUnionFormat(dataSchema, object);
            }
            throw new IOException("Union member '" + string + "' not found for schema " + unionDataSchema);
        }
    }

    static class TypedDefinitionUnionFormat {
        public final DataMap typedDefinitionData;
        public final PegasusUnionFormat pegasusUnionEquivalent;

        public TypedDefinitionUnionFormat(DataMap dataMap, PegasusUnionFormat pegasusUnionFormat) {
            this.typedDefinitionData = dataMap;
            this.pegasusUnionEquivalent = pegasusUnionFormat;
        }
    }
}

