/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.naptime.router2;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.IOException;
import java.io.Serializable;
import org.coursera.courier.codecs.InlineStringCodec$;
import org.coursera.naptime.courier.StringKeyCodec;
import org.coursera.naptime.courier.StringKeyCodec$;
import org.coursera.naptime.router2.CollectionResourceRouter$;
import play.api.mvc.EssentialAction;
import play.api.mvc.RequestHeader;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CourierQueryParsers$
implements StrictLogging {
    public static CourierQueryParsers$ MODULE$;
    private final ValidationOptions validationOptions;
    private final Logger logger;

    static {
        new CourierQueryParsers$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Either<EssentialAction, DataMap> parseStringToDataMap(String paramName, DataSchema schema, Class<?> resourceClass, String value) {
        Right right;
        block9: {
            try {
                BoxedUnit boxedUnit;
                DataMap dataMap;
                if (value.startsWith("(") && value.endsWith(")")) {
                    dataMap = InlineStringCodec$.MODULE$.instance().bytesToMap(value.getBytes("UTF-8"));
                } else {
                    StringKeyCodec codec = new StringKeyCodec(schema, StringKeyCodec$.MODULE$.$lessinit$greater$default$2());
                    dataMap = codec.bytesToMap(value.getBytes("UTF-8"));
                }
                DataMap parsed = dataMap;
                ValidationResult validated = ValidateDataAgainstSchema.validate((Object)parsed, (DataSchema)schema, (ValidationOptions)this.validationOptions);
                if (validated.isValid()) {
                    right = package$.MODULE$.Right().apply((Object)((DataMap)validated.getFixed()));
                    break block9;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Bad query parameter for parameter "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceClass.getName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "': ", ". Errors: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName, value, validated.getMessages()})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Left().apply((Object)CollectionResourceRouter$.MODULE$.errorRoute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Improperly formatted value for parameter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})), resourceClass));
            }
            catch (IOException ioException) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Bad query parameter for parameter "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceClass.getName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "': ", ". Errors: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName, value, ioException.getMessage()})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Left().apply((Object)CollectionResourceRouter$.MODULE$.errorRoute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Improperly formatted value for parameter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})), resourceClass));
            }
        }
        return right;
    }

    public Either<EssentialAction, DataMap> strictParse(String paramName, DataSchema schema, Class<?> resourceClass, RequestHeader rh) {
        Left left;
        Option queryStringResults = rh.queryString().get((Object)paramName);
        if (queryStringResults.isEmpty() || ((SeqLike)queryStringResults.get()).isEmpty()) {
            left = package$.MODULE$.Left().apply((Object)CollectionResourceRouter$.MODULE$.errorRoute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing required parameter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})), resourceClass));
        } else if (((SeqLike)((TraversableLike)queryStringResults.get()).tail()).isEmpty()) {
            String stringValue = (String)((IterableLike)queryStringResults.get()).head();
            left = this.parseStringToDataMap(paramName, schema, resourceClass, stringValue);
        } else {
            left = package$.MODULE$.Left().apply((Object)CollectionResourceRouter$.MODULE$.errorRoute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many query parameters for '", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})), resourceClass));
        }
        return left;
    }

    public Either<EssentialAction, Option<DataMap>> optParse(String paramName, DataSchema schema, Class<?> resourceClass, RequestHeader rh) {
        Right right;
        Option queryStringResults = rh.queryString().get((Object)paramName);
        if (queryStringResults.isEmpty() || ((SeqLike)queryStringResults.get()).isEmpty()) {
            right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
        } else if (((SeqLike)((TraversableLike)queryStringResults.get()).tail()).isEmpty()) {
            String stringValue = (String)((IterableLike)queryStringResults.get()).head();
            right = this.parseStringToDataMap(paramName, schema, resourceClass, stringValue).right().map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1));
        } else {
            right = package$.MODULE$.Left().apply((Object)CollectionResourceRouter$.MODULE$.errorRoute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many query parameters for '", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})), resourceClass));
        }
        return right;
    }

    private CourierQueryParsers$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.validationOptions = new ValidationOptions(RequiredMode.FIXUP_ABSENT_WITH_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE);
    }
}

