/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.naptime.ari.fetcher;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import javax.inject.Inject;
import org.coursera.naptime.NaptimeActionException;
import org.coursera.naptime.ResponsePagination;
import org.coursera.naptime.actions.RestAction;
import org.coursera.naptime.ari.FetcherApi;
import org.coursera.naptime.ari.FetcherError;
import org.coursera.naptime.ari.Request;
import org.coursera.naptime.ari.Response;
import org.coursera.naptime.router2.NaptimeRoutes;
import org.coursera.naptime.router2.ResourceRouter;
import org.coursera.naptime.router2.ResourceRouterBuilder;
import org.coursera.naptime.schema.Resource;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.mvc.EssentialAction;
import play.api.mvc.Headers;
import play.api.mvc.Headers$;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestTaggingHandler;
import play.api.mvc.request.RequestTarget;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0005\n\u0001QA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006a\u0001!\t!\r\u0005\u0007}\u0001\u0001\u000b\u0011B \t\r5\u0003\u0001\u0015!\u0003O\u0011\u0019)\u0007\u0001)A\u0005M\")\u0001\r\u0001C!U\"A\u00111\u0002\u0001!\n\u0013\tiA\u0001\u0007M_\u000e\fGNR3uG\",'O\u0003\u0002\u000b\u0017\u00059a-\u001a;dQ\u0016\u0014(B\u0001\u0007\u000e\u0003\r\t'/\u001b\u0006\u0003\u001d=\tqA\\1qi&lWM\u0003\u0002\u0011#\u0005A1m\\;sg\u0016\u0014\u0018MC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\u0011\u0001QcG\u0010\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\f\u0013\tq2B\u0001\u0006GKR\u001c\u0007.\u001a:Ba&\u0004\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0011*\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0019\n1aY8n\u0013\tA\u0013EA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u000e]\u0006\u0004H/[7f%>,H/Z:\u0011\u0005-rS\"\u0001\u0017\u000b\u00055j\u0011a\u0002:pkR,'OM\u0005\u0003_1\u0012QBT1qi&lWMU8vi\u0016\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002\u0013!)\u0011F\u0001a\u0001U!\u0012!A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\na!\u001b8kK\u000e$(\"A\u001e\u0002\u000b)\fg/\u0019=\n\u0005uB$AB%oU\u0016\u001cG/A\u0004tG\",W.Y:\u0011\u0007\u0001+u)D\u0001B\u0015\t\u00115)A\u0005j[6,H/\u00192mK*\u0011AiF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001$B\u0005\r\u0019V\r\u001e\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u00156\taa]2iK6\f\u0017B\u0001'J\u0005!\u0011Vm]8ve\u000e,\u0017AB7pI\u0016d7\u000f\u0005\u0003A\u001fFc\u0016B\u0001)B\u0005\ri\u0015\r\u001d\t\u0003%fs!aU,\u0011\u0005Q;R\"A+\u000b\u0005Y\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002Y/\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv\u0003\u0005\u0002^G6\taL\u0003\u0002K?*\u0011\u0001-Y\u0001\u0005I\u0006$\u0018M\u0003\u0002cK\u0005AA.\u001b8lK\u0012Lg.\u0003\u0002e=\nQA)\u0019;b'\u000eDW-\\1\u0002\u000fI|W\u000f^3sgB!\u0001iT)h!\tY\u0003.\u0003\u0002jY\tq!+Z:pkJ\u001cWMU8vi\u0016\u0014H\u0003B6|\u0003\u0003!\"\u0001\u001c<\u0011\u00075\u0004(/D\u0001o\u0015\tyw#\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001d8\u0003\r\u0019+H/\u001e:f!\t\u0019H/D\u0001\u0001\u0013\t)XDA\bGKR\u001c\u0007.\u001a:SKN\u0004xN\\:f\u0011\u00159h\u0001q\u0001y\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002ns&\u0011!P\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ\u0001 \u0004A\u0002u\fqA]3rk\u0016\u001cH\u000f\u0005\u0002\u001d}&\u0011qp\u0003\u0002\b%\u0016\fX/Z:u\u0011\u001d\t\u0019A\u0002a\u0001\u0003\u000b\t1\"[:EK\n,x-T8eKB\u0019a#a\u0002\n\u0007\u0005%qCA\u0004C_>dW-\u00198\u0002\u0019M$(/\u001b8hS\u001aL\u0018I]4\u0015\u0007E\u000by\u0001C\u0004\u0002\u0012\u001d\u0001\r!a\u0005\u0002\u000bY\fG.^3\u0011\t\u0005U\u0011qE\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!!n]8o\u0015\u0011\ti\"a\b\u0002\t1L'm\u001d\u0006\u0005\u0003C\t\u0019#A\u0002ba&T!!!\n\u0002\tAd\u0017-_\u0005\u0005\u0003S\t9BA\u0004KgZ\u000bG.^3")
public class LocalFetcher
implements FetcherApi,
StrictLogging {
    private final NaptimeRoutes naptimeRoutes;
    private final Set<Resource> schemas;
    private final Map<String, DataSchema> models;
    private final Map<String, ResourceRouter> routers;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Future<Either<FetcherError, Response>> data(Request request, boolean isDebugMode, ExecutionContext executionContext) {
        Option resourceSchemaOpt = this.schemas.find((Function1 & Serializable & scala.Serializable)resourceSchema -> BoxesRunTime.boxToBoolean((boolean)LocalFetcher.$anonfun$data$1(request, resourceSchema)));
        Map queryString = request.arguments().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)arg -> new .colon.colon((Object)this.stringifyArg((JsValue)arg), (List)Nil$.MODULE$));
        String url = new StringBuilder(6).append("/api/").append(request.resource().identifier()).append("?").append(((TraversableOnce)queryString.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List value = (List)tuple2._2();
            String string = new StringBuilder(1).append(key).append("=").append(value.mkString(",")).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("&")).toString();
        return (Future)resourceSchemaOpt.flatMap((Function1 & Serializable & scala.Serializable)resourceSchema -> $this.routers.get((Object)resourceSchema.className()).map((Function1 & Serializable & scala.Serializable)router -> {
            String path = new StringBuilder(1).append("/").append(request.resource().identifier()).toString();
            RequestTarget fakePlayRequestTarget = request.requestHeader().target().withUriString(request.resource().identifier()).withQueryString(queryString);
            Headers fakePlayRequestHeaders = Headers$.MODULE$.apply(request.requestHeader().headers().headers()).remove((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Type", "Content-Length"}));
            play.api.mvc.Request fakePlayRequest = request.requestHeader().withMethod("GET").withTarget(fakePlayRequestTarget).withHeaders(fakePlayRequestHeaders).withBody((Object)BoxedUnit.UNIT);
            return new Tuple5(router, (Object)path, (Object)fakePlayRequestTarget, (Object)fakePlayRequestHeaders, (Object)fakePlayRequest);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple5 tuple5 = x$4;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            ResourceRouter router = (ResourceRouter)tuple5._1();
            String path = (String)tuple5._2();
            play.api.mvc.Request fakePlayRequest = (play.api.mvc.Request)tuple5._5();
            Option option = router.routeRequest(path, (RequestHeader)fakePlayRequest).map((Function1 & Serializable & scala.Serializable)handler -> {
                Future future;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Making local request to {} / {}", new Object[]{request.resource().identifier(), fakePlayRequest.queryString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                RequestHeader taggedRequest = ((RequestTaggingHandler)handler).tagRequest((RequestHeader)fakePlayRequest);
                EssentialAction essentialAction = handler;
                if (essentialAction instanceof RestAction) {
                    RestAction restAction = (RestAction)essentialAction;
                    future = restAction.localRun((RequestHeader)fakePlayRequest, request.resource()).map((Function1 & Serializable & scala.Serializable)response -> {
                        Some x$1 = new Some((Object)url);
                        List<DataMap> x$2 = response.copy$default$1();
                        ResponsePagination x$3 = response.copy$default$2();
                        return package$.MODULE$.Right().apply((Object)response.copy(x$2, x$3, (Option<String>)x$1));
                    }, executionContext).recoverWith((PartialFunction)new scala.Serializable(null, url){
                        public static final long serialVersionUID = 0L;
                        private final String url$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof NaptimeActionException) {
                                NaptimeActionException naptimeActionException = (NaptimeActionException)A1;
                                object = Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(naptimeActionException.httpCode(), naptimeActionException.toString(), (Option<String>)new Some((Object)this.url$1))));
                            } else {
                                if (A1 != null) {
                                    A1 A12 = A1;
                                    throw A12;
                                }
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NaptimeActionException ? true : throwable != null;
                            return bl;
                        }
                        {
                            this.url$1 = url$1;
                        }
                    }, executionContext);
                } else {
                    BoxedUnit boxedUnit2;
                    String msg = "Handler was not a RestAction, or Get attempted";
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(msg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    future = Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(404, msg, (Option<String>)new Some((Object)url))));
                }
                return future;
            });
            return option;
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String msg = new StringBuilder(18).append("Unknown resource: ").append(request.resource()).toString();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(msg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(404, msg, (Option<String>)new Some((Object)url))));
        });
    }

    private String stringifyArg(JsValue value2) {
        String string;
        JsValue jsValue = value2;
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            IndexedSeq arrayElements = jsArray.value();
            string = ((TraversableOnce)arrayElements.map((Function1 & Serializable & scala.Serializable)value -> this.stringifyArg((JsValue)value), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        } else if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            string = (String)jsString.as((Reads)Reads$.MODULE$.StringReads());
        } else if (jsValue instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            string = jsNumber.toString();
        } else if (jsValue instanceof JsBoolean) {
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            string = jsBoolean.toString();
        } else if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            string = Json$.MODULE$.stringify((JsValue)jsObject);
        } else if (JsNull$.MODULE$.equals(jsValue)) {
            string = "";
        } else {
            throw new MatchError((Object)jsValue);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$data$1(Request request$1, Resource resourceSchema) {
        String string = resourceSchema.name();
        String string2 = request$1.resource().topLevelName();
        return !(string != null ? !string.equals(string2) : string2 != null) && resourceSchema.version().contains((Object)BoxesRunTime.boxToInteger((int)request$1.resource().version()));
    }

    @Inject
    public LocalFetcher(NaptimeRoutes naptimeRoutes) {
        this.naptimeRoutes = naptimeRoutes;
        StrictLogging.$init$((StrictLogging)this);
        this.schemas = (Set)naptimeRoutes.routerBuilders().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.schema(), Set$.MODULE$.canBuildFrom());
        this.models = ((TraversableOnce)((SetLike)naptimeRoutes.routerBuilders().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.types(), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tuple(), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.routers = (Map)naptimeRoutes.buildersToRouters().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourceRouterBuilder builder = (ResourceRouterBuilder)tuple2._1();
            ResourceRouter router = (ResourceRouter)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.naptimeRoutes.className(builder)), (Object)router);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }
}

