/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.naptime;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NullDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.StringDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.coursera.naptime.ResourceFields;
import org.coursera.naptime.Types$Relations$;
import org.coursera.naptime.schema.RelationType;
import org.coursera.naptime.schema.RelationType$FINDER$;
import org.coursera.naptime.schema.RelationType$GET$;
import org.coursera.naptime.schema.RelationType$MULTI_GET$;
import org.coursera.naptime.schema.RelationType$SINGLE_ELEMENT_FINDER$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Types$
implements StrictLogging {
    public static Types$ MODULE$;
    private final Logger logger;

    static {
        new Types$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RecordDataSchema computeAsymType(String typeName, DataSchema keyType, RecordDataSchema valueType) {
        RecordDataSchema recordDataSchema;
        if (keyType.hasError() || valueType.hasError()) {
            throw new RuntimeException(new StringBuilder(27).append("Input schemas have error: ").append(keyType).append(" ").append(valueType).toString());
        }
        DataSchema dataSchema = keyType;
        if (dataSchema instanceof PrimitiveDataSchema) {
            PrimitiveDataSchema primitiveDataSchema = (PrimitiveDataSchema)dataSchema;
            recordDataSchema = this.computeAsymTypeWithPrimitiveKey(typeName, primitiveDataSchema, valueType);
        } else if (dataSchema instanceof RecordDataSchema) {
            RecordDataSchema recordDataSchema2 = (RecordDataSchema)dataSchema;
            recordDataSchema = this.computeAsymTypeWithRecordKey(typeName, recordDataSchema2, valueType);
        } else {
            if (dataSchema instanceof TyperefDataSchema) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (dataSchema != null) {
                DataSchema dataSchema2 = dataSchema;
                throw new RuntimeException(new StringBuilder(45).append("Cannot compute asymmetric type for key type: ").append(dataSchema2).toString());
            }
            throw new MatchError((Object)dataSchema);
        }
        return recordDataSchema;
    }

    public RecordDataSchema computeAsymType(String typeName, DataSchema keyType, RecordDataSchema valueType, ResourceFields<?> fields) {
        RecordDataSchema recordDataSchema;
        if (keyType.hasError() || valueType.hasError()) {
            throw new RuntimeException(new StringBuilder(27).append("Input schemas have error: ").append(keyType).append(" ").append(valueType).toString());
        }
        DataSchema dataSchema = keyType;
        if (dataSchema instanceof PrimitiveDataSchema) {
            PrimitiveDataSchema primitiveDataSchema = (PrimitiveDataSchema)dataSchema;
            recordDataSchema = this.computeAsymTypeWithPrimitiveKey(typeName, primitiveDataSchema, valueType);
        } else if (dataSchema instanceof RecordDataSchema) {
            RecordDataSchema recordDataSchema2 = (RecordDataSchema)dataSchema;
            recordDataSchema = this.computeAsymTypeWithRecordKey(typeName, recordDataSchema2, valueType);
        } else {
            if (dataSchema instanceof TyperefDataSchema) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (dataSchema != null) {
                DataSchema dataSchema2 = dataSchema;
                throw new RuntimeException(new StringBuilder(45).append("Cannot compute asymmetric type for key type: ").append(dataSchema2).toString());
            }
            throw new MatchError((Object)dataSchema);
        }
        RecordDataSchema mergedSchema = recordDataSchema;
        Set relationNameSet = (Set)fields.relations().keySet().$plus$plus((GenTraversableOnce)fields.graphQLRelations().keySet());
        relationNameSet.foreach((Function1 & Serializable & scala.Serializable)name -> {
            BoxedUnit boxedUnit;
            Option relationOption = fields.relations().get(name);
            Option graphQLRelationOption = fields.graphQLRelations().get(name);
            if (mergedSchema.contains(name)) {
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn(new StringBuilder(118).append("Fields for resource ").append(typeName).append(" tries to add Include/GraphQL relation on field ").append("'").append((String)name).append("', but that field is already defined on the model").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                RecordDataSchema.Field field;
                String[] nameSegments = name.split("/");
                StringBuilder errorMessageBuilder = new StringBuilder();
                Option graphQLRelationTypeOption = graphQLRelationOption.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toAnnotation().relationType());
                Option option = graphQLRelationTypeOption;
                if (None$.MODULE$.equals(option)) {
                    RecordDataSchema.Field newField = new RecordDataSchema.Field((DataSchema)new NullDataSchema());
                    newField.setOptional(true);
                    field = newField;
                } else {
                    Some some;
                    RelationType relationType;
                    Some some2;
                    RelationType relationType2;
                    boolean bl = option instanceof Some && ((Object)((Object)RelationType$FINDER$.MODULE$)).equals((Object)(relationType2 = (RelationType)((Object)((Object)(some2 = (Some)option).value())))) ? true : option instanceof Some && ((Object)((Object)RelationType$MULTI_GET$.MODULE$)).equals((Object)(relationType = (RelationType)((Object)((Object)(some = (Some)option).value()))));
                    if (bl) {
                        RecordDataSchema.Field newField = new RecordDataSchema.Field((DataSchema)new ArrayDataSchema((DataSchema)new StringDataSchema()));
                        newField.setOptional(false);
                        field = newField;
                    } else {
                        Some some3;
                        RelationType relationType3;
                        Some some4;
                        RelationType relationType4;
                        boolean bl2 = option instanceof Some && ((Object)((Object)RelationType$SINGLE_ELEMENT_FINDER$.MODULE$)).equals((Object)(relationType4 = (RelationType)((Object)((Object)(some4 = (Some)option).value())))) ? true : option instanceof Some && ((Object)((Object)RelationType$GET$.MODULE$)).equals((Object)(relationType3 = (RelationType)((Object)((Object)(some3 = (Some)option).value()))));
                        if (bl2) {
                            RecordDataSchema.Field newField = new RecordDataSchema.Field((DataSchema)new StringDataSchema());
                            newField.setOptional(true);
                            field = newField;
                        } else {
                            if (option instanceof Some) {
                                Some some5 = (Some)option;
                                RelationType unknown = (RelationType)((Object)((Object)some5.value()));
                                throw new RuntimeException(new StringBuilder(23).append("Unknown relation type: ").append(unknown.toString()).toString());
                            }
                            throw new MatchError((Object)option);
                        }
                    }
                }
                RecordDataSchema.Field newField = field;
                Option graphQLPropertyOption = graphQLRelationOption.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Types$Relations$.MODULE$.RELATION_PROPERTY_NAME()), (Object)x$2.toAnnotation().data()));
                Option includePropertyOption = relationOption.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Types$Relations$.MODULE$.INCLUDED_PROPERTY_NAME()), (Object)x$3.toAnnotation().data()));
                newField.setProperties((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)new .colon.colon((Object)graphQLPropertyOption, (List)new .colon.colon((Object)includePropertyOption, (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms())).asJava());
                graphQLRelationOption.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.description()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    newField.setDoc(x$1);
                    return BoxedUnit.UNIT;
                });
                newField.setName((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameSegments)).last(), errorMessageBuilder);
                boxedUnit = MODULE$.insertFieldAtLocation((DataSchema)mergedSchema, (List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameSegments)).dropRight(1))).toList(), newField);
            }
            return boxedUnit;
        });
        return mergedSchema;
    }

    private RecordDataSchema computeAsymTypeWithRecordKey(String typeName, RecordDataSchema keyType, RecordDataSchema valueType) {
        BoxedUnit boxedUnit;
        List list;
        StringBuilder errorMessageBuilder = new StringBuilder();
        RecordDataSchema recordDataSchema = new RecordDataSchema(new Name(typeName), RecordDataSchema.RecordType.RECORD);
        List combinedFields = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(keyType.getFields()).asScala()).toList().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(valueType.getFields()).asScala(), List$.MODULE$.canBuildFrom());
        if (combinedFields.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Types$.$anonfun$computeAsymTypeWithRecordKey$1(x$5)))) {
            list = combinedFields;
        } else {
            RecordDataSchema.Field idField = new RecordDataSchema.Field((DataSchema)new StringDataSchema());
            idField.setOptional(false);
            idField.setName("id", errorMessageBuilder);
            idField.setRecord(recordDataSchema);
            RecordDataSchema.Field field = idField;
            list = combinedFields.$colon$colon((Object)field);
        }
        List fields = list;
        recordDataSchema.setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields).asJava(), errorMessageBuilder);
        if (errorMessageBuilder.length() > 0) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error while computing asymmetric type {}: {}", (Object[])new CharSequence[]{typeName, errorMessageBuilder});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return recordDataSchema;
    }

    private RecordDataSchema computeAsymTypeWithPrimitiveKey(String typeName, PrimitiveDataSchema keyType, RecordDataSchema valueType) {
        BoxedUnit boxedUnit;
        StringBuilder errorMessageBuilder = new StringBuilder();
        RecordDataSchema recordDataSchema = new RecordDataSchema(new Name(typeName), RecordDataSchema.RecordType.RECORD);
        RecordDataSchema.Field idField = new RecordDataSchema.Field((DataSchema)keyType);
        idField.setOptional(false);
        idField.setName("id", errorMessageBuilder);
        idField.setRecord(recordDataSchema);
        RecordDataSchema.Field field = idField;
        List fields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(valueType.getFields()).asScala()).toList().$colon$colon((Object)field);
        recordDataSchema.setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields).asJava(), errorMessageBuilder);
        if (errorMessageBuilder.length() > 0) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error while computing asymmetric type {}: {}", (Object[])new CharSequence[]{typeName, errorMessageBuilder});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return recordDataSchema;
    }

    private DataSchema insertFieldAtLocation(DataSchema schema, List<String> location, RecordDataSchema.Field field) {
        DataSchema dataSchema;
        DataSchema dataSchema2;
        while (true) {
            if ((dataSchema2 = schema.getDereferencedDataSchema()) instanceof MapDataSchema) {
                MapDataSchema mapDataSchema = (MapDataSchema)dataSchema2;
                schema = mapDataSchema.getValues();
                continue;
            }
            if (!(dataSchema2 instanceof ArrayDataSchema)) break;
            ArrayDataSchema arrayDataSchema = (ArrayDataSchema)dataSchema2;
            schema = arrayDataSchema.getItems();
        }
        if (dataSchema2 instanceof RecordDataSchema) {
            DataSchema dataSchema3;
            RecordDataSchema recordDataSchema = (RecordDataSchema)dataSchema2;
            if (location.isEmpty()) {
                BoxedUnit boxedUnit;
                field.setRecord(recordDataSchema);
                java.util.List existingFields = recordDataSchema.getFields();
                java.util.List newFields = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(existingFields).asScala()).$plus$plus((GenTraversableOnce)new .colon.colon((Object)field, (List)Nil$.MODULE$))).asJava();
                StringBuilder errorMessageBuilder = new StringBuilder();
                recordDataSchema.setFields(newFields, errorMessageBuilder);
                String error = errorMessageBuilder.toString();
                if (new StringOps(Predef$.MODULE$.augmentString(error)).nonEmpty()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Error while inserting field", new Object[]{error});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                dataSchema3 = recordDataSchema;
            } else {
                Option fieldOption = Option$.MODULE$.apply((Object)recordDataSchema.getField((String)location.head()));
                dataSchema3 = (DataSchema)fieldOption.map((Function1 & Serializable & scala.Serializable)recordField -> MODULE$.insertFieldAtLocation(recordField.getType(), (List<String>)((List)location.tail()), field)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("Could not find field {} on record {}", new Object[]{location.headOption(), schema});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return schema;
                });
            }
            dataSchema = dataSchema3;
        } else if (dataSchema2 instanceof UnionDataSchema) {
            UnionDataSchema unionDataSchema = (UnionDataSchema)dataSchema2;
            dataSchema = (DataSchema)location.headOption().flatMap((Function1 & Serializable & scala.Serializable)loc -> Option$.MODULE$.apply((Object)unionDataSchema.getType(loc))).map((Function1 & Serializable & scala.Serializable)unionSchema -> MODULE$.insertFieldAtLocation((DataSchema)unionSchema, (List<String>)((List)location.tail()), field)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Could not find type {} on union {}", new Object[]{location.headOption(), schema});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return schema;
            });
        } else {
            dataSchema = schema;
        }
        return dataSchema;
    }

    public static final /* synthetic */ boolean $anonfun$computeAsymTypeWithRecordKey$1(RecordDataSchema.Field x$5) {
        String string = x$5.getName();
        String string2 = "id";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Types$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

