/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.naptime.ari.fetcher;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import javax.inject.Inject;
import org.coursera.naptime.NaptimeActionException;
import org.coursera.naptime.ResponsePagination;
import org.coursera.naptime.actions.RestAction;
import org.coursera.naptime.ari.FetcherApi;
import org.coursera.naptime.ari.FetcherError;
import org.coursera.naptime.ari.Request;
import org.coursera.naptime.ari.Response;
import org.coursera.naptime.router2.NaptimeRoutes;
import org.coursera.naptime.router2.ResourceRouter;
import org.coursera.naptime.router2.ResourceRouterBuilder;
import org.coursera.naptime.schema.Resource;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.mvc.EssentialAction;
import play.api.mvc.Headers;
import play.api.mvc.Headers$;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestTaggingHandler;
import play.api.mvc.request.RequestTarget;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011A\u0002T8dC24U\r^2iKJT!a\u0001\u0003\u0002\u000f\u0019,Go\u00195fe*\u0011QAB\u0001\u0004CJL'BA\u0004\t\u0003\u001dq\u0017\r\u001d;j[\u0016T!!\u0003\u0006\u0002\u0011\r|WO]:fe\u0006T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011!BR3uG\",'/\u00119j!\tI\u0002%D\u0001\u001b\u0015\tYB$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001e=\u0005AA/\u001f9fg\u00064WMC\u0001 \u0003\r\u0019w.\\\u0005\u0003Ci\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u001b9\f\u0007\u000f^5nKJ{W\u000f^3t!\t)\u0003&D\u0001'\u0015\t9c!A\u0004s_V$XM\u001d\u001a\n\u0005%2#!\u0004(baRLW.\u001a*pkR,7\u000fC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0003[=\u0002\"A\f\u0001\u000e\u0003\tAQa\t\u0016A\u0002\u0011B#AK\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014AB5oU\u0016\u001cGOC\u00017\u0003\u0015Q\u0017M^1y\u0013\tA4G\u0001\u0004J]*,7\r\u001e\u0005\u0007u\u0001\u0001\u000b\u0011B\u001e\u0002\u000fM\u001c\u0007.Z7bgB\u0019A(Q\"\u000e\u0003uR!AP \u0002\u0013%lW.\u001e;bE2,'B\u0001!\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0005v\u00121aU3u!\t!u)D\u0001F\u0015\t1e!\u0001\u0004tG\",W.Y\u0005\u0003\u0011\u0016\u0013\u0001BU3t_V\u00148-\u001a\u0005\u0007\u0015\u0002\u0001\u000b\u0011B&\u0002\r5|G-\u001a7t!\u0011aDJT-\n\u00055k$aA'baB\u0011qJ\u0016\b\u0003!R\u0003\"!\u0015\t\u000e\u0003IS!a\u0015\u0007\u0002\rq\u0012xn\u001c;?\u0013\t)\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u0011!\tQ\u0006-D\u0001\\\u0015\t1EL\u0003\u0002^=\u0006!A-\u0019;b\u0015\tyf$\u0001\u0005mS:\\W\rZ5o\u0013\t\t7L\u0001\u0006ECR\f7k\u00195f[\u0006Daa\u0019\u0001!\u0002\u0013!\u0017a\u0002:pkR,'o\u001d\t\u0005y1sU\r\u0005\u0002&M&\u0011qM\n\u0002\u000f%\u0016\u001cx.\u001e:dKJ{W\u000f^3s\u0011\u0015i\u0006\u0001\"\u0011j)\rQ'p \u000b\u0003WV\u00042\u0001\\8r\u001b\u0005i'B\u00018\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003a6\u0014aAR;ukJ,\u0007C\u0001:t\u001b\u0005\u0001\u0011B\u0001;\u0017\u0005=1U\r^2iKJ\u0014Vm\u001d9p]N,\u0007\"\u0002<i\u0001\b9\u0018\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\ta\u00070\u0003\u0002z[\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006w\"\u0004\r\u0001`\u0001\be\u0016\fX/Z:u!\t)R0\u0003\u0002\u007f\t\t9!+Z9vKN$\bbBA\u0001Q\u0002\u0007\u00111A\u0001\fSN$UMY;h\u001b>$W\rE\u0002\u0010\u0003\u000bI1!a\u0002\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0003\u0001A\u0013%\u0011QB\u0001\rgR\u0014\u0018N\\4jMf\f%o\u001a\u000b\u0004\u001d\u0006=\u0001\u0002CA\t\u0003\u0013\u0001\r!a\u0005\u0002\u000bY\fG.^3\u0011\t\u0005U\u0011qE\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!!n]8o\u0015\u0011\ti\"a\b\u0002\t1L'm\u001d\u0006\u0005\u0003C\t\u0019#A\u0002ba&T!!!\n\u0002\tAd\u0017-_\u0005\u0005\u0003S\t9BA\u0004KgZ\u000bG.^3")
public class LocalFetcher
implements FetcherApi,
StrictLogging {
    private final NaptimeRoutes naptimeRoutes;
    private final Set<Resource> schemas;
    private final Map<String, DataSchema> models;
    private final Map<String, ResourceRouter> routers;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Future<Either<FetcherError, Response>> data(Request request, boolean isDebugMode, ExecutionContext executionContext) {
        Option resourceSchemaOpt = this.schemas.find((Function1 & Serializable & scala.Serializable)resourceSchema -> BoxesRunTime.boxToBoolean((boolean)LocalFetcher.$anonfun$data$1(request, resourceSchema)));
        Map queryString = request.arguments().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)arg -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.stringifyArg((JsValue)arg)})));
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/api/", "?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.resource().identifier()})) + ((TraversableOnce)queryString.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List value = (List)tuple2._2();
            String string = key + "=" + value.mkString(",");
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("&");
        return (Future)resourceSchemaOpt.flatMap((Function1 & Serializable & scala.Serializable)resourceSchema -> $this.routers.get((Object)resourceSchema.className()).map((Function1 & Serializable & scala.Serializable)router -> {
            String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.resource().identifier()}));
            RequestTarget fakePlayRequestTarget = request.requestHeader().target().withUriString(request.resource().identifier()).withQueryString(queryString);
            Headers fakePlayRequestHeaders = Headers$.MODULE$.apply(request.requestHeader().headers().headers()).remove((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Type", "Content-Length"}));
            play.api.mvc.Request fakePlayRequest = request.requestHeader().withMethod("GET").withTarget(fakePlayRequestTarget).withHeaders(fakePlayRequestHeaders).withBody((Object)BoxedUnit.UNIT);
            return new Tuple5(router, (Object)path, (Object)fakePlayRequestTarget, (Object)fakePlayRequestHeaders, (Object)fakePlayRequest);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple5 tuple5 = x$4;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            ResourceRouter router = (ResourceRouter)tuple5._1();
            String path = (String)tuple5._2();
            play.api.mvc.Request fakePlayRequest = (play.api.mvc.Request)tuple5._5();
            Option option = router.routeRequest(path, (RequestHeader)fakePlayRequest).map((Function1 & Serializable & scala.Serializable)handler -> {
                Future future;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Making local request to {} / {}", new Object[]{request.resource().identifier(), fakePlayRequest.queryString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                RequestHeader taggedRequest = ((RequestTaggingHandler)handler).tagRequest((RequestHeader)fakePlayRequest);
                EssentialAction essentialAction = handler;
                if (essentialAction instanceof RestAction) {
                    RestAction restAction = (RestAction)essentialAction;
                    future = restAction.localRun((RequestHeader)fakePlayRequest, request.resource()).map((Function1 & Serializable & scala.Serializable)response -> {
                        Some x$5 = new Some((Object)url);
                        List<DataMap> x$6 = response.copy$default$1();
                        ResponsePagination x$7 = response.copy$default$2();
                        return package$.MODULE$.Right().apply((Object)response.copy(x$6, x$7, (Option<String>)x$5));
                    }, executionContext).recoverWith((PartialFunction)new scala.Serializable(null, url){
                        public static final long serialVersionUID = 0L;
                        private final String url$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof NaptimeActionException) {
                                NaptimeActionException naptimeActionException = (NaptimeActionException)A1;
                                object = Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(naptimeActionException.httpCode(), naptimeActionException.toString(), (Option<String>)new Some((Object)this.url$1))));
                            } else {
                                if (A1 != null) {
                                    A1 A12 = A1;
                                    throw A12;
                                }
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NaptimeActionException ? true : throwable != null;
                            return bl;
                        }
                        {
                            this.url$1 = url$1;
                        }
                    }, executionContext);
                } else {
                    BoxedUnit boxedUnit2;
                    String msg = "Handler was not a RestAction, or Get attempted";
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(msg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    future = Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(404, msg, (Option<String>)new Some((Object)url))));
                }
                return future;
            });
            return option;
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown resource: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.resource()}));
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(msg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new FetcherError(404, msg, (Option<String>)new Some((Object)url))));
        });
    }

    private String stringifyArg(JsValue value2) {
        String string;
        JsValue jsValue = value2;
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            IndexedSeq arrayElements = jsArray.value();
            string = ((TraversableOnce)arrayElements.map((Function1 & Serializable & scala.Serializable)value -> this.stringifyArg((JsValue)value), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        } else if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            string = (String)jsString.as((Reads)Reads$.MODULE$.StringReads());
        } else if (jsValue instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            string = jsNumber.toString();
        } else if (jsValue instanceof JsBoolean) {
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            string = jsBoolean.toString();
        } else if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            string = Json$.MODULE$.stringify((JsValue)jsObject);
        } else if (JsNull$.MODULE$.equals(jsValue)) {
            string = "";
        } else {
            throw new MatchError((Object)jsValue);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$data$1(Request request$1, Resource resourceSchema) {
        String string = resourceSchema.name();
        String string2 = request$1.resource().topLevelName();
        return !(string != null ? !string.equals(string2) : string2 != null) && resourceSchema.version().contains((Object)BoxesRunTime.boxToInteger((int)request$1.resource().version()));
    }

    @Inject
    public LocalFetcher(NaptimeRoutes naptimeRoutes) {
        this.naptimeRoutes = naptimeRoutes;
        StrictLogging.$init$((StrictLogging)this);
        this.schemas = (Set)naptimeRoutes.routerBuilders().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.schema(), Set$.MODULE$.canBuildFrom());
        this.models = ((TraversableOnce)((SetLike)naptimeRoutes.routerBuilders().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.types(), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tuple(), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.routers = (Map)naptimeRoutes.buildersToRouters().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourceRouterBuilder builder = (ResourceRouterBuilder)tuple2._1();
            ResourceRouter router = (ResourceRouter)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.naptimeRoutes.className(builder)), (Object)router);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }
}

