/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.management.web.controllers;

import javax.servlet.http.HttpServletRequest;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/contexts"})
public class ContextController {
    public static final String VIEW_MAIN = "contexts";
    private static final String IS_LOGGED_USER_SUPERADMIN = "isSuperAdmin";

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewMain(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView(VIEW_MAIN);
        mav.addObject(IS_LOGGED_USER_SUPERADMIN, (Object)this.isSuperAdmin(this.getLoggedInUser(request)));
        return mav;
    }

    private boolean isSuperAdmin(Profile loggedUser) {
        return loggedUser.getRoles().contains("SOCIAL_SUPERADMIN");
    }

    private Profile getLoggedInUser(HttpServletRequest request) {
        Authentication auth = SecurityUtils.getAuthentication((HttpServletRequest)request);
        if (auth != null) {
            return auth.getProfile();
        }
        return null;
    }
}

