/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.management.web.controllers;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class MainController {
    public static final String VIEW_MAIN = "main";
    public static final String MODEL_LOGGED_IN_USER = "loggedInUser";
    public static final String MODEL_SOCIAL_APP_URL = "socialAppUrl";
    private static final String IS_LOGGED_USER_SUPERADMIN = "isSuperAdmin";
    private String socialAppRootUrl;
    private String socialAppName;

    public void setSocialAppRootUrl(String socialAppRootUrl) {
        this.socialAppRootUrl = socialAppRootUrl;
    }

    @Required
    public void setSocialAppName(String socialAppName) {
        this.socialAppName = socialAppName;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewMain(HttpServletRequest request) {
        StringBuilder socialAppUrl = StringUtils.isNotEmpty((CharSequence)this.socialAppRootUrl) ? new StringBuilder(this.socialAppRootUrl).append("/").append(this.socialAppName) : HttpUtils.getBaseRequestUrl((HttpServletRequest)request, (boolean)false).append("/").append(this.socialAppName);
        ModelAndView mav = new ModelAndView(VIEW_MAIN);
        Profile loggedUser = this.getLoggedInUser(request);
        mav.addObject(MODEL_LOGGED_IN_USER, (Object)loggedUser);
        mav.addObject(IS_LOGGED_USER_SUPERADMIN, (Object)this.isSuperAdmin(loggedUser));
        mav.addObject(MODEL_SOCIAL_APP_URL, (Object)socialAppUrl.toString());
        return mav;
    }

    private boolean isSuperAdmin(Profile loggedUser) {
        return loggedUser.getRoles().contains("SOCIAL_SUPERADMIN");
    }

    private Profile getLoggedInUser(HttpServletRequest request) {
        Authentication auth = SecurityUtils.getAuthentication((HttpServletRequest)request);
        if (auth != null) {
            return auth.getProfile();
        }
        return null;
    }
}

