/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.management.web.controllers;

import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.SortOrder;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.social.management.exceptions.InvalidRequestParameterException;
import org.craftercms.social.management.exceptions.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/profile"})
public class ProfileController {
    public static final String PATH_VAR_ID = "id";
    public static final String BASE_URL_PROFILE = "/profile";
    public static final String URL_GET_PROFILE_COUNT = "/count";
    public static final String URL_FIND_PROFILES = "/find";
    public static final String URL_GET_PROFILE = "/{id}";
    public static final String PARAM_TENANT_NAME = "tenantName";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SORT_BY = "sortBy";
    public static final String PARAM_SORT_ORDER = "sortOrder";
    public static final String PARAM_START = "start";
    public static final String PARAM_COUNT = "count";
    public static final Pattern QUERY_PATTERN = Pattern.compile("\\w+");
    public static final String FINAL_QUERY_FORMAT = "{username: {$regex: '.*%s.*', $options: 'i'}}";
    private ProfileService profileService;

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    @ResponseBody
    public long getProfileCount(@RequestParam(value="tenantName", required=false) String tenantName, @RequestParam(value="query", required=false) String query, HttpServletRequest request) throws ProfileException {
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            tenantName = SecurityUtils.getProfile((HttpServletRequest)request).getTenant();
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            if (QUERY_PATTERN.matcher(query).matches()) {
                query = String.format(FINAL_QUERY_FORMAT, query);
                return this.profileService.getProfileCountByQuery(tenantName, query);
            }
            throw new InvalidRequestParameterException("Parameter 'query' must match regex " + QUERY_PATTERN.pattern());
        }
        return this.profileService.getProfileCount(tenantName);
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Profile> getProfileList(@RequestParam(value="tenantName", required=false) String tenantName, @RequestParam(value="query", required=false) String query, @RequestParam(value="sortBy", required=false) String sortBy, @RequestParam(value="sortOrder", required=false) SortOrder sortOrder, @RequestParam(value="start", required=false) Integer start, @RequestParam(value="count", required=false) Integer limit, HttpServletRequest request) throws ProfileException {
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            tenantName = SecurityUtils.getProfile((HttpServletRequest)request).getTenant();
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            if (QUERY_PATTERN.matcher(query).matches()) {
                query = String.format(FINAL_QUERY_FORMAT, query);
                return this.profileService.getProfilesByQuery(tenantName, query, sortBy, sortOrder, start, limit, new String[0]);
            }
            throw new InvalidRequestParameterException("Parameter 'query' must match regex " + QUERY_PATTERN.pattern());
        }
        return this.profileService.getProfileRange(tenantName, sortBy, sortOrder, start, limit, new String[0]);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Profile getProfile(@PathVariable(value="id") String id) throws ProfileException {
        Profile profile = this.profileService.getProfile(id, new String[0]);
        if (profile != null) {
            return profile;
        }
        throw new ResourceNotFoundException("No profile found for ID '" + id + "'");
    }
}

