/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.management.web.controllers;

import java.util.ArrayList;
import java.util.List;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tenant"})
public class TenantController {
    public static final String BASE_URL_TENANT = "/tenant";
    public static final String URL_GET_TENANT_NAMES = "/names";
    private TenantService tenantService;
    private List<String> allTenants;

    @Required
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @RequestMapping(value={"/names"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getTenantNames() throws ProfileException {
        List<String> tenantNames = new ArrayList<String>(1);
        Profile profile = SecurityUtils.getCurrentProfile();
        if (profile != null) {
            if (profile.hasRole("PROFILE_SUPERADMIN")) {
                tenantNames = this.getAllTenants();
            } else {
                tenantNames.add(profile.getTenant());
            }
        }
        return tenantNames;
    }

    public List<String> getAllTenants() throws ProfileException {
        List tenants = this.tenantService.getAllTenants();
        ArrayList<String> tenantNames = new ArrayList<String>(tenants.size());
        for (Tenant tenant : tenants) {
            tenantNames.add(tenant.getName());
        }
        return tenantNames;
    }
}

