/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.client.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.craftercms.social.client.filters.support.ProfileNotFound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileClient {
    public static final String BASE_URL_REST_API = "/api/1";
    public static final String BASE_URL_PROFILE = "/api/1/profile";
    public static final String BASE_URL_AUTHENTICATION = "/api/1/authentication";
    public static final String URL_AUTH_GET_TICKET = "ticket";
    public static final String URL_PROFILE_GET_BY_USERNAME = "/by_username";
    public static final String URL_PROFILE_CREATE = "/create";
    public static final String URL_AUTH_CREATE_TICKET = "/ticket/create";
    public static final String PARAM_TENANT_NAME = "tenantName";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_ACCESS_TOKEN_ID = "accessTokenId";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_ENABLED = "enabled";
    public static final String PARAM_ATTRIBUTES = "attributes";
    public static final String PARAM_ROLE = "role";
    public static final String PARAM_PROFILE_ID = "profileId";
    public static final String URL_PROFILE_UPDATE_ATTRIBUTES = "/attributes/update";
    public static final String PARAM_PASSWORD = "password";
    public static final String USER_USERNAME = "USER_USERNAME";
    public static final String USER_PROFILE_ID = "id";
    protected HttpClient client;
    protected String profileUri;
    protected String profileAccessToken;
    protected HttpHost host;
    protected String tenantName;
    protected String profileDeploymentName;
    protected String socialContextIdParam;
    protected ObjectMapper mapper;

    public void init() throws URISyntaxException {
        this.client = HttpClientBuilder.create().build();
        URI uri = new URI(this.profileUri);
        this.host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        this.mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProfile(String username) throws Exception {
        Map profile;
        block6: {
            ArrayList<BasicNameValuePair> getParams = new ArrayList<BasicNameValuePair>();
            getParams.add(new BasicNameValuePair(PARAM_TENANT_NAME, this.tenantName));
            getParams.add(new BasicNameValuePair(PARAM_USERNAME, username));
            getParams.add(new BasicNameValuePair(PARAM_ACCESS_TOKEN_ID, this.profileAccessToken));
            URI uri = new URIBuilder("/api/1/profile/by_username").addParameters(getParams).build();
            HttpGet httpGet = new HttpGet(this.profileDeploymentName + uri);
            this.setHeaders((HttpRequestBase)httpGet);
            HttpResponse response = this.client.execute(this.host, (HttpRequest)httpGet);
            profile = null;
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new Exception("Unable to connect get profile");
                }
                if (response.getStatusLine().getStatusCode() == 404 || response.getEntity().getContentLength() == 0L) {
                    throw new ProfileNotFound();
                }
                if (response.getEntity().getContentType().getValue().contains(ContentType.APPLICATION_JSON.getMimeType())) {
                    ByteArrayOutputStream responseOutput = new ByteArrayOutputStream();
                    response.getEntity().writeTo((OutputStream)responseOutput);
                    profile = (Map)this.mapper.readValue((InputStream)new ByteArrayInputStream(responseOutput.toByteArray()), HashMap.class);
                    break block6;
                }
                throw new Exception("Response content is not a JSON");
            }
            finally {
                response.getEntity().getContent().close();
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> createProfile(HttpServletRequest request, Map<String, Object> userInformation) throws Exception {
        Map<String, Object> newProfile;
        block9: {
            if (userInformation == null) {
                return null;
            }
            String profileUserName = (String)userInformation.get(USER_USERNAME);
            if (StringUtils.isBlank((CharSequence)profileUserName) || StringUtils.containsWhitespace((CharSequence)profileUserName)) {
                throw new IllegalArgumentException("Username can not be empty or null or have whitespaces");
            }
            ArrayList<BasicNameValuePair> createParams = new ArrayList<BasicNameValuePair>();
            HttpPost post = new HttpPost(this.profileDeploymentName + BASE_URL_PROFILE + URL_PROFILE_CREATE);
            createParams.add(new BasicNameValuePair(PARAM_TENANT_NAME, this.tenantName));
            createParams.add(new BasicNameValuePair(PARAM_USERNAME, profileUserName));
            createParams.add(new BasicNameValuePair(PARAM_PASSWORD, UUID.randomUUID().toString()));
            createParams.add(new BasicNameValuePair(PARAM_EMAIL, (String)userInformation.get(PARAM_EMAIL)));
            createParams.add(new BasicNameValuePair(PARAM_ENABLED, "true"));
            createParams.add(new BasicNameValuePair(PARAM_ROLE, (String)userInformation.get(PARAM_ROLE)));
            createParams.add(new BasicNameValuePair(PARAM_ACCESS_TOKEN_ID, this.profileAccessToken));
            createParams.add(new BasicNameValuePair(PARAM_ATTRIBUTES, this.writeAttributes((Map)userInformation.get(PARAM_ATTRIBUTES))));
            StringEntity entity = new StringEntity(URLEncodedUtils.format(createParams, (String)"UTF-8"), ContentType.APPLICATION_FORM_URLENCODED.withCharset("UTF-8"));
            post.setEntity((HttpEntity)entity);
            HttpResponse response = this.client.execute(this.host, (HttpRequest)post);
            post.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.withCharset("UTF-8").toString());
            newProfile = null;
            try {
                if (response.getStatusLine().getStatusCode() == 200) {
                    newProfile = (Map<String, Object>)this.mapper.readValue(response.getEntity().getContent(), HashMap.class);
                    break block9;
                }
                if (response.getStatusLine().getStatusCode() == 400) {
                    Map error = (Map)this.mapper.readValue(response.getEntity().getContent(), HashMap.class);
                    if (!error.isEmpty()) {
                        if (error.containsKey("errorCode") && error.get("errorCode").equals("PROFILE_EXISTS")) {
                            newProfile = this.getProfile(profileUserName);
                            break block9;
                        }
                        throw new Exception("Unable to create profile");
                    }
                    throw new Exception("Unable to create profile");
                }
                throw new Exception("Unable to create profile");
            }
            finally {
                response.getEntity().getContent().close();
            }
        }
        return newProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> auth(String profileId) throws Exception {
        Map ticket;
        ArrayList<BasicNameValuePair> createParams = new ArrayList<BasicNameValuePair>();
        createParams.add(new BasicNameValuePair(PARAM_ACCESS_TOKEN_ID, this.profileAccessToken));
        createParams.add(new BasicNameValuePair(PARAM_PROFILE_ID, profileId));
        HttpPost post = new HttpPost(this.profileDeploymentName + BASE_URL_AUTHENTICATION + URL_AUTH_CREATE_TICKET);
        StringEntity entity = new StringEntity(URLEncodedUtils.format(createParams, (String)"UTF-8"), ContentType.APPLICATION_FORM_URLENCODED.withCharset("UTF-8"));
        post.setEntity((HttpEntity)entity);
        HttpResponse response = this.client.execute(this.host, (HttpRequest)post);
        try {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception("Unable to auth profile");
            }
            ticket = (Map)this.mapper.readValue(response.getEntity().getContent(), HashMap.class);
        }
        finally {
            response.getEntity().getContent().close();
        }
        return ticket;
    }

    private String writeAttributes(Map<String, Object> attributes) throws JsonProcessingException {
        return this.mapper.writeValueAsString(attributes);
    }

    private void setHeaders(HttpRequestBase requestBase) {
        requestBase.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        requestBase.setHeader("Accept-Encoding", "UTF-8");
        requestBase.setHeader("Cache-Control", "no-cache");
        requestBase.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
    }

    public void setProfileUri(String profileUri) {
        this.profileUri = profileUri;
    }

    public void setProfileAccessToken(String profileAccessToken) {
        this.profileAccessToken = profileAccessToken;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setProfileDeploymentName(String profileDeploymentName) {
        this.profileDeploymentName = profileDeploymentName;
    }

    public void setSocialContextIdParam(String socialContextIdParam) {
        this.socialContextIdParam = socialContextIdParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTicketValid(String authCookieValue) throws URISyntaxException, IOException {
        ArrayList<BasicNameValuePair> getParams = new ArrayList<BasicNameValuePair>();
        getParams.add(new BasicNameValuePair(PARAM_ACCESS_TOKEN_ID, this.profileAccessToken));
        URI uri = new URIBuilder("/api/1/authentication/ticket/" + authCookieValue).addParameters(getParams).build();
        HttpGet httpGet = new HttpGet(this.profileDeploymentName + uri);
        this.setHeaders((HttpRequestBase)httpGet);
        HttpResponse response = this.client.execute(this.host, (HttpRequest)httpGet);
        HttpEntity entity = response.getEntity();
        boolean result = false;
        if (response.getStatusLine().getStatusCode() != 200) {
            result = false;
        } else {
            HashMap ticket;
            ByteArrayOutputStream outputStream = null;
            String stringContent = "";
            try {
                outputStream = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)outputStream);
                stringContent = new String(outputStream.toByteArray(), Charset.forName("UTF-8"));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                entity.getContent().close();
            }
            result = StringUtils.isNotBlank((CharSequence)stringContent) ? !(ticket = (HashMap)this.mapper.readValue(stringContent, HashMap.class)).isEmpty() : false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> updateAttributes(String profileId, Map<String, Object> attributesToUpdate) throws IOException {
        if (attributesToUpdate == null) {
            return null;
        }
        Map profile = null;
        URI uri = null;
        try {
            uri = new URIBuilder(this.profileDeploymentName + BASE_URL_PROFILE + "/" + profileId + URL_PROFILE_UPDATE_ATTRIBUTES).addParameter(PARAM_ACCESS_TOKEN_ID, this.profileAccessToken).build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ArrayList createParams = new ArrayList();
        HttpPost post = new HttpPost(uri);
        StringEntity entity = new StringEntity(this.mapper.writeValueAsString(attributesToUpdate), ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = this.client.execute(this.host, (HttpRequest)post);
        try {
            if (response.getStatusLine().getStatusCode() == 200) {
                profile = (Map)this.mapper.readValue(response.getEntity().getContent(), HashMap.class);
            }
        }
        finally {
            response.getEntity().getContent().close();
        }
        return profile;
    }
}

