/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.client.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ContentType;
import org.craftercms.social.client.filters.ProfileClient;
import org.craftercms.social.client.filters.support.ProfileNotFound;
import org.craftercms.social.client.filters.support.ProxyHttpServletRequest;
import org.mitre.dsmiley.httpproxy.ProxyServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocialProxyFilter
extends ProxyServlet
implements Filter {
    public static final String CRAFTER_PROFILE_AUTH = "Crafter-Profile-AUTH";
    private ServletContext servletContext;
    private FilterConfig filterConfig;
    protected String proxyFilterPrefix;
    protected ProfileClient client;
    protected String cookieTicketName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.filterConfig = filterConfig;
    }

    public abstract Map<String, Object> getUserProfile(HttpServletRequest var1, HttpServletResponse var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ProxyHttpServletRequest httpServletRequest = new ProxyHttpServletRequest((HttpServletRequest)request, this.getCookieNamePrefix());
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            this.checkIfUserIsAuth(httpServletRequest, httpServletResponse);
            this.service((ServletRequest)httpServletRequest, response);
            if (httpServletRequest.getAttribute(CRAFTER_PROFILE_AUTH) != null) {
                httpServletRequest.getInputStream().reset();
                Map<String, Object> useInformation = this.getUserProfile((HttpServletRequest)httpServletRequest, (HttpServletResponse)response);
                if (useInformation != null) {
                    this.doCrafterProfileAuth(useInformation, httpServletRequest, (HttpServletResponse)response);
                    this.service((ServletRequest)httpServletRequest, response);
                    httpServletRequest.setAttribute(CRAFTER_PROFILE_AUTH, null);
                } else {
                    httpServletResponse.sendError(401);
                }
            }
        }
        catch (Exception e) {
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.setStatus(500);
                httpServletResponse.setHeader("content-type", ContentType.APPLICATION_JSON.withCharset("utf-8").toString());
                response.getWriter().write("{\"Error\":\"Unable to create or retrieve user with given id\",\"ex\":\"" + e.toString() + "\"}");
            }
            e.printStackTrace();
        }
        finally {
            httpServletRequest.getInputStream().close();
        }
    }

    protected void checkIfUserIsAuth(ProxyHttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String authCookieValue = this.ticketCookieExist(httpServletRequest);
        if (StringUtils.isBlank((CharSequence)authCookieValue)) {
            Map<String, Object> profile = this.getUserProfile((HttpServletRequest)httpServletRequest, httpServletResponse);
            if (profile != null) {
                this.doCrafterProfileAuth(profile, httpServletRequest, httpServletResponse);
            }
        } else {
            this.validateAuthCookie(authCookieValue, httpServletRequest, httpServletResponse);
        }
    }

    protected void validateAuthCookie(String authCookieValue, ProxyHttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.client.isTicketValid(authCookieValue)) {
            Map<String, Object> profile = this.getUserProfile((HttpServletRequest)httpServletRequest, httpServletResponse);
            this.doCrafterProfileAuth(profile, httpServletRequest, httpServletResponse);
        }
    }

    protected String ticketCookieExist(ProxyHttpServletRequest httpServletRequest) {
        for (Cookie cookie : httpServletRequest.getCookies()) {
            if (!cookie.getName().equals(this.getCookieNamePrefix() + this.cookieTicketName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected Map<String, Object> doCrafterProfileAuth(Map<String, Object> userInformation, ProxyHttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> profile = null;
        try {
            profile = this.client.getProfile((String)userInformation.get("USER_USERNAME"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ProfileNotFound ex) {
            profile = this.client.createProfile((HttpServletRequest)request, userInformation);
        }
        if (profile == null) {
            response.reset();
            response.setStatus(500);
            response.setHeader("content-type", ContentType.APPLICATION_JSON.withCharset("utf-8").toString());
            response.getWriter().write("{\"Error\":\"Unable to create or retrieve user with given id\"}");
            response.getWriter().flush();
            throw new Exception("Unable to create or retrieve user");
        }
        this.checkProfileAndCurrentContext((Map)userInformation.get("attributes"), profile);
        Map<String, Object> ticket = this.client.auth((String)profile.get("id"));
        Cookie authTicket = new Cookie(this.getCookieNamePrefix() + "ticket", (String)ticket.get("id"));
        authTicket.setMaxAge(-1);
        authTicket.setPath("/");
        authTicket.setComment("Auth for social, created by SocialProxyFilter");
        response.addCookie(authTicket);
        request.addCookie(authTicket);
        return profile;
    }

    private void checkProfileAndCurrentContext(Map<String, Object> userParams, Map<String, Object> profile) throws IOException {
        Map currentAttributes = (Map)profile.get("attributes");
        List currentSocialContexts = (List)currentAttributes.get("socialContexts");
        Map givenSocialContext = (Map)((List)userParams.get("socialContexts")).get(0);
        boolean foundContext = false;
        for (Map currentSocialContext : currentSocialContexts) {
            if (!currentSocialContext.containsValue(givenSocialContext.get("id"))) continue;
            foundContext = true;
            break;
        }
        if (!foundContext) {
            currentSocialContexts.add(givenSocialContext);
            currentAttributes.put("socialContexts", currentSocialContexts);
            this.client.updateAttributes((String)profile.get("id"), currentAttributes);
        }
    }

    protected boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no " + "Location" + " header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        if (statusCode == 403 || statusCode == 401 || statusCode == 500 && this.isUserInContextError(proxyResponse.getEntity())) {
            servletRequest.setAttribute(CRAFTER_PROFILE_AUTH, (Object)true);
            return true;
        }
        return false;
    }

    private boolean isUserInContextError(HttpEntity entity) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        return new String(out.toByteArray(), Charset.forName("UTF-8")).contains("Current profile is not assign to the given currentContext");
    }

    public void setSocialUrl(String socialUrl) {
        this.targetUri = socialUrl;
    }

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri(servletRequest));
        if (servletRequest.getRequestURI() != null) {
            uri.append(ProxyServlet.encodeUriQuery((CharSequence)servletRequest.getRequestURI().replace(this.proxyFilterPrefix, "")));
        }
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(ProxyServlet.encodeUriQuery((CharSequence)queryString));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(ProxyServlet.encodeUriQuery((CharSequence)fragment));
        }
        return uri.toString();
    }

    protected void initTarget() {
        if (this.targetUri == null) {
            throw new IllegalArgumentException("targetUri is required.");
        }
        try {
            this.targetUriObj = new URI(this.targetUri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Trying to process targetUri init parameter: " + e, e);
        }
        this.targetHost = URIUtils.extractHost((URI)this.targetUriObj);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected String getCookieNamePrefix() {
        return "!Proxy!" + this.filterConfig.getFilterName();
    }

    protected String getConfigParam(String key) {
        return null;
    }

    public void setProxyFilterPrefix(String proxyFilterPrefix) {
        this.proxyFilterPrefix = proxyFilterPrefix;
    }

    public void setClient(ProfileClient client) {
        this.client = client;
    }

    public void setCookieTicketName(String cookieTicketName) {
        this.cookieTicketName = cookieTicketName;
    }
}

