/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.client.filters.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.social.client.filters.support.DelegateServletInputStream;

public class ProxyHttpServletRequest
extends HttpServletRequestWrapper {
    private final DelegateServletInputStream wrapServletInput;
    private List<Cookie> cookieList;
    private String cookieProxyFilter;
    private int contentLength;

    public ProxyHttpServletRequest(HttpServletRequest request, String cookieProxyFilter) throws IOException {
        super(request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)out);
        if (out.size() <= 0 && null != request.getHeader("content-type") && request.getHeader("content-type").toLowerCase().contains("application/x-www-form-urlencoded")) {
            StringBuilder strBuilder = new StringBuilder();
            Enumeration parameters = request.getParameterNames();
            while (parameters.hasMoreElements()) {
                String parameter = (String)parameters.nextElement();
                String value = request.getParameter(parameter);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                strBuilder.append(URLEncoder.encode(parameter, "UTF-8")).append("=").append(URLEncoder.encode(request.getParameter(parameter), "UTF-8"));
                if (!parameters.hasMoreElements()) continue;
                strBuilder.append("&");
            }
            strBuilder.trimToSize();
            this.wrapServletInput = new DelegateServletInputStream(IOUtils.toInputStream((String)strBuilder.toString()));
            this.contentLength = this.wrapServletInput.available();
        } else {
            this.contentLength = out.size();
            this.wrapServletInput = new DelegateServletInputStream(new ByteArrayInputStream(out.toByteArray()));
        }
        this.cookieList = request.getCookies() != null && request.getCookies().length > 0 ? new ArrayList<Cookie>(Arrays.asList(request.getCookies())) : new ArrayList<Cookie>();
        this.cookieProxyFilter = cookieProxyFilter;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.wrapServletInput;
    }

    public Enumeration getHeaderNames() {
        Vector vector = new Vector();
        Enumeration org = super.getHeaderNames();
        while (org.hasMoreElements()) {
            vector.add(org.nextElement());
        }
        if (!this.cookieList.isEmpty()) {
            vector.add("Cookie");
        }
        return vector.elements();
    }

    public Enumeration getHeaders(String name) {
        if (name.equalsIgnoreCase("Cookie")) {
            Iterator<Cookie> cookieIterator = this.cookieList.iterator();
            StringBuffer buffer = new StringBuffer("");
            while (cookieIterator.hasNext()) {
                Cookie cookie = cookieIterator.next();
                String cookieName = !cookie.getName().startsWith(this.cookieProxyFilter) ? this.cookieProxyFilter + cookie.getName() : cookie.getName();
                buffer.append(cookieName);
                buffer.append("=");
                buffer.append(cookie.getValue());
                if (!cookieIterator.hasNext()) continue;
                buffer.append("; ");
            }
            Vector<String> tmp = new Vector<String>();
            tmp.add(buffer.toString());
            return tmp.elements();
        }
        return super.getHeaders(name);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }
}

