/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.BusLogging;
import akka.event.DiagnosticLoggingAdapter;
import akka.event.DiagnosticLoggingAdapter$class;
import akka.event.LogSource;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$Error$NoCause$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.TraitSetter;
import scala.util.control.NoStackTrace;

public final class Logging$ {
    public static final Logging$ MODULE$;
    private final int ErrorLevel;
    private final int WarningLevel;
    private final int InfoLevel;
    private final int DebugLevel;
    private final int OffLevel;
    private final Seq<Logging.LogLevel> AllLogLevels;
    private final Logging.StandardOutLogger StandardOutLogger;
    private final Map<String, Object> emptyMDC;

    static {
        new Logging$();
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public final int ErrorLevel() {
        return this.ErrorLevel;
    }

    public final int WarningLevel() {
        return this.WarningLevel;
    }

    public final int InfoLevel() {
        return this.InfoLevel;
    }

    public final int DebugLevel() {
        return this.DebugLevel;
    }

    private final int OffLevel() {
        return this.OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s2) {
        String string2 = s2.toLowerCase(Locale.ROOT);
        Option option = "off".equals(string2) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.OffLevel())) : ("error".equals(string2) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.ErrorLevel())) : ("warning".equals(string2) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.WarningLevel())) : ("info".equals(string2) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.InfoLevel())) : ("debug".equals(string2) ? new Some<Logging.LogLevel>(new Logging.LogLevel(this.DebugLevel())) : None$.MODULE$))));
        return option;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        return Logging.Error.class.isAssignableFrom(eventClass) ? this.ErrorLevel() : (Logging.Warning.class.isAssignableFrom(eventClass) ? this.WarningLevel() : (Logging.Info.class.isAssignableFrom(eventClass) ? this.InfoLevel() : (Logging.Debug.class.isAssignableFrom(eventClass) ? this.DebugLevel() : this.DebugLevel())));
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        int n;
        block6: {
            Class clazz;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            n = level;
                            if (this.ErrorLevel() != n) break block2;
                            clazz = Logging.Error.class;
                            break block3;
                        }
                        if (this.WarningLevel() != n) break block4;
                        clazz = Logging.Warning.class;
                        break block3;
                    }
                    if (this.InfoLevel() != n) break block5;
                    clazz = Logging.Info.class;
                    break block3;
                }
                if (this.DebugLevel() != n) break block6;
                clazz = Logging.Debug.class;
            }
            return clazz;
        }
        throw new MatchError(new Logging.LogLevel(n));
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return this.AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$3) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$3);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new BusLogging(system.eventStream(), str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$4) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$4);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new BusLogging(bus, str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public DiagnosticLoggingAdapter apply(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new DiagnosticLoggingAdapter(logSource, str2, clazz2){
                private Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc;

                public Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc() {
                    return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
                }

                @TraitSetter
                public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map<String, Object> x$1) {
                    this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
                }

                public Map<String, Object> mdc() {
                    return DiagnosticLoggingAdapter$class.mdc(this);
                }

                public void mdc(Map<String, Object> mdc) {
                    DiagnosticLoggingAdapter$class.mdc(this, mdc);
                }

                public java.util.Map<String, Object> getMDC() {
                    return DiagnosticLoggingAdapter$class.getMDC(this);
                }

                public void setMDC(java.util.Map<String, Object> jMdc) {
                    DiagnosticLoggingAdapter$class.setMDC(this, jMdc);
                }

                public void clearMDC() {
                    DiagnosticLoggingAdapter$class.clearMDC(this);
                }
                {
                    DiagnosticLoggingAdapter$class.$init$(this);
                }
            };
        }
        throw new MatchError(tuple2);
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new BusLogging(system.eventStream(), str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new BusLogging(bus, str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public DiagnosticLoggingAdapter getLogger(UntypedActor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = tuple2._1();
            Class<?> clazz = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(str, clazz);
            String str2 = tuple23._1();
            Class<?> clazz2 = tuple23._2();
            return new DiagnosticLoggingAdapter(logSource, str2, clazz2){
                private Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc;

                public Map<String, Object> akka$event$DiagnosticLoggingAdapter$$_mdc() {
                    return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
                }

                @TraitSetter
                public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map<String, Object> x$1) {
                    this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
                }

                public Map<String, Object> mdc() {
                    return DiagnosticLoggingAdapter$class.mdc(this);
                }

                public void mdc(Map<String, Object> mdc) {
                    DiagnosticLoggingAdapter$class.mdc(this, mdc);
                }

                public java.util.Map<String, Object> getMDC() {
                    return DiagnosticLoggingAdapter$class.getMDC(this);
                }

                public void setMDC(java.util.Map<String, Object> jMdc) {
                    DiagnosticLoggingAdapter$class.setMDC(this, jMdc);
                }

                public void clearMDC() {
                    DiagnosticLoggingAdapter$class.clearMDC(this);
                }
                {
                    DiagnosticLoggingAdapter$class.$init$(this);
                }
            };
        }
        throw new MatchError(tuple2);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return this.StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        String string2;
        Throwable throwable = e;
        boolean bl = throwable == null ? true : Logging$Error$NoCause$.MODULE$.equals(throwable);
        if (bl) {
            string2 = "";
        } else if (throwable instanceof NoStackTrace) {
            string2 = new StringBuilder().append((Object)" (").append((Object)e.getClass().getName()).append((Object)")").toString();
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('\n');
            throwable.printStackTrace(pw);
            string2 = sw.toString();
        }
        return string2;
    }

    public Map<String, Object> emptyMDC() {
        return this.emptyMDC;
    }

    private Logging$() {
        MODULE$ = this;
        this.ErrorLevel = 1;
        this.WarningLevel = 2;
        this.InfoLevel = 3;
        this.DebugLevel = 4;
        this.OffLevel = Integer.MIN_VALUE;
        this.AllLogLevels = (Seq)package$.MODULE$.Vector().apply(Predef$.MODULE$.genericWrapArray(new Logging.LogLevel[]{new Logging.LogLevel(this.ErrorLevel()), new Logging.LogLevel(this.WarningLevel()), new Logging.LogLevel(this.InfoLevel()), new Logging.LogLevel(this.DebugLevel())}));
        this.StandardOutLogger = new Logging.StandardOutLogger();
        this.emptyMDC = (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
    }
}

