/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorSystemImpl;
import akka.actor.InternalActorRef;
import akka.actor.Props;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.dispatch.MessageDispatcher;
import akka.routing.Pool;
import akka.routing.ResizablePoolActor$Resize$;
import akka.routing.Resizer;
import akka.routing.RoutedActorCell;
import akka.routing.Routee;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0001\u0002\u0003\t\u0019\u0011\u0011CU3tSj\f'\r\\3Q_>d7)\u001a7m\u0015\t\u0019A!A\u0004s_V$\u0018N\\4\u000b\u0003\u0015\tA!Y6lCN\u0011\u0001a\u0002\t\u0003\u0011%i\u0011AA\u0005\u0003\u0015\t\u0011qBU8vi\u0016$\u0017i\u0019;pe\u000e+G\u000e\u001c\u0005\t\u0019\u0001\u0011\t\u0011)A\u0005\u001d\u00059ql]=ti\u0016l7\u0001\u0001\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!Y2u_JL!a\u0005\t\u0003\u001f\u0005\u001bGo\u001c:TsN$X-\\%na2D\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0005?J,g\r\u0005\u0002\u0010/%\u0011\u0001\u0004\u0005\u0002\u0011\u0013:$XM\u001d8bY\u0006\u001bGo\u001c:SK\u001aD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\r?J|W\u000f^3s!J|\u0007o\u001d\t\u0003\u001fqI!!\b\t\u0003\u000bA\u0013x\u000e]:\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011c\u0018:pkR,'\u000fR5ta\u0006$8\r[3s!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0005eSN\u0004\u0018\r^2i\u0013\t)#EA\tNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJD\u0011b\n\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0015\u0002\u0019}\u0013x.\u001e;fKB\u0013x\u000e]:\n\u0005%J\u0011a\u0003:pkR,W\r\u0015:paND\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IAF\u0001\f?N,\b/\u001a:wSN|'\u000f\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003\u0011\u0001xn\u001c7\u0016\u0003=\u0002\"\u0001\u0003\u0019\n\u0005E\u0012!\u0001\u0002)p_2D\u0001b\r\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0006a>|G\u000e\t\u0005\u0006k\u0001!\tAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011]B\u0014HO\u001e={y\u0002\"\u0001\u0003\u0001\t\u000b1!\u0004\u0019\u0001\b\t\u000bU!\u0004\u0019\u0001\f\t\u000bi!\u0004\u0019A\u000e\t\u000b}!\u0004\u0019\u0001\u0011\t\u000b\u001d\"\u0004\u0019A\u000e\t\u000b-\"\u0004\u0019\u0001\f\t\u000b5\"\u0004\u0019A\u0018\t\u000f\u0001\u0003!\u0019!C\u0001\u0003\u00069!/Z:ju\u0016\u0014X#\u0001\"\u0011\u0005!\u0019\u0015B\u0001#\u0003\u0005\u001d\u0011Vm]5{KJDaA\u0012\u0001!\u0002\u0013\u0011\u0015\u0001\u0003:fg&TXM\u001d\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006\u0001\"/Z:ju\u0016Le\u000e\u0015:pOJ,7o]\u000b\u0002\u0015B\u00111\nV\u0007\u0002\u0019*\u0011QJT\u0001\u0007CR|W.[2\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011KU\u0001\u0005kRLGNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005Uc%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004X\u0001\u0001\u0006IAS\u0001\u0012e\u0016\u001c\u0018N_3J]B\u0013xn\u001a:fgN\u0004\u0003bB-\u0001\u0005\u0004%IAW\u0001\u000ee\u0016\u001c\u0018N_3D_VtG/\u001a:\u0016\u0003m\u0003\"a\u0013/\n\u0005uc%AC!u_6L7\rT8oO\"1q\f\u0001Q\u0001\nm\u000baB]3tSj,7i\\;oi\u0016\u0014\b\u0005C\u0003b\u0001\u0011E#-A\u0007qe\u0016\u001cV\u000f]3s'R\f'\u000f\u001e\u000b\u0002GB\u0011AmZ\u0007\u0002K*\ta-A\u0003tG\u0006d\u0017-\u0003\u0002iK\n!QK\\5u\u0011\u0015Q\u0007\u0001\"\u0011l\u0003-\u0019XM\u001c3NKN\u001c\u0018mZ3\u0015\u0005\rd\u0007\"B7j\u0001\u0004q\u0017\u0001C3om\u0016dw\u000e]3\u0011\u0005\u0005z\u0017B\u00019#\u0005!)eN^3m_B,\u0007B\u0002:\u0001\t\u0003!1/\u0001\u0004sKNL'0\u001a\u000b\u0003GRDQ!^9A\u0002Y\fq!\u001b8ji&\fG\u000e\u0005\u0002eo&\u0011\u00010\u001a\u0002\b\u0005>|G.Z1o\u0001")
public final class ResizablePoolCell
extends RoutedActorCell {
    private final Pool pool;
    private final Resizer resizer;
    private final AtomicBoolean resizeInProgress;
    private final AtomicLong resizeCounter;

    public Pool pool() {
        return this.pool;
    }

    public Resizer resizer() {
        return this.resizer;
    }

    private AtomicBoolean resizeInProgress() {
        return this.resizeInProgress;
    }

    private AtomicLong resizeCounter() {
        return this.resizeCounter;
    }

    @Override
    public void preSuperStart() {
        if (this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement())) {
            this.resize(true);
        }
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (!this.routerConfig().isManagementMessage(envelope.message()) && this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement()) && this.resizeInProgress().compareAndSet(false, true)) {
            super.sendMessage(Envelope$.MODULE$.apply(ResizablePoolActor$Resize$.MODULE$, this.self(), this.system()));
        }
        super.sendMessage(envelope);
    }

    public void resize(boolean initial) {
        block5: {
            if (this.resizeInProgress().get() || initial) {
                int requestedCapacity = this.resizer().resize(this.router().routees());
                if (requestedCapacity > 0) {
                    Vector newRoutees = (Vector)package$.MODULE$.Vector().fill(requestedCapacity, new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ResizablePoolCell $outer;

                        public final Routee apply() {
                            return this.$outer.pool().newRoutee(this.$outer.routeeProps(), this.$outer);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.addRoutees(newRoutees);
                    break block5;
                }
                if (requestedCapacity >= 0) break block5;
                IndexedSeq<Routee> currentRoutees = this.router().routees();
                IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() + requestedCapacity);
                this.removeRoutees(abandon, true);
            }
        }
        return;
        finally {
            this.resizeInProgress().set(false);
        }
    }

    public ResizablePoolCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props _routeeProps, InternalActorRef _supervisor, Pool pool) {
        this.pool = pool;
        super(_system, _ref, _routerProps, _routerDispatcher, _routeeProps, _supervisor);
        Predef$.MODULE$.require(pool.resizer().isDefined(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RouterConfig must be a Pool with defined resizer";
            }
        }));
        this.resizer = pool.resizer().get();
        this.resizeInProgress = new AtomicBoolean();
        this.resizeCounter = new AtomicLong();
    }
}

