/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinition;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinitionFactory;
import org.craftsmenlabs.gareth.api.exception.GarethDefinitionParseException;
import org.craftsmenlabs.gareth.api.exception.GarethExperimentParseException;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.factory.ExperimentFactory;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.api.registry.ExperimentRegistry;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.craftsmenlabs.gareth.core.context.ExperimentContextImpl;
import org.craftsmenlabs.gareth.core.factory.ExperimentFactoryImpl;
import org.craftsmenlabs.gareth.core.invoker.MethodInvokerImpl;
import org.craftsmenlabs.gareth.core.parser.ParsedDefinitionFactoryImpl;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.craftsmenlabs.gareth.core.registry.DefinitionRegistryImpl;
import org.craftsmenlabs.gareth.core.registry.ExperimentRegistryImpl;
import org.craftsmenlabs.gareth.core.scheduler.akka.AkkaAssumeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEngineImpl
implements ExperimentEngine {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentEngineImpl.class);
    private final DefinitionRegistry definitionRegistry;
    private final ParsedDefinitionFactory parsedDefinitionFactory;
    private final ExperimentFactory experimentFactory;
    private final ExperimentRegistry experimentRegistry;
    private final ExperimentEngineConfig experimentEngineConfig;
    private final MethodInvoker methodInvoker;
    private final AssumeScheduler assumeScheduler;
    private final List<ExperimentContext> experimentContexts = new ArrayList<ExperimentContext>();

    private ExperimentEngineImpl(Builder builder) {
        this.experimentEngineConfig = builder.experimentEngineConfig;
        this.definitionRegistry = builder.definitionRegistry;
        this.parsedDefinitionFactory = builder.parsedDefinitionFactory;
        this.experimentFactory = builder.experimentFactory;
        this.experimentRegistry = builder.experimentRegistry;
        this.methodInvoker = builder.methodInvoker;
        this.assumeScheduler = builder.assumeScheduler;
    }

    private void registerDefinition(Class clazz) throws GarethDefinitionParseException {
        ParsedDefinition parsedDefinition = this.parsedDefinitionFactory.parse(clazz);
        this.addParsedDefinitionToRegistry(parsedDefinition);
    }

    private void registerExperiment(InputStream inputStream) {
        Experiment experiment = this.experimentFactory.buildExperiment(inputStream);
        this.experimentRegistry.addExperiment(experiment.getExperimentName(), experiment);
    }

    @Override
    public void start() {
        logger.info("Starting experiment engine");
        this.init();
        this.runExperiments();
    }

    private void populateExperimentContexts() {
        logger.info("Populating experiment contexts");
        for (Experiment experiment : this.experimentRegistry.getAllExperiments()) {
            for (AssumptionBlock assumptionBlock : experiment.getAssumptionBlockList()) {
                ExperimentContext experimentContext = new ExperimentContextImpl.Builder(experiment.getExperimentName(), assumptionBlock).setBaseline(this.getBaseline(assumptionBlock.getBaseline())).setAssume(this.getAssume(assumptionBlock.getAssumption())).setTime(this.getDuration(assumptionBlock.getTime())).setFailure(this.getFailure(assumptionBlock.getFailure())).setSuccess(this.getSuccess(assumptionBlock.getSuccess())).build();
                this.experimentContexts.add(experimentContext);
            }
        }
        logger.info(String.format("Added %d different experiments", this.experimentContexts.size()));
    }

    private void init() {
        logger.info("Initializing experiment engine");
        this.initDefinitions();
        this.initExperiments();
        this.populateExperimentContexts();
    }

    private void runExperiments() {
        logger.info("Run and schedule experiments");
        for (ExperimentContext experimentContext : this.experimentContexts) {
            if (!experimentContext.isValid()) continue;
            this.invokeBaseline(experimentContext.getBaseline());
            experimentContext.setBaselineRun(LocalDateTime.now());
            this.scheduleInvokeAssume(experimentContext);
            experimentContext.setFinished(true);
        }
    }

    private Duration getDuration(String timeGlueLine) {
        Duration duration = null;
        try {
            duration = this.definitionRegistry.getDurationForTime(timeGlueLine);
        }
        catch (GarethUnknownDefinitionException e) {
            throw new GarethInvocationException(e);
        }
        return duration;
    }

    private void invokeBaseline(Method baselineMethod) {
        block2: {
            try {
                this.methodInvoker.invoke(baselineMethod);
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                if (this.experimentEngineConfig.isIgnoreInvocationExceptions()) break block2;
                throw e;
            }
        }
    }

    private void scheduleInvokeAssume(ExperimentContext experimentContext) {
        block2: {
            try {
                this.assumeScheduler.schedule(experimentContext);
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                if (this.experimentEngineConfig.isIgnoreInvocationExceptions()) break block2;
                throw e;
            }
        }
    }

    private Method getSuccess(String glueLine) {
        Method method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodForSuccess(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private Method getAssume(String glueLine) {
        Method method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodForAssume(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private Method getBaseline(String glueLine) {
        Method method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodForBaseline(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private Method getFailure(String glueLine) {
        Method method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodForFailure(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExperiments() throws GarethExperimentParseException {
        for (InputStream inputStream : this.experimentEngineConfig.getInputStreams()) {
            try {
                this.registerExperiment(inputStream);
            }
            catch (GarethExperimentParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidExperiments()) continue;
                throw e;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    private void initDefinitions() {
        for (Class clazz : this.experimentEngineConfig.getDefinitionClasses()) {
            try {
                this.registerDefinition(clazz);
            }
            catch (GarethDefinitionParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidDefinitions()) continue;
                throw e;
            }
        }
    }

    private void addParsedDefinitionToRegistry(ParsedDefinition parsedDefinition) {
        parsedDefinition.getBaselineDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodForBaseline((String)k, (Method)v));
        parsedDefinition.getAssumeDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodForAssume((String)k, (Method)v));
        parsedDefinition.getFailureDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodForFailure((String)k, (Method)v));
        parsedDefinition.getSuccessDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodForSuccess((String)k, (Method)v));
        parsedDefinition.getTimeDefinitions().forEach((k, v) -> this.definitionRegistry.addDurationForTime((String)k, (Duration)v));
    }

    @Override
    public List<ExperimentContext> getExperimentContexts() {
        return this.experimentContexts;
    }

    public static class Builder {
        private final ExperimentEngineConfig experimentEngineConfig;
        private DefinitionRegistry definitionRegistry = new DefinitionRegistryImpl();
        private ReflectionHelper reflectionHelper = new ReflectionHelper();
        private ParsedDefinitionFactory parsedDefinitionFactory = new ParsedDefinitionFactoryImpl(this.reflectionHelper);
        private MethodInvoker methodInvoker = new MethodInvokerImpl(this.reflectionHelper);
        private ExperimentFactory experimentFactory = new ExperimentFactoryImpl();
        private ExperimentRegistry experimentRegistry = new ExperimentRegistryImpl();
        private AssumeScheduler assumeScheduler = null;

        public Builder(ExperimentEngineConfig experimentEngineConfig) {
            this.experimentEngineConfig = experimentEngineConfig;
        }

        public Builder setDefinitionRegistry(DefinitionRegistry definitionRegistry) {
            this.definitionRegistry = definitionRegistry;
            return this;
        }

        public Builder setParsedDefinitionFactory(ParsedDefinitionFactory parsedDefinitionFactory) {
            this.parsedDefinitionFactory = parsedDefinitionFactory;
            return this;
        }

        public Builder setExperimentRegistry(ExperimentRegistry experimentRegistry) {
            this.experimentRegistry = experimentRegistry;
            return this;
        }

        public Builder setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
            return this;
        }

        public Builder setExperimentFactory(ExperimentFactory experimentFactory) {
            this.experimentFactory = experimentFactory;
            return this;
        }

        private void buildDefaultAssumeScheduler() {
            if (this.assumeScheduler == null) {
                this.assumeScheduler = new AkkaAssumeScheduler.Builder().setIgnoreInvocationExceptions(this.experimentEngineConfig.isIgnoreInvocationExceptions()).build();
            }
        }

        public ExperimentEngine build() {
            this.buildDefaultAssumeScheduler();
            return new ExperimentEngineImpl(this);
        }
    }
}

