/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.listener;

import org.craftsmenlabs.gareth.GarethBaseListener;
import org.craftsmenlabs.gareth.GarethParser;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;
import org.craftsmenlabs.gareth.api.model.Experiment;

public class ExperimentBaseListener
extends GarethBaseListener {
    private final Experiment experiment = new Experiment();

    @Override
    public void enterAssumptionBlock(GarethParser.AssumptionBlockContext ctx) {
        this.experiment.getAssumptionBlockList().add(new AssumptionBlock());
    }

    @Override
    public void exitExperiment(GarethParser.ExperimentContext ctx) {
        this.experiment.setExperimentName(this.cleanupInput(ctx.expirementName.getText()));
    }

    @Override
    public void exitBaseline(GarethParser.BaselineContext ctx) {
        this.getNewestAssumptionBlock().setBaseline(this.cleanupInput(ctx.baselineGlueLine.getText()));
    }

    @Override
    public void exitAssumption(GarethParser.AssumptionContext ctx) {
        this.getNewestAssumptionBlock().setAssumption(this.cleanupInput(ctx.assumptionGlueLine.getText()));
    }

    @Override
    public void exitSuccess(GarethParser.SuccessContext ctx) {
        this.getNewestAssumptionBlock().setSuccess(this.cleanupInput(ctx.successGlueLine.getText()));
    }

    @Override
    public void exitFailure(GarethParser.FailureContext ctx) {
        this.getNewestAssumptionBlock().setFailure(this.cleanupInput(ctx.failureGlueLine.getText()));
    }

    @Override
    public void exitTime(GarethParser.TimeContext ctx) {
        this.getNewestAssumptionBlock().setTime(this.cleanupInput(ctx.timeGlueLine.getText()));
    }

    private AssumptionBlock getNewestAssumptionBlock() {
        return this.experiment.getAssumptionBlockList().get(this.experiment.getAssumptionBlockList().size() - 1);
    }

    private String cleanupInput(String input2) {
        String returnValue = input2;
        if (input2 != null) {
            returnValue = input2.trim();
        }
        return returnValue;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }
}

