/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.registry;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.craftsmenlabs.gareth.api.exception.GarethAlreadyKnownDefinitionException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;

public class DefinitionRegistryImpl
implements DefinitionRegistry {
    private final Map<String, Method> baselineDefinitions = new HashMap<String, Method>();
    private final Map<String, Method> assumeDefinitions = new HashMap<String, Method>();
    private final Map<String, Method> successDefinitions = new HashMap<String, Method>();
    private final Map<String, Method> failureDefinitions = new HashMap<String, Method>();
    private final Map<String, Duration> timeDefinitions = new HashMap<String, Duration>();

    @Override
    public Method getMethodForBaseline(String glueLine) {
        return this.getDefinition(this.getBaselineDefinitions(), glueLine);
    }

    @Override
    public Method getMethodForAssume(String glueLine) {
        return this.getDefinition(this.getAssumeDefinitions(), glueLine);
    }

    @Override
    public Method getMethodForSuccess(String glueLine) {
        return this.getDefinition(this.getSuccessDefinitions(), glueLine);
    }

    @Override
    public Method getMethodForFailure(String glueLine) {
        return this.getDefinition(this.getFailureDefinitions(), glueLine);
    }

    @Override
    public void addMethodForBaseline(String glueLine, Method method) {
        this.addDefinition(this.getBaselineDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodForAssume(String glueLine, Method method) {
        this.addDefinition(this.getAssumeDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodForSuccess(String glueLine, Method method) {
        this.addDefinition(this.getSuccessDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodForFailure(String glueLine, Method method) {
        this.addDefinition(this.getFailureDefinitions(), glueLine, method);
    }

    @Override
    public Duration getDurationForTime(String glueLine) {
        return this.getDefinition(this.getTimeDefinitions(), glueLine);
    }

    @Override
    public void addDurationForTime(String glueLine, Duration duration) {
        this.addDefinition(this.getTimeDefinitions(), glueLine, duration);
    }

    private <T> T getDefinition(Map<String, T> valueMap, String glueLine) {
        return Optional.ofNullable(valueMap.get(glueLine)).orElseThrow(() -> new GarethUnknownDefinitionException(String.format("No definition found for glue line '%s'", glueLine)));
    }

    private <T> void addDefinition(Map<String, T> valueMap, String glueLine, T definition) {
        if (valueMap.containsKey(glueLine)) {
            throw new GarethAlreadyKnownDefinitionException(String.format("Glue line already registered for '%s'", glueLine));
        }
        valueMap.put(glueLine, definition);
    }

    public Map<String, Method> getBaselineDefinitions() {
        return this.baselineDefinitions;
    }

    public Map<String, Method> getAssumeDefinitions() {
        return this.assumeDefinitions;
    }

    public Map<String, Method> getSuccessDefinitions() {
        return this.successDefinitions;
    }

    public Map<String, Method> getFailureDefinitions() {
        return this.failureDefinitions;
    }

    public Map<String, Duration> getTimeDefinitions() {
        return this.timeDefinitions;
    }
}

