/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.scheduler.akka;

import akka.actor.ActorSystem;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.craftsmenlabs.gareth.core.invoker.MethodInvokerImpl;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class AkkaAssumeScheduler
implements AssumeScheduler {
    private static final Logger logger = LoggerFactory.getLogger(AkkaAssumeScheduler.class);
    private final ActorSystem actorSystem;
    private final MethodInvoker methodInvoker;
    private final boolean ignoreInvocationExceptions;

    public AkkaAssumeScheduler(Builder builder) {
        this.methodInvoker = builder.methodInvoker;
        this.actorSystem = builder.actorSystem;
        this.ignoreInvocationExceptions = builder.ignoreInvocationExceptions;
    }

    @Override
    public void schedule(ExperimentContext experimentContext) {
        block2: {
            java.time.Duration time = experimentContext.getTime();
            try {
                this.actorSystem.scheduler().scheduleOnce(Duration.create(time.toMillis(), TimeUnit.MILLISECONDS), () -> {
                    block3: {
                        try {
                            logger.debug("Invoking assumption");
                            this.methodInvoker.invoke(experimentContext.getAssume());
                            experimentContext.setAssumeRun(LocalDateTime.now());
                            if (null != experimentContext.getSuccess()) {
                                logger.debug("Invoking success");
                                this.methodInvoker.invoke(experimentContext.getSuccess());
                                experimentContext.setSuccessRun(LocalDateTime.now());
                            }
                        }
                        catch (Exception e) {
                            if (null == experimentContext.getFailure()) break block3;
                            logger.debug("Invoking failure");
                            this.methodInvoker.invoke(experimentContext.getFailure());
                            experimentContext.setFailureRun(LocalDateTime.now());
                        }
                    }
                }, (ExecutionContext)this.actorSystem.dispatcher());
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                logger.error("Problem during assumption invocation", e);
                if (this.ignoreInvocationExceptions) break block2;
                throw e;
            }
        }
    }

    public static class Builder {
        private ReflectionHelper reflectionHelper = new ReflectionHelper();
        private MethodInvoker methodInvoker = new MethodInvokerImpl(this.reflectionHelper);
        private ActorSystem actorSystem = ActorSystem.create();
        private boolean ignoreInvocationExceptions;

        public Builder setActorSystem(ActorSystem actorSystem) {
            this.actorSystem = actorSystem;
            return this;
        }

        public Builder setIgnoreInvocationExceptions(boolean ignoreInvocationExceptions) {
            this.ignoreInvocationExceptions = ignoreInvocationExceptions;
            return this;
        }

        public Builder setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
            return this;
        }

        public AssumeScheduler build() {
            return new AkkaAssumeScheduler(this);
        }
    }
}

