/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.context;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.xml.bind.annotation.XmlRootElement;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;

@XmlRootElement
public class ExperimentContextImpl
implements ExperimentContext {
    private final String experimentName;
    private Method baseline;
    private Method assume;
    private Method success;
    private Method failure;
    private Duration time;
    private String baselineGlueLine;
    private String assumeGlueLine;
    private String successGlueLine;
    private String failureGlueLine;
    private String timeGlueLine;
    private boolean finished;
    private LocalDateTime baselineRun;
    private LocalDateTime assumeRun;
    private LocalDateTime successRun;
    private LocalDateTime failureRun;

    private ExperimentContextImpl(Builder builder) {
        this.experimentName = builder.experimentName;
        this.baselineGlueLine = builder.assumptionBlock.getBaseline();
        this.assumeGlueLine = builder.assumptionBlock.getAssumption();
        this.timeGlueLine = builder.assumptionBlock.getTime();
        this.successGlueLine = builder.assumptionBlock.getSuccess();
        this.failureGlueLine = builder.assumptionBlock.getFailure();
        this.assume = builder.assume;
        this.baseline = builder.baseline;
        this.success = builder.success;
        this.failure = builder.failure;
        this.time = builder.time;
    }

    @Override
    public boolean isValid() {
        return null != this.baseline && null != this.assume && null != this.time;
    }

    @Override
    public boolean hasFailures() {
        return null != this.failureRun;
    }

    @Override
    public boolean isRunning() {
        return (null != this.baselineRun || null != this.assumeRun) && null == this.successRun && null == this.failureRun;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public Method getBaseline() {
        return this.baseline;
    }

    @Override
    public Method getAssume() {
        return this.assume;
    }

    @Override
    public Method getSuccess() {
        return this.success;
    }

    @Override
    public Method getFailure() {
        return this.failure;
    }

    @Override
    public Duration getTime() {
        return this.time;
    }

    @Override
    public String getBaselineGlueLine() {
        return this.baselineGlueLine;
    }

    @Override
    public String getAssumeGlueLine() {
        return this.assumeGlueLine;
    }

    @Override
    public String getSuccessGlueLine() {
        return this.successGlueLine;
    }

    @Override
    public String getFailureGlueLine() {
        return this.failureGlueLine;
    }

    @Override
    public String getTimeGlueLine() {
        return this.timeGlueLine;
    }

    @Override
    public LocalDateTime getBaselineRun() {
        return this.baselineRun;
    }

    @Override
    public LocalDateTime getAssumeRun() {
        return this.assumeRun;
    }

    @Override
    public LocalDateTime getSuccessRun() {
        return this.successRun;
    }

    @Override
    public LocalDateTime getFailureRun() {
        return this.failureRun;
    }

    @Override
    public void setBaselineRun(LocalDateTime baselineRun) {
        this.baselineRun = baselineRun;
    }

    @Override
    public void setAssumeRun(LocalDateTime assumeRun) {
        this.assumeRun = assumeRun;
    }

    @Override
    public void setSuccessRun(LocalDateTime successRun) {
        this.successRun = successRun;
    }

    @Override
    public void setFailureRun(LocalDateTime failureRun) {
        this.failureRun = failureRun;
    }

    public static class Builder {
        private final String experimentName;
        private final AssumptionBlock assumptionBlock;
        private Method baseline;
        private Method assume;
        private Method success;
        private Method failure;
        private Duration time;

        public Builder(String experimentName, AssumptionBlock assumptionBlock) {
            this.experimentName = experimentName;
            this.assumptionBlock = assumptionBlock;
        }

        public Builder setBaseline(Method baseline) {
            this.baseline = baseline;
            return this;
        }

        public Builder setAssume(Method assume) {
            this.assume = assume;
            return this;
        }

        public Builder setSuccess(Method success) {
            this.success = success;
            return this;
        }

        public Builder setFailure(Method failure) {
            this.failure = failure;
            return this;
        }

        public Builder setTime(Duration time) {
            this.time = time;
            return this;
        }

        public ExperimentContext build() {
            return new ExperimentContextImpl(this);
        }
    }
}

