/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokerImpl
implements MethodInvoker {
    private static final Logger logger = LoggerFactory.getLogger(MethodInvokerImpl.class);
    private final ReflectionHelper reflectionHelper;

    public MethodInvokerImpl(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public void invoke(Method method) throws GarethInvocationException {
        try {
            logger.trace("Invoking method %s", (Object)method.getName());
            Object declaringClassInstance = this.reflectionHelper.getInstanceForClass(method.getDeclaringClass());
            method.invoke(declaringClassInstance, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GarethInvocationException(e);
        }
    }
}

