/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.scheduler;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.exceptions.JobInterruptException;
import java.time.LocalDateTime;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInvocationJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInvocationJob.class);

    @Override
    public void doRun() throws JobInterruptException {
        block3: {
            MethodInvoker methodInvoker = (MethodInvoker)this.getJobContext().getRequiredValue("methodInvoker");
            ExperimentContext experimentContext = (ExperimentContext)this.getJobContext().getRequiredValue("experimentContext");
            try {
                logger.debug("Invoking assumption");
                methodInvoker.invoke(experimentContext.getAssume());
                experimentContext.setAssumeRun(LocalDateTime.now());
                if (null != experimentContext.getSuccess()) {
                    logger.debug("Invoking success");
                    methodInvoker.invoke(experimentContext.getSuccess());
                    experimentContext.setSuccessRun(LocalDateTime.now());
                }
            }
            catch (Exception e) {
                if (null == experimentContext.getFailure()) break block3;
                logger.debug("Invoking failure");
                methodInvoker.invoke(experimentContext.getFailure());
                experimentContext.setFailureRun(LocalDateTime.now());
            }
        }
    }
}

