/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.api.definition;

import org.craftsmenlabs.gareth.api.annotation.Assume;
import org.craftsmenlabs.gareth.api.annotation.Baseline;
import org.craftsmenlabs.gareth.api.annotation.Failure;
import org.craftsmenlabs.gareth.api.annotation.Success;
import org.craftsmenlabs.gareth.api.annotation.Time;

public enum DefinitionType {
    BASELINE(Baseline.class),
    ASSUME(Assume.class),
    TIME(Time.class),
    SUCCESS(Success.class),
    FAILURE(Failure.class);

    private final Class annotationClass;

    private DefinitionType(Class annotationClass) {
        this.annotationClass = annotationClass;
    }

    public static final DefinitionType getDefinitionType(Class annotationClass) {
        for (DefinitionType definitionType : DefinitionType.values()) {
            if (!definitionType.getAnnotationClass().equals(annotationClass)) continue;
            return definitionType;
        }
        throw new IllegalStateException(String.format("DefinitionType not found for class %s", annotationClass));
    }

    public Class getAnnotationClass() {
        return this.annotationClass;
    }
}

