/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.context;

import java.time.Duration;
import java.time.LocalDateTime;
import javax.xml.bind.annotation.XmlRootElement;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;
import org.craftsmenlabs.gareth.api.storage.Storage;

@XmlRootElement
public class ExperimentContextImpl
implements ExperimentContext {
    private final String experimentName;
    private final MethodDescriptor baseline;
    private final MethodDescriptor assume;
    private final MethodDescriptor success;
    private final MethodDescriptor failure;
    private final Duration time;
    private final String baselineGlueLine;
    private final String assumeGlueLine;
    private final String successGlueLine;
    private final String failureGlueLine;
    private final String timeGlueLine;
    private boolean finished;
    private final Storage storage;
    private LocalDateTime baselineRun;
    private LocalDateTime assumeRun;
    private LocalDateTime successRun;
    private LocalDateTime failureRun;

    private ExperimentContextImpl(Builder builder) {
        this.experimentName = builder.experimentName;
        this.baselineGlueLine = builder.assumptionBlock.getBaseline();
        this.assumeGlueLine = builder.assumptionBlock.getAssumption();
        this.timeGlueLine = builder.assumptionBlock.getTime();
        this.successGlueLine = builder.assumptionBlock.getSuccess();
        this.failureGlueLine = builder.assumptionBlock.getFailure();
        this.assume = builder.assume;
        this.baseline = builder.baseline;
        this.success = builder.success;
        this.failure = builder.failure;
        this.time = builder.time;
        this.storage = builder.storage;
    }

    @Override
    public boolean isValid() {
        return null != this.baseline && null != this.assume && null != this.time;
    }

    @Override
    public boolean hasFailures() {
        return null != this.failureRun;
    }

    @Override
    public boolean isRunning() {
        return (null != this.baselineRun || null != this.assumeRun) && null == this.successRun && null == this.failureRun;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean hasStorage() {
        return this.getAssume().hasStorage() || this.getBaseline().hasStorage() || null != this.getFailure() && this.getFailure().hasStorage() || null != this.getSuccess() && this.getSuccess().hasStorage();
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public MethodDescriptor getBaseline() {
        return this.baseline;
    }

    @Override
    public MethodDescriptor getAssume() {
        return this.assume;
    }

    @Override
    public MethodDescriptor getSuccess() {
        return this.success;
    }

    @Override
    public MethodDescriptor getFailure() {
        return this.failure;
    }

    @Override
    public Duration getTime() {
        return this.time;
    }

    @Override
    public String getBaselineGlueLine() {
        return this.baselineGlueLine;
    }

    @Override
    public String getAssumeGlueLine() {
        return this.assumeGlueLine;
    }

    @Override
    public String getSuccessGlueLine() {
        return this.successGlueLine;
    }

    @Override
    public String getFailureGlueLine() {
        return this.failureGlueLine;
    }

    @Override
    public String getTimeGlueLine() {
        return this.timeGlueLine;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public LocalDateTime getBaselineRun() {
        return this.baselineRun;
    }

    @Override
    public LocalDateTime getAssumeRun() {
        return this.assumeRun;
    }

    @Override
    public LocalDateTime getSuccessRun() {
        return this.successRun;
    }

    @Override
    public LocalDateTime getFailureRun() {
        return this.failureRun;
    }

    @Override
    public void setBaselineRun(LocalDateTime baselineRun) {
        this.baselineRun = baselineRun;
    }

    @Override
    public void setAssumeRun(LocalDateTime assumeRun) {
        this.assumeRun = assumeRun;
    }

    @Override
    public void setSuccessRun(LocalDateTime successRun) {
        this.successRun = successRun;
    }

    @Override
    public void setFailureRun(LocalDateTime failureRun) {
        this.failureRun = failureRun;
    }

    public static class Builder {
        private final String experimentName;
        private final AssumptionBlock assumptionBlock;
        private MethodDescriptor baseline;
        private MethodDescriptor assume;
        private MethodDescriptor success;
        private MethodDescriptor failure;
        private Duration time;
        private Storage storage = null;

        public Builder(String experimentName, AssumptionBlock assumptionBlock) {
            this.experimentName = experimentName;
            this.assumptionBlock = assumptionBlock;
        }

        public Builder setBaseline(MethodDescriptor baseline) {
            this.baseline = baseline;
            return this;
        }

        public Builder setAssume(MethodDescriptor assume) {
            this.assume = assume;
            return this;
        }

        public Builder setSuccess(MethodDescriptor success) {
            this.success = success;
            return this;
        }

        public Builder setFailure(MethodDescriptor failure) {
            this.failure = failure;
            return this;
        }

        public Builder setTime(Duration time) {
            this.time = time;
            return this;
        }

        public Builder setStorage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public ExperimentContext build() {
            return new ExperimentContextImpl(this);
        }
    }
}

