/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.sundial;

import com.xeiam.sundial.JobContainer;
import com.xeiam.sundial.SundialJobScheduler;
import com.xeiam.sundial.exceptions.JobInterruptException;
import com.xeiam.sundial.exceptions.RequiredParameterException;
import org.quartz.core.JobExecutionContext;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.exceptions.UnableToInterruptJobException;
import org.quartz.jobs.InterruptableJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
extends JobContainer
implements InterruptableJob {
    private final Logger logger = LoggerFactory.getLogger(Job.class);

    @Override
    public final void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (SundialJobScheduler.getGlobalLock()) {
            this.logger.info("Global Lock in place! Job aborted.");
            return;
        }
        try {
            this.initContextContainer(jobExecutionContext);
            this.doRun();
        }
        catch (RequiredParameterException requiredParameterException) {
        }
        catch (JobInterruptException jobInterruptException) {
        }
        catch (Exception e) {
            this.logger.error("Error executing Job! Job aborted!!!", e);
        }
        finally {
            this.cleanup();
            this.destroyContext();
        }
    }

    @Override
    public void interrupt() throws UnableToInterruptJobException {
        this.setTerminate();
        this.logger.info("Interrupt called!");
    }

    public void cleanup() {
    }

    public abstract void doRun() throws JobInterruptException;
}

