/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.builders;

import java.text.ParseException;
import java.util.TimeZone;
import org.quartz.builders.TriggerBuilder;
import org.quartz.triggers.CronExpression;
import org.quartz.triggers.CronTriggerImpl;
import org.quartz.triggers.OperableTrigger;

public class CronTriggerBuilder
extends TriggerBuilder {
    private String cronExpression;
    private TimeZone tz = null;
    private int misfireInstruction = 0;

    private CronTriggerBuilder(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public static CronTriggerBuilder cronTriggerBuilder(String cronExpression) throws ParseException {
        CronExpression.validateExpression(cronExpression);
        return new CronTriggerBuilder(cronExpression);
    }

    @Override
    public OperableTrigger instantiate() {
        CronTriggerImpl ct = new CronTriggerImpl();
        try {
            ct.setCronExpression(this.cronExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException("CronExpression '" + this.cronExpression + "' is invalid, which should not be possible, please report bug to Quartz developers.");
        }
        ct.setTimeZone(this.tz);
        ct.setMisfireInstruction(this.misfireInstruction);
        return ct;
    }

    public CronTriggerBuilder inTimeZone(TimeZone tz) {
        this.tz = tz;
        return this;
    }

    public CronTriggerBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CronTriggerBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }
}

