/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.QuartzScheduler;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.TriggerFiredBundle;
import org.quartz.core.TriggerFiredResult;
import org.quartz.exceptions.JobPersistenceException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler quartzScheduler;
    private QuartzSchedulerResources quartzSchedulerResources;
    private final Object sigLock = new Object();
    private boolean signaled;
    private long signaledNextFireTime;
    private boolean paused;
    private AtomicBoolean halted;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs) {
        this(qs, qsRsrcs, qsRsrcs.getMakeSchedulerThreadDaemon(), 5);
    }

    private QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources, boolean setDaemon, int threadPrio) {
        super(quartzScheduler.getSchedulerThreadGroup(), quartzSchedulerResources.getThreadName());
        this.quartzScheduler = quartzScheduler;
        this.quartzSchedulerResources = quartzSchedulerResources;
        this.setDaemon(setDaemon);
        if (quartzSchedulerResources.isThreadsInheritInitializersClassLoadContext()) {
            this.logger.info("QuartzSchedulerThread Inheriting ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = new AtomicBoolean(false);
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePause(boolean pause) {
        Object object = this.sigLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange(0L);
            } else {
                this.sigLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        Object object = this.sigLock;
        synchronized (object) {
            this.halted.set(true);
            if (this.paused) {
                this.sigLock.notifyAll();
            } else {
                this.signalSchedulingChange(0L);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalSchedulingChange(long candidateNewNextFireTime) {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = true;
            this.signaledNextFireTime = candidateNewNextFireTime;
            this.sigLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSignaledSchedulingChange() {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = false;
            this.signaledNextFireTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduleChanged() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSignaledNextFireTime() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaledNextFireTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean lastAcquireFailed = false;
        while (!this.halted.get()) {
            try {
                Object object = this.sigLock;
                synchronized (object) {
                    while (this.paused && !this.halted.get()) {
                        try {
                            this.sigLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.halted.get()) {
                        break;
                    }
                }
                int availThreadCount = this.quartzSchedulerResources.getThreadPool().blockForAvailableThreads();
                if (availThreadCount <= 0) continue;
                List<OperableTrigger> triggers = null;
                long now = System.currentTimeMillis();
                this.clearSignaledSchedulingChange();
                try {
                    triggers = this.quartzSchedulerResources.getJobStore().acquireNextTriggers(now + this.idleWaitTime, Math.min(availThreadCount, this.quartzSchedulerResources.getMaxBatchSize()), this.quartzSchedulerResources.getBatchTimeWindow());
                    lastAcquireFailed = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("batch acquisition of " + (triggers == null ? 0 : triggers.size()) + " triggers");
                    }
                }
                catch (JobPersistenceException jpe) {
                    lastAcquireFailed = true;
                }
                catch (RuntimeException e) {
                    if (!lastAcquireFailed) {
                        this.logger.error("quartzSchedulerThreadLoop: RuntimeException " + e.getMessage(), e);
                    }
                    lastAcquireFailed = true;
                }
                if (triggers != null && !triggers.isEmpty()) {
                    now = System.currentTimeMillis();
                    long triggerTime = ((OperableTrigger)triggers.get(0)).getNextFireTime().getTime();
                    long timeUntilTrigger = triggerTime - now;
                    while (timeUntilTrigger > 2L) {
                        Object object2 = this.sigLock;
                        synchronized (object2) {
                            if (this.halted.get()) {
                                break;
                            }
                            if (!this.isCandidateNewTimeEarlierWithinReason(triggerTime, false)) {
                                try {
                                    now = System.currentTimeMillis();
                                    timeUntilTrigger = triggerTime - now;
                                    if (timeUntilTrigger >= 1L) {
                                        this.sigLock.wait(timeUntilTrigger);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.releaseIfScheduleChangedSignificantly(triggers, triggerTime)) break;
                        now = System.currentTimeMillis();
                        timeUntilTrigger = triggerTime - now;
                    }
                    if (triggers.isEmpty()) continue;
                    List<Object> bndles = new ArrayList();
                    boolean goAhead = true;
                    Object object3 = this.sigLock;
                    synchronized (object3) {
                        goAhead = !this.halted.get();
                    }
                    if (goAhead) {
                        try {
                            List<TriggerFiredResult> res = this.quartzSchedulerResources.getJobStore().triggersFired(triggers);
                            if (res != null) {
                                bndles = res;
                            }
                        }
                        catch (SchedulerException se) {
                            this.quartzScheduler.notifySchedulerListenersError("An error occurred while firing triggers '" + triggers + "'", se);
                        }
                    }
                    for (int i = 0; i < bndles.size(); ++i) {
                        TriggerFiredResult result = (TriggerFiredResult)bndles.get(i);
                        TriggerFiredBundle bndle = result.getTriggerFiredBundle();
                        Exception exception = result.getException();
                        if (exception instanceof RuntimeException) {
                            this.logger.error("RuntimeException while firing trigger " + triggers.get(i), exception);
                            continue;
                        }
                        if (bndle == null) {
                            try {
                                this.quartzSchedulerResources.getJobStore().releaseAcquiredTrigger(triggers.get(i));
                            }
                            catch (SchedulerException se) {
                                this.quartzScheduler.notifySchedulerListenersError("An error occurred while releasing triggers '" + triggers.get(i).getName() + "'", se);
                            }
                            continue;
                        }
                        JobRunShell shell = null;
                        try {
                            shell = this.quartzSchedulerResources.getJobRunShellFactory().createJobRunShell(bndle);
                            shell.initialize(this.quartzScheduler);
                        }
                        catch (SchedulerException se) {
                            try {
                                this.quartzSchedulerResources.getJobStore().triggeredJobComplete(triggers.get(i), bndle.getJobDetail(), Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                            }
                            catch (SchedulerException se2) {
                                this.quartzScheduler.notifySchedulerListenersError("An error occurred while placing job's triggers in error state '" + triggers.get(i).getName() + "'", se2);
                            }
                            continue;
                        }
                        if (this.quartzSchedulerResources.getThreadPool().runInThread(shell)) continue;
                        try {
                            this.logger.error("ThreadPool.runInThread() return false!");
                            this.quartzSchedulerResources.getJobStore().triggeredJobComplete(triggers.get(i), bndle.getJobDetail(), Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                            continue;
                        }
                        catch (SchedulerException se2) {
                            this.quartzScheduler.notifySchedulerListenersError("An error occurred while placing job's triggers in error state '" + triggers.get(i).getName() + "'", se2);
                        }
                    }
                    continue;
                }
                long now2 = System.currentTimeMillis();
                long waitTime = now2 + this.getRandomizedIdleWaitTime();
                long timeUntilContinue = waitTime - now2;
                Object object4 = this.sigLock;
                synchronized (object4) {
                    try {
                        this.sigLock.wait(timeUntilContinue);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException re) {
                this.logger.error("Runtime error occurred in main trigger firing loop.", re);
            }
        }
        this.quartzScheduler = null;
        this.quartzSchedulerResources = null;
    }

    private boolean releaseIfScheduleChangedSignificantly(List<OperableTrigger> triggers, long triggerTime) {
        if (this.isCandidateNewTimeEarlierWithinReason(triggerTime, true)) {
            for (OperableTrigger trigger : triggers) {
                try {
                    this.quartzSchedulerResources.getJobStore().releaseAcquiredTrigger(trigger);
                }
                catch (JobPersistenceException jpe) {
                    this.quartzScheduler.notifySchedulerListenersError("An error occurred while releasing trigger '" + trigger.getName() + "'", jpe);
                }
                catch (RuntimeException e) {
                    this.logger.error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
                }
            }
            triggers.clear();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCandidateNewTimeEarlierWithinReason(long oldTime, boolean clearSignal) {
        Object object = this.sigLock;
        synchronized (object) {
            long diff;
            if (!this.isScheduleChanged()) {
                return false;
            }
            boolean earlier = false;
            if (this.getSignaledNextFireTime() == 0L) {
                earlier = true;
            } else if (this.getSignaledNextFireTime() < oldTime) {
                earlier = true;
            }
            if (earlier && (diff = oldTime - System.currentTimeMillis()) < 7L) {
                earlier = false;
            }
            if (clearSignal) {
                this.clearSignaledSchedulingChange();
            }
            return earlier;
        }
    }
}

