/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.context.ExperimentPartState;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinition;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinitionFactory;
import org.craftsmenlabs.gareth.api.exception.GarethDefinitionParseException;
import org.craftsmenlabs.gareth.api.exception.GarethExperimentParseException;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.factory.ExperimentFactory;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.api.registry.ExperimentRegistry;
import org.craftsmenlabs.gareth.api.rest.RestService;
import org.craftsmenlabs.gareth.api.rest.RestServiceFactory;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.craftsmenlabs.gareth.api.storage.StorageFactory;
import org.craftsmenlabs.gareth.core.context.ExperimentContextImpl;
import org.craftsmenlabs.gareth.core.factory.ExperimentFactoryImpl;
import org.craftsmenlabs.gareth.core.invoker.MethodInvokerImpl;
import org.craftsmenlabs.gareth.core.parser.ParsedDefinitionFactoryImpl;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.craftsmenlabs.gareth.core.registry.DefinitionRegistryImpl;
import org.craftsmenlabs.gareth.core.registry.ExperimentRegistryImpl;
import org.craftsmenlabs.gareth.core.scheduler.DefaultAssumeScheduler;
import org.craftsmenlabs.gareth.core.storage.DefaultStorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEngineImpl
implements ExperimentEngine {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentEngineImpl.class);
    private final DefinitionRegistry definitionRegistry;
    private final ParsedDefinitionFactory parsedDefinitionFactory;
    private final ExperimentFactory experimentFactory;
    private final ExperimentRegistry experimentRegistry;
    private final ExperimentEngineConfig experimentEngineConfig;
    private final MethodInvoker methodInvoker;
    private final AssumeScheduler assumeScheduler;
    private final List<ExperimentContext> experimentContexts = new ArrayList<ExperimentContext>();
    private final RestServiceFactory restServiceFactory;
    private final StorageFactory storageFactory;
    private boolean started;

    private ExperimentEngineImpl(Builder builder) {
        this.experimentEngineConfig = builder.experimentEngineConfig;
        this.definitionRegistry = builder.definitionRegistry;
        this.parsedDefinitionFactory = builder.parsedDefinitionFactory;
        this.experimentFactory = builder.experimentFactory;
        this.experimentRegistry = builder.experimentRegistry;
        this.methodInvoker = builder.methodInvoker;
        this.assumeScheduler = builder.assumeScheduler;
        this.restServiceFactory = builder.restServiceFactory;
        this.storageFactory = builder.storageFactory;
    }

    private void registerDefinition(Class clazz) throws GarethDefinitionParseException {
        ParsedDefinition parsedDefinition = this.parsedDefinitionFactory.parse(clazz);
        this.addParsedDefinitionToRegistry(parsedDefinition);
    }

    private void registerExperiment(InputStream inputStream) {
        Experiment experiment = this.experimentFactory.buildExperiment(inputStream);
        this.experimentRegistry.addExperiment(experiment.getExperimentName(), experiment);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Experiment engine already started");
        }
        this.started = true;
        logger.info("Starting experiment engine");
        this.init();
        this.startRestService();
        this.runExperiments();
    }

    private void populateExperimentContexts() {
        logger.info("Populating experiment contexts");
        for (Experiment experiment : this.experimentRegistry.getAllExperiments()) {
            for (AssumptionBlock assumptionBlock : experiment.getAssumptionBlockList()) {
                ExperimentContext experimentContext = new ExperimentContextImpl.Builder(experiment.getExperimentName(), assumptionBlock).setBaseline(Optional.ofNullable(this.getBaseline(assumptionBlock.getBaseline()))).setAssume(Optional.ofNullable(this.getAssume(assumptionBlock.getAssumption()))).setTime(this.getDuration(assumptionBlock.getTime())).setFailure(Optional.ofNullable(this.getFailure(assumptionBlock.getFailure()))).setSuccess(Optional.ofNullable(this.getSuccess(assumptionBlock.getSuccess()))).setStorage(this.storageFactory.createStorage()).build();
                this.experimentContexts.add(experimentContext);
            }
        }
        logger.info(String.format("Added %d different experiments", this.experimentContexts.size()));
    }

    private void init() {
        logger.info("Initializing experiment engine");
        this.initDefinitions();
        this.initExperiments();
        this.populateExperimentContexts();
    }

    private void startRestService() {
        if (null != this.restServiceFactory) {
            try {
                logger.info("Starting REST service");
                RestService restService = this.restServiceFactory.create(this, 8888);
                restService.start();
            }
            catch (Exception e) {
                logger.error("REST service cannot be started", e);
            }
        }
    }

    private void runExperiments() {
        logger.info("Run and schedule experiments");
        for (ExperimentContext experimentContext : this.experimentContexts) {
            this.planExperimentContext(experimentContext);
        }
    }

    @Override
    public void planExperimentContext(ExperimentContext experimentContext) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot plan experiment context when engine is not started");
        }
        if (experimentContext.isValid()) {
            this.invokeBaseline(experimentContext);
            experimentContext.setBaselineRun(LocalDateTime.now());
            this.scheduleInvokeAssume(experimentContext);
            experimentContext.setFinished(true);
        }
    }

    private Duration getDuration(String timeGlueLine) {
        Duration duration = null;
        try {
            duration = this.definitionRegistry.getDurationForTime(timeGlueLine);
        }
        catch (GarethUnknownDefinitionException e) {
            throw new GarethInvocationException(e);
        }
        return duration;
    }

    private void invokeBaseline(ExperimentContext experimentContext) {
        block4: {
            try {
                experimentContext.setBaselineState(ExperimentPartState.RUNNING);
                if (experimentContext.hasStorage()) {
                    this.methodInvoker.invoke(experimentContext.getBaseline(), experimentContext.getStorage());
                } else {
                    this.methodInvoker.invoke(experimentContext.getBaseline());
                }
                experimentContext.setBaselineState(ExperimentPartState.FINISHED);
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                experimentContext.setBaselineState(ExperimentPartState.ERROR);
                if (this.experimentEngineConfig.isIgnoreInvocationExceptions()) break block4;
                throw e;
            }
        }
    }

    private void scheduleInvokeAssume(ExperimentContext experimentContext) {
        block2: {
            try {
                this.assumeScheduler.schedule(experimentContext);
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                if (this.experimentEngineConfig.isIgnoreInvocationExceptions()) break block2;
                throw e;
            }
        }
    }

    private MethodDescriptor getSuccess(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForSuccess(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getAssume(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForAssume(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getBaseline(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForBaseline(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getFailure(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForFailure(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExperiments() throws GarethExperimentParseException {
        for (InputStream inputStream : this.experimentEngineConfig.getInputStreams()) {
            try {
                this.registerExperiment(inputStream);
            }
            catch (GarethExperimentParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidExperiments()) continue;
                throw e;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    private void initDefinitions() {
        for (Class clazz : this.experimentEngineConfig.getDefinitionClasses()) {
            try {
                this.registerDefinition(clazz);
            }
            catch (GarethDefinitionParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidDefinitions()) continue;
                throw e;
            }
        }
    }

    private void addParsedDefinitionToRegistry(ParsedDefinition parsedDefinition) {
        parsedDefinition.getBaselineDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForBaseline((String)k, (MethodDescriptor)v));
        parsedDefinition.getAssumeDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForAssume((String)k, (MethodDescriptor)v));
        parsedDefinition.getFailureDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForFailure((String)k, (MethodDescriptor)v));
        parsedDefinition.getSuccessDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForSuccess((String)k, (MethodDescriptor)v));
        parsedDefinition.getTimeDefinitions().forEach((k, v) -> this.definitionRegistry.addDurationForTime((String)k, (Duration)v));
    }

    @Override
    public List<ExperimentContext> getExperimentContexts() {
        return this.experimentContexts;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public static class Builder {
        private final ExperimentEngineConfig experimentEngineConfig;
        private DefinitionRegistry definitionRegistry = new DefinitionRegistryImpl();
        private ReflectionHelper reflectionHelper = new ReflectionHelper();
        private ParsedDefinitionFactory parsedDefinitionFactory = new ParsedDefinitionFactoryImpl(this.reflectionHelper);
        private MethodInvoker methodInvoker = new MethodInvokerImpl(this.reflectionHelper);
        private ExperimentFactory experimentFactory = new ExperimentFactoryImpl();
        private ExperimentRegistry experimentRegistry = new ExperimentRegistryImpl();
        private AssumeScheduler assumeScheduler = null;
        private RestServiceFactory restServiceFactory;
        private StorageFactory storageFactory = new DefaultStorageFactory();

        public Builder(ExperimentEngineConfig experimentEngineConfig) {
            this.experimentEngineConfig = experimentEngineConfig;
        }

        public Builder setDefinitionRegistry(DefinitionRegistry definitionRegistry) {
            this.definitionRegistry = definitionRegistry;
            return this;
        }

        public Builder setParsedDefinitionFactory(ParsedDefinitionFactory parsedDefinitionFactory) {
            this.parsedDefinitionFactory = parsedDefinitionFactory;
            return this;
        }

        public Builder setExperimentRegistry(ExperimentRegistry experimentRegistry) {
            this.experimentRegistry = experimentRegistry;
            return this;
        }

        public Builder setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
            return this;
        }

        public Builder setExperimentFactory(ExperimentFactory experimentFactory) {
            this.experimentFactory = experimentFactory;
            return this;
        }

        public Builder setStorageFactory(StorageFactory storageFactory) {
            this.storageFactory = storageFactory;
            return this;
        }

        public Builder setRestServiceFactory(RestServiceFactory restServiceFactory) {
            this.restServiceFactory = restServiceFactory;
            return this;
        }

        public Builder setAssumeScheduler(AssumeScheduler assumeScheduler) {
            this.assumeScheduler = assumeScheduler;
            return this;
        }

        private void buildDefaultAssumeScheduler() {
            if (this.assumeScheduler == null) {
                this.assumeScheduler = new DefaultAssumeScheduler.Builder().setIgnoreInvocationExceptions(this.experimentEngineConfig.isIgnoreInvocationExceptions()).build();
            }
        }

        public ExperimentEngine build() {
            this.buildDefaultAssumeScheduler();
            return new ExperimentEngineImpl(this);
        }
    }
}

