/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.craftsmenlabs.gareth.api.exception.GarethAlreadyKnownExperimentException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownExperimentException;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.api.registry.ExperimentRegistry;

public class ExperimentRegistryImpl
implements ExperimentRegistry {
    private final Map<String, Experiment> experiments = new HashMap<String, Experiment>();

    @Override
    public void addExperiment(String experimentName, Experiment experiment) {
        if (this.experiments.containsKey(experimentName)) {
            throw new GarethAlreadyKnownExperimentException(String.format("Experiment with name '%s' already known", experimentName));
        }
        this.experiments.put(experimentName, experiment);
    }

    @Override
    public Experiment getExperiment(String experimentName) {
        return Optional.ofNullable(this.experiments.get(experimentName)).orElseThrow(() -> new GarethUnknownExperimentException(String.format("Experiment '%s' unknown", experimentName)));
    }

    @Override
    public List<Experiment> getAllExperiments() {
        return new ArrayList<Experiment>(this.experiments.values());
    }

    public Map<String, Experiment> getExperiments() {
        return this.experiments;
    }
}

